/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.connectors.tcp.DefaultTcpConfiguration;
import com.mirth.connect.connectors.tcp.SocketUtil;
import com.mirth.connect.connectors.tcp.StateAwareSocketInterface;
import com.mirth.connect.connectors.tcp.TcpConfiguration;
import com.mirth.connect.connectors.tcp.TcpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ConnectorCountEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.StreamHandler;
import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.model.transmission.batch.DefaultBatchStreamReader;
import com.mirth.connect.plugins.BasicModeProvider;
import com.mirth.connect.plugins.TransmissionModeProvider;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.TcpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TcpDispatcher
extends DestinationConnector {
    private static final int DEFAULT_BACKLOG = 256;
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected TcpDispatcherProperties connectorProperties;
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private TcpConfiguration configuration = null;
    private Map<String, Socket> connectedSockets;
    private Map<String, Thread> timeoutThreads;
    private int sendTimeout;
    private int responseTimeout;
    private int bufferSize;
    TransmissionModeProvider transmissionModeProvider;
    private ServerSocket serverSocket;
    private Set<Socket> serverModeSockets = new HashSet<Socket>();
    private Thread thread;
    private int maxConnections;

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        TcpDispatcherProperties tcpSenderProperties = (TcpDispatcherProperties)connectorProperties;
        tcpSenderProperties.setRemoteAddress(this.replacer.replaceValues(tcpSenderProperties.getRemoteAddress(), connectorMessage));
        tcpSenderProperties.setRemotePort(this.replacer.replaceValues(tcpSenderProperties.getRemotePort(), connectorMessage));
        tcpSenderProperties.setLocalAddress(this.replacer.replaceValues(tcpSenderProperties.getLocalAddress(), connectorMessage));
        tcpSenderProperties.setLocalPort(this.replacer.replaceValues(tcpSenderProperties.getLocalPort(), connectorMessage));
        tcpSenderProperties.setTemplate(this.replacer.replaceValues(tcpSenderProperties.getTemplate(), connectorMessage));
    }

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (TcpDispatcherProperties)this.getConnectorProperties();
        String pluginPointName = this.connectorProperties.getTransmissionModeProperties().getPluginPointName();
        this.transmissionModeProvider = pluginPointName.equals("Basic") ? new BasicModeProvider() : (TransmissionModeProvider)ControllerFactory.getFactory().createExtensionController().getTransmissionModeProviders().get(pluginPointName);
        if (this.transmissionModeProvider == null) {
            throw new ConnectorTaskException("Unable to find transmission mode plugin: " + pluginPointName);
        }
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (TcpConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Throwable t) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultTcpConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.connectedSockets = new ConcurrentHashMap<String, Socket>();
        this.timeoutThreads = new ConcurrentHashMap<String, Thread>();
        this.sendTimeout = NumberUtils.toInt((String)this.connectorProperties.getSendTimeout());
        this.responseTimeout = NumberUtils.toInt((String)this.connectorProperties.getResponseTimeout());
        this.bufferSize = NumberUtils.toInt((String)this.connectorProperties.getBufferSize());
        this.maxConnections = NumberUtils.toInt((String)this.connectorProperties.getMaxConnections());
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
        if (this.connectorProperties.isServerMode()) {
            try {
                this.createServerSocket();
            }
            catch (IOException e) {
                throw new ConnectorTaskException("Failed to create server socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
            this.thread = new Thread("TCP Sender Server Acceptor Thread on " + this.getChannel().getName() + " (" + this.getChannelId() + ")"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        block12: {
                            try {
                                TcpDispatcher.this.logger.debug("Waiting for new client socket (" + TcpDispatcher.this.connectorProperties.getName() + " \"" + TcpDispatcher.this.getDestinationName() + "\" on channel " + TcpDispatcher.this.getChannelId() + ").");
                                Socket serverModeSocket = TcpDispatcher.this.serverSocket.accept();
                                TcpDispatcher.this.initSocket(serverModeSocket);
                                TcpDispatcher.this.logger.trace("Accepted new socket: " + serverModeSocket.getRemoteSocketAddress().toString() + " -> " + String.valueOf(serverModeSocket.getLocalSocketAddress()));
                                if (serverModeSocket instanceof StateAwareSocketInterface && ((StateAwareSocketInterface)((Object)serverModeSocket)).remoteSideHasClosed()) {
                                    TcpDispatcher.this.logger.debug("Remote side closed connection (" + TcpDispatcher.this.connectorProperties.getName() + " \"" + TcpDispatcher.this.getDestinationName() + "\" on channel " + TcpDispatcher.this.getChannelId() + ").");
                                    serverModeSocket.close();
                                    break block12;
                                }
                                Set<Socket> set = TcpDispatcher.this.serverModeSockets;
                                synchronized (set) {
                                    if (TcpDispatcher.this.serverModeSockets.size() < TcpDispatcher.this.maxConnections) {
                                        TcpDispatcher.this.serverModeSockets.add(serverModeSocket);
                                    } else {
                                        serverModeSocket.close();
                                        TcpDispatcher.this.logger.debug("Reached maximum connnections (" + TcpDispatcher.this.connectorProperties.getName() + " \"" + TcpDispatcher.this.getDestinationName() + "\" on channel " + TcpDispatcher.this.getChannelId() + ").");
                                    }
                                }
                            }
                            catch (InterruptedIOException e) {
                                TcpDispatcher.this.logger.debug("Interruption during server socket accept operation (" + TcpDispatcher.this.connectorProperties.getName() + " \"" + TcpDispatcher.this.getDestinationName() + "\" on channel " + TcpDispatcher.this.getChannelId() + ").", (Throwable)e);
                            }
                            catch (Exception e) {
                                TcpDispatcher.this.logger.debug("Error accepting new socket (" + TcpDispatcher.this.connectorProperties.getName() + " \"" + TcpDispatcher.this.getDestinationName() + "\" on channel " + TcpDispatcher.this.getChannelId() + ").", (Throwable)e);
                            }
                        }
                        try {
                            ThreadUtils.checkInterruptedStatus();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    } while (TcpDispatcher.this.getCurrentState() == DeployedState.STARTED);
                }
            };
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() throws ConnectorTaskException {
        ConnectorTaskException firstCause = null;
        if (this.connectorProperties.isServerMode()) {
            if (this.serverSocket != null) {
                try {
                    this.logger.debug("Closing server socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    firstCause = new ConnectorTaskException("Error closing server socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
                }
            }
            try {
                this.disposeThread(this.thread, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConnectorTaskException("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
            Set<Socket> e = this.serverModeSockets;
            synchronized (e) {
                for (Socket socket : this.serverModeSockets) {
                    try {
                        socket.close();
                    }
                    catch (IOException e2) {
                        if (firstCause != null) continue;
                        firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e2);
                    }
                }
                this.serverModeSockets.clear();
            }
        }
        try {
            for (String socketKey : this.timeoutThreads.keySet().toArray(new String[this.timeoutThreads.size()])) {
                this.disposeThread(socketKey);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectorTaskException((Throwable)e);
        }
        for (String socketKey : this.connectedSockets.keySet().toArray(new String[this.connectedSockets.size()])) {
            try {
                this.closeSocket(socketKey);
            }
            catch (IOException e) {
                if (firstCause != null) continue;
                firstCause = new ConnectorTaskException("Error closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHalt() throws ConnectorTaskException {
        ConnectorTaskException firstCause = null;
        if (this.connectorProperties.isServerMode()) {
            if (this.serverSocket != null) {
                try {
                    this.logger.debug("Closing server socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    firstCause = new ConnectorTaskException("Error closing server socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
                }
            }
            try {
                this.disposeThread(this.thread, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                firstCause = new ConnectorTaskException("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
            Set<Socket> set = this.serverModeSockets;
            synchronized (set) {
                for (Socket socket : this.serverModeSockets) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (firstCause != null) continue;
                        firstCause = new ConnectorTaskException("Error closing client socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
                    }
                }
                this.serverModeSockets.clear();
            }
        }
        for (String socketKey : this.timeoutThreads.keySet().toArray(new String[this.timeoutThreads.size()])) {
            try {
                this.disposeThread(socketKey);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                firstCause = new ConnectorTaskException("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
        }
        for (String socketKey : this.connectedSockets.keySet().toArray(new String[this.connectedSockets.size()])) {
            try {
                this.closeSocket(socketKey);
            }
            catch (IOException e) {
                if (firstCause != null) continue;
                firstCause = new ConnectorTaskException("Error closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage message) {
        Object info;
        TcpDispatcherProperties tcpDispatcherProperties = (TcpDispatcherProperties)connectorProperties;
        Status responseStatus = Status.QUEUED;
        String responseData = null;
        String responseStatusMessage = null;
        String responseError = null;
        boolean validateResponse = false;
        long dispatcherId = message.getDispatcherId();
        String socketKey = dispatcherId + tcpDispatcherProperties.getRemoteAddress() + tcpDispatcherProperties.getRemotePort();
        if (tcpDispatcherProperties.isOverrideLocalBinding()) {
            socketKey = socketKey + tcpDispatcherProperties.getLocalAddress() + tcpDispatcherProperties.getLocalPort();
        }
        Socket socket = null;
        Thread timeoutThread = null;
        Response response = null;
        try {
            if (!tcpDispatcherProperties.isServerMode()) {
                if (StringUtils.isBlank((CharSequence)tcpDispatcherProperties.getRemoteAddress())) {
                    throw new Exception("Remote address is blank.");
                }
                if (NumberUtils.toInt((String)tcpDispatcherProperties.getRemotePort()) <= 0) {
                    throw new Exception("Remote port is invalid.");
                }
                socket = this.connectedSockets.get(socketKey);
                timeoutThread = this.timeoutThreads.get(socketKey);
                if (tcpDispatcherProperties.isKeepConnectionOpen() && timeoutThread != null) {
                    this.disposeThreadQuietly(socketKey);
                }
                if (!tcpDispatcherProperties.isKeepConnectionOpen() || socket == null || socket.isClosed() || tcpDispatcherProperties.isCheckRemoteHost() && socket instanceof StateAwareSocketInterface && ((StateAwareSocketInterface)((Object)socket)).remoteSideHasClosed()) {
                    this.closeSocketQuietly(socketKey);
                    this.logger.debug("Creating new socket (" + connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                    info = "Trying to connect on " + tcpDispatcherProperties.getRemoteAddress() + ":" + tcpDispatcherProperties.getRemotePort() + "...";
                    this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.CONNECTING, (String)info));
                    socket = tcpDispatcherProperties.isOverrideLocalBinding() ? SocketUtil.createSocket(this.configuration, tcpDispatcherProperties.getLocalAddress(), NumberUtils.toInt((String)tcpDispatcherProperties.getLocalPort())) : SocketUtil.createSocket(this.configuration);
                    ThreadUtils.checkInterruptedStatus();
                    this.connectedSockets.put(socketKey, socket);
                    SocketUtil.connectSocket(socket, tcpDispatcherProperties.getRemoteAddress(), NumberUtils.toInt((String)tcpDispatcherProperties.getRemotePort()), this.responseTimeout);
                    socket.setReuseAddress(true);
                    socket.setReceiveBufferSize(this.bufferSize);
                    socket.setSendBufferSize(this.bufferSize);
                    socket.setSoTimeout(this.responseTimeout);
                    socket.setKeepAlive(tcpDispatcherProperties.isKeepConnectionOpen());
                    this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.CONNECTED, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), Boolean.valueOf(true)));
                }
            }
            ThreadUtils.checkInterruptedStatus();
            if (tcpDispatcherProperties.isServerMode()) {
                info = this.serverModeSockets;
                synchronized (info) {
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    int successes = 0;
                    for (Socket serverModeSocket : this.serverModeSockets) {
                        try {
                            if (serverModeSocket == null || serverModeSocket.isClosed() || serverModeSocket instanceof StateAwareSocketInterface && ((StateAwareSocketInterface)((Object)serverModeSocket)).remoteSideHasClosed()) {
                                this.closeServerModeSocketQuietly(serverModeSocket);
                            }
                        }
                        catch (IOException e) {
                            this.closeServerModeSocketQuietly(serverModeSocket);
                        }
                        if (serverModeSocket.isClosed()) continue;
                        Response currentResponse = this.send(tcpDispatcherProperties, message, serverModeSocket, socketKey);
                        responseList.add(currentResponse);
                        if (response == null) {
                            response = currentResponse;
                            if (response.getStatus() != Status.SENT) continue;
                            ++successes;
                            continue;
                        }
                        switch (currentResponse.getStatus()) {
                            case SENT: {
                                if (response.getStatus() != Status.SENT) {
                                    response = currentResponse;
                                }
                                ++successes;
                                break;
                            }
                            case QUEUED: {
                                if (response.getStatus() == Status.SENT) break;
                                response = currentResponse;
                                break;
                            }
                        }
                    }
                    response = response != null ? new Response(response) : new Response(responseStatus, null, responseStatusMessage, responseError, validateResponse);
                    response.setStatusMessage(this.getStatusMessage(responseList, response, successes));
                    Map connectorMap = message.getConnectorMap();
                    connectorMap.put("allResponses", responseList);
                    connectorMap.put("localAddress", this.getLocalAddress());
                    connectorMap.put("localPort", this.getLocalPort());
                    connectorMap.put("numberOfClients", responseList.size());
                    connectorMap.put("successfulSends", successes);
                    Iterator<Socket> iter = this.serverModeSockets.iterator();
                    while (iter.hasNext()) {
                        if (!iter.next().isClosed()) continue;
                        iter.remove();
                    }
                }
            }
            response = this.send(tcpDispatcherProperties, message, socket, socketKey);
            info = response;
        }
        catch (Throwable t) {
            Response response2;
            try {
                String monitorMessage = "Error sending message: " + t.getMessage();
                if (!tcpDispatcherProperties.isServerMode()) {
                    this.disposeThreadQuietly(socketKey);
                    this.closeSocketQuietly(socketKey);
                    monitorMessage = "Error sending message (" + SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket) + "): " + t.getMessage();
                }
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.FAILURE, monitorMessage));
                responseStatusMessage = t.getClass().getSimpleName() + ": " + t.getMessage();
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)t.getMessage(), (Throwable)t);
                String logMessage = "Error sending message via TCP (" + connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").";
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                } else if (t instanceof ConnectException || t.getCause() != null && t.getCause() instanceof ConnectException) {
                    if (this.isQueueEnabled()) {
                        this.logger.warn(logMessage, t);
                    } else {
                        this.logger.error(logMessage, t);
                    }
                } else {
                    this.logger.debug(logMessage, t);
                }
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error sending message via TCP.", t));
                response2 = new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
            }
            catch (Throwable throwable) {
                this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), (Boolean)null));
                throw throwable;
            }
            this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), (Boolean)null));
            return response2;
        }
        this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), (Boolean)null));
        return info;
    }

    private String getStatusMessage(List<Response> responseList, Response response, int successes) {
        Object responseString = "";
        if (response.getStatus() == Status.SENT) {
            responseString = "Message successfully sent to " + String.valueOf(successes) + " of " + responseList.size();
        } else if (response.getStatus() == Status.ERROR) {
            responseString = response.getStatusMessage();
        }
        return responseString;
    }

    private Response send(TcpDispatcherProperties tcpDispatcherProperties, ConnectorMessage message, Socket socket, String socketKey) {
        Status responseStatus = Status.QUEUED;
        String responseData = null;
        Object responseStatusMessage = null;
        String responseError = null;
        boolean validateResponse = false;
        try {
            block26: {
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.SENDING, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket)));
                BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream(), this.bufferSize);
                DefaultBatchStreamReader batchStreamReader = new DefaultBatchStreamReader(socket.getInputStream());
                StreamHandler streamHandler = this.transmissionModeProvider.getStreamHandler(socket.getInputStream(), (OutputStream)bos, (BatchStreamReader)batchStreamReader, tcpDispatcherProperties.getTransmissionModeProperties());
                streamHandler.write(this.getTemplateBytes(tcpDispatcherProperties, message));
                bos.flush();
                if (!tcpDispatcherProperties.isIgnoreResponse()) {
                    ThreadUtils.checkInterruptedStatus();
                    try {
                        String info = "Waiting for response from " + SocketUtil.getInetAddress(socket) + " (Timeout: " + tcpDispatcherProperties.getResponseTimeout() + " ms)... ";
                        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WAITING_FOR_RESPONSE, info));
                        byte[] responseBytes = streamHandler.read();
                        if (responseBytes != null) {
                            responseData = new String(responseBytes, CharsetUtils.getEncoding((String)tcpDispatcherProperties.getCharsetEncoding()));
                            responseStatusMessage = "Message successfully sent.";
                        } else {
                            responseStatusMessage = "Message successfully sent, but no response received.";
                        }
                        streamHandler.commit(true);
                        responseStatus = Status.SENT;
                        validateResponse = tcpDispatcherProperties.getDestinationConnectorProperties().isValidateResponse();
                    }
                    catch (IOException e) {
                        if (e instanceof SocketTimeoutException || e.getCause() != null && e.getCause() instanceof SocketTimeoutException) {
                            responseStatusMessage = "Timeout waiting for response";
                            if (!tcpDispatcherProperties.isQueueOnResponseTimeout()) {
                                responseStatus = Status.ERROR;
                            }
                        } else {
                            responseStatusMessage = "Error receiving response";
                        }
                        responseError = ErrorMessageBuilder.buildErrorMessage((String)this.connectorProperties.getName(), (String)((String)responseStatusMessage + ": " + e.getMessage()), (Throwable)e);
                        this.logger.warn((String)responseStatusMessage + " (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
                        this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), this.connectorProperties.getName(), (String)responseStatusMessage + ".", (Throwable)e));
                        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.FAILURE, (String)responseStatusMessage + " from " + SocketUtil.getInetAddress(socket)));
                        if (tcpDispatcherProperties.isServerMode()) {
                            this.closeServerModeSocketQuietly(socket);
                            break block26;
                        }
                        this.closeSocketQuietly(socketKey);
                    }
                } else {
                    try {
                        socket.getInputStream().skip(socket.getInputStream().available());
                    }
                    catch (IOException e) {
                        this.logger.warn("Error flushing socket input stream.", (Throwable)e);
                    }
                    responseStatus = Status.SENT;
                    responseStatusMessage = "Message successfully sent.";
                }
            }
            if (!tcpDispatcherProperties.isServerMode()) {
                if (tcpDispatcherProperties.isKeepConnectionOpen() && (this.getCurrentState() == DeployedState.STARTED || this.getCurrentState() == DeployedState.STARTING)) {
                    if (this.sendTimeout > 0) {
                        this.startThread(socketKey);
                    }
                } else {
                    this.closeSocketQuietly(socketKey);
                }
            }
        }
        catch (Throwable t) {
            if (tcpDispatcherProperties.isServerMode()) {
                this.closeServerModeSocketQuietly(socket);
            } else {
                this.disposeThreadQuietly(socketKey);
                this.closeSocketQuietly(socketKey);
            }
            String monitorMessage = "Error sending message (" + SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket) + "): " + t.getMessage();
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.FAILURE, monitorMessage));
            responseStatusMessage = t.getClass().getSimpleName() + ": " + t.getMessage();
            responseError = ErrorMessageBuilder.buildErrorMessage((String)this.connectorProperties.getName(), (String)t.getMessage(), (Throwable)t);
            String logMessage = "Error sending message via TCP (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").";
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            } else if (t instanceof ConnectException || t.getCause() != null && t.getCause() instanceof ConnectException) {
                if (this.isQueueEnabled()) {
                    this.logger.warn(logMessage, t);
                } else {
                    this.logger.error(logMessage, t);
                }
            } else {
                this.logger.debug(logMessage, t);
            }
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), this.connectorProperties.getName(), "Error sending message via TCP.", t));
        }
        return new Response(responseStatus, responseData, (String)responseStatusMessage, responseError, validateResponse);
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.connectorProperties.getProtocol(), "tcpConfigurationClass");
    }

    private void closeSocketQuietly(String socketKey) {
        try {
            this.closeSocket(socketKey);
        }
        catch (IOException e) {
            this.logger.debug("Error closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket(String socketKey) throws IOException {
        Socket socket = this.connectedSockets.get(socketKey);
        if (socket != null) {
            boolean wasOpen = socket.isConnected();
            try {
                if (wasOpen) {
                    this.logger.trace("Closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                    SocketUtil.closeSocket(socket);
                }
            }
            finally {
                this.connectedSockets.remove(socketKey);
                if (wasOpen) {
                    this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.DISCONNECTED, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), Boolean.valueOf(false)));
                }
            }
        }
    }

    private void closeServerModeSocketQuietly(Socket socket) {
        try {
            this.closeServerModeSocket(socket);
        }
        catch (IOException e) {
            this.logger.debug("Error closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
        }
    }

    private void closeServerModeSocket(Socket socket) throws IOException {
        if (socket != null) {
            boolean wasOpen = socket.isConnected();
            try {
                if (wasOpen) {
                    this.logger.trace("Closing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                    SocketUtil.closeSocket(socket);
                }
            }
            finally {
                if (wasOpen) {
                    this.eventController.dispatchEvent((Event)new ConnectorCountEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.DISCONNECTED, SocketUtil.getLocalAddress(socket) + " -> " + SocketUtil.getInetAddress(socket), Boolean.valueOf(false)));
                }
            }
        }
    }

    private void startThread(final String socketKey) {
        this.disposeThreadQuietly(socketKey);
        Thread thread = new Thread("TCP Dispatcher Send Timeout Thread for key " + socketKey){

            @Override
            public void run() {
                try {
                    Thread.sleep(TcpDispatcher.this.sendTimeout);
                    TcpDispatcher.this.closeSocketQuietly(socketKey);
                }
                catch (InterruptedException e) {
                    if (TcpDispatcher.this.getCurrentState() == DeployedState.STOPPING || TcpDispatcher.this.getCurrentState() == DeployedState.STOPPED) {
                        TcpDispatcher.this.closeSocketQuietly(socketKey);
                    }
                    Thread.currentThread().interrupt();
                }
                finally {
                    TcpDispatcher.this.timeoutThreads.remove(socketKey);
                }
            }
        };
        this.timeoutThreads.put(socketKey, thread);
        thread.start();
    }

    private void disposeThreadQuietly(String socketKey) {
        try {
            this.disposeThread(socketKey);
        }
        catch (InterruptedException e) {
            this.logger.warn("Thread join operation interrupted (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
        }
    }

    private void disposeThread(String socketKey) throws InterruptedException {
        Thread thread = this.timeoutThreads.get(socketKey);
        this.disposeThread(thread, true);
    }

    private void disposeThread(Thread thread, boolean interrupt) throws InterruptedException {
        if (thread != null && thread.isAlive()) {
            if (interrupt) {
                this.logger.trace("Interrupting thread (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
                thread.interrupt();
            }
            this.logger.trace("Joining thread (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    private byte[] getTemplateBytes(TcpDispatcherProperties tcpSenderProperties, ConnectorMessage connectorMessage) throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{};
        if (tcpSenderProperties.getTemplate() != null) {
            bytes = this.getAttachmentHandlerProvider().reAttachMessage(tcpSenderProperties.getTemplate(), connectorMessage, CharsetUtils.getEncoding((String)tcpSenderProperties.getCharsetEncoding()), tcpSenderProperties.isDataTypeBinary(), tcpSenderProperties.getDestinationConnectorProperties().isReattachAttachments());
        }
        return bytes;
    }

    private void createServerSocket() throws IOException {
        int backlog = 256;
        String host = this.getLocalAddress();
        int port = this.getLocalPort();
        InetAddress hostAddress = InetAddress.getByName(host);
        int bindAttempts = 0;
        boolean success = false;
        while (!success) {
            try {
                ++bindAttempts;
                this.serverSocket = this.configuration.createServerSocket(port, backlog, hostAddress);
                success = true;
            }
            catch (BindException e) {
                if (bindAttempts >= 10) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private String getLocalAddress() {
        return TcpUtil.getFixedHost((String)this.replacer.replaceValues(this.connectorProperties.getLocalAddress(), this.getChannelId(), this.getChannel().getName()));
    }

    private int getLocalPort() {
        return NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getLocalPort(), this.getChannelId(), this.getChannel().getName()));
    }

    private void initSocket(Socket socket) throws SocketException {
        this.logger.debug("Initializing socket (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").");
        socket.setReceiveBufferSize(this.bufferSize);
        socket.setSendBufferSize(this.bufferSize);
        socket.setSoTimeout(this.responseTimeout);
        socket.setKeepAlive(true);
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
    }
}

