/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.js;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.js.JavaScriptDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptWriter
extends ConnectorSettingsPanel {
    private MirthRTextScrollPane javaScriptTextScrollPane;
    private JLabel jsLabel;

    public JavaScriptWriter() {
        this.initComponents();
    }

    public String getConnectorName() {
        return new JavaScriptDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        JavaScriptDispatcherProperties properties = new JavaScriptDispatcherProperties();
        properties.setScript(this.javaScriptTextScrollPane.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        JavaScriptDispatcherProperties props = (JavaScriptDispatcherProperties)properties;
        this.javaScriptTextScrollPane.setText(props.getScript());
    }

    public ConnectorProperties getDefaults() {
        return new JavaScriptDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        JavaScriptDispatcherProperties props = (JavaScriptDispatcherProperties)properties;
        boolean valid = true;
        if (props.getScript().length() == 0) {
            valid = false;
            if (highlight) {
                this.javaScriptTextScrollPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public VariableListHandler.TransferMode getTransferMode() {
        return VariableListHandler.TransferMode.JAVASCRIPT;
    }

    public void resetInvalidProperties() {
        this.javaScriptTextScrollPane.setBackground(null);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.javaScriptTextScrollPane.updateDisplayOptions();
    }

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        JavaScriptDispatcherProperties props = (JavaScriptDispatcherProperties)properties;
        Object error = null;
        String script = props.getScript();
        if (script.length() != 0) {
            Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
            try {
                context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
            }
            catch (EvaluatorException e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getName() + "\" at Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n";
            }
            catch (Exception e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getName() + "\" at Javascript:\nUnknown error occurred during validation.";
            }
            Context.exit();
        }
        return error;
    }

    public List<String> getScripts(ConnectorProperties properties) {
        JavaScriptDispatcherProperties props = (JavaScriptDispatcherProperties)properties;
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add(props.getScript());
        return scripts;
    }

    private void initComponents() {
        this.jsLabel = new JLabel();
        this.javaScriptTextScrollPane = new MirthRTextScrollPane(ContextType.DESTINATION_DISPATCHER);
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jsLabel.setText("JavaScript:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.javaScriptTextScrollPane, -1, 327, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jsLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent((Component)this.javaScriptTextScrollPane, -1, 259, Short.MAX_VALUE)).addContainerGap()));
    }
}

