/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.edi;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class EDIXMLHandler
extends DefaultHandler {
    private String segmentDelimiter;
    private String elementDelimiter;
    private String subelementDelimiter;
    private Location currentLocation = Location.DOCUMENT;
    private boolean sawHeader = false;
    private boolean lastInSubelement = false;
    private String[] previousSegmentNameArray = null;
    private String[] previousElementNameArray = null;
    private StringBuilder output = new StringBuilder();

    @Override
    public void startDocument() {
        this.currentLocation = Location.DOCUMENT;
    }

    @Override
    public void endDocument() {
        this.currentLocation = Location.DOCUMENT;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (!this.sawHeader) {
            this.segmentDelimiter = atts.getValue("segmentDelimiter");
            this.elementDelimiter = atts.getValue("elementDelimiter");
            this.subelementDelimiter = atts.getValue("subelementDelimiter");
            if (this.segmentDelimiter == null) {
                this.segmentDelimiter = "~";
            }
            if (this.elementDelimiter == null) {
                this.elementDelimiter = "*";
            }
            if (this.subelementDelimiter == null) {
                this.subelementDelimiter = ":";
            }
            this.sawHeader = true;
        } else if (this.currentLocation.equals((Object)Location.DOCUMENT)) {
            this.output.append(name);
            this.currentLocation = Location.SEGMENT;
            this.lastInSubelement = false;
            this.previousSegmentNameArray = null;
        } else if (this.currentLocation.equals((Object)Location.SEGMENT)) {
            String[] currentNameArray = StringUtils.split((String)name, (String)".");
            int currentDelimeterCount = currentNameArray.length - 1;
            if (currentDelimeterCount == 1) {
                int previousId = 0;
                if (this.previousSegmentNameArray != null) {
                    previousId = NumberUtils.toInt((String)this.previousSegmentNameArray[1]);
                }
                int currentId = NumberUtils.toInt((String)currentNameArray[1]);
                for (int i = 1; i < currentId - previousId; ++i) {
                    this.output.append(this.elementDelimiter);
                }
                this.previousSegmentNameArray = currentNameArray;
            }
            this.output.append(this.elementDelimiter);
            this.currentLocation = Location.ELEMENT;
            this.lastInSubelement = false;
            this.previousElementNameArray = null;
        } else if (this.currentLocation.equals((Object)Location.ELEMENT)) {
            String[] currentNameArray = StringUtils.split((String)name, (String)".");
            int currentDelimeterCount = currentNameArray.length - 1;
            if (currentDelimeterCount == 2) {
                int previousId = 0;
                if (this.previousElementNameArray != null) {
                    previousId = NumberUtils.toInt((String)this.previousElementNameArray[2]);
                }
                int currentId = NumberUtils.toInt((String)currentNameArray[2]);
                for (int i = 1; i < currentId - previousId; ++i) {
                    this.output.append(this.subelementDelimiter);
                }
                this.previousElementNameArray = currentNameArray;
            }
            if (this.lastInSubelement) {
                this.output.append(this.subelementDelimiter);
            }
            this.currentLocation = Location.SUBELEMENT;
            this.lastInSubelement = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.currentLocation.equals((Object)Location.SEGMENT)) {
            this.output.append(this.segmentDelimiter);
            this.currentLocation = Location.DOCUMENT;
        } else if (this.currentLocation.equals((Object)Location.ELEMENT)) {
            this.currentLocation = Location.SEGMENT;
        } else if (this.currentLocation.equals((Object)Location.SUBELEMENT)) {
            this.currentLocation = Location.ELEMENT;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.output.append(ch, start, length);
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    public void setOutput(StringBuilder output) {
        this.output = output;
    }

    private static enum Location {
        DOCUMENT,
        SEGMENT,
        ELEMENT,
        SUBELEMENT;

    }
}

