/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.datatype.BatchProperties;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import com.mirth.connect.model.datatype.PropertyEditorType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelimitedBatchProperties
extends BatchProperties {
    private transient Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private SplitType splitType = SplitType.values()[0];
    private int batchSkipRecords = 0;
    private String batchMessageDelimiter = "";
    private boolean batchMessageDelimiterIncluded = false;
    private String batchGroupingColumn = "";
    private String batchScript = "";

    public Map<String, DataTypePropertyDescriptor> getPropertyDescriptors() {
        LinkedHashMap<String, DataTypePropertyDescriptor> properties = new LinkedHashMap<String, DataTypePropertyDescriptor>();
        properties.put("splitType", new DataTypePropertyDescriptor((Object)this.splitType, "Split Batch By", "Select the method for splitting the batch message.  This option has no effect unless Process Batch is enabled in the connector.\n\nRecord: Treat each record as a message.  Records are separated by the record delimiter.\n\nDelimiter: Use the Batch Delimiter to separate messages.\n\nGrouping Column: Use a column to group multiple records into a single message.  When the specified column value changes, this signifies the boundary between messages.\n\nJavaScript: Use JavaScript to split messages.", PropertyEditorType.OPTION, (Object[])SplitType.values()));
        properties.put("batchSkipRecords", new DataTypePropertyDescriptor((Object)Integer.toString(this.batchSkipRecords), "Number of Header Records", "The number of header records to skip.  By default, no header records are skipped.  This option has no effect unless Process Batch is enabled in the connector.", PropertyEditorType.STRING));
        properties.put("batchMessageDelimiter", new DataTypePropertyDescriptor((Object)this.batchMessageDelimiter, "Batch Delimiter", "The delimiter that separates messages.  The batch delimiter may be a sequence of characters.  This option has no effect unless Process Batch is enabled in the connector.", PropertyEditorType.STRING));
        properties.put("batchMessageDelimiterIncluded", new DataTypePropertyDescriptor((Object)this.batchMessageDelimiterIncluded, "Include Batch Delimiter", "Check to include the batch delimiter in the message returned by the batch processer.  By default, batch delimiters are consumed.  This option has no effect unless Process Batch is enabled in the connector.", PropertyEditorType.BOOLEAN));
        properties.put("batchGroupingColumn", new DataTypePropertyDescriptor((Object)this.batchGroupingColumn, "Grouping Column", "The name of the column used to group multiple records into a single message.  When the specified column value changes, this signifies the boundary between messages.  This option has no effect unless Process Batch is enabled in the connector.", PropertyEditorType.STRING));
        properties.put("batchScript", new DataTypePropertyDescriptor((Object)this.batchScript, "JavaScript", "Enter JavaScript that splits the batch, and returns the next message.  This script has access to 'reader', a Java BufferedReader, to read the incoming data stream.  The script must return a string containing the next message, or a null/empty string to indicate end of input.  This option has no effect unless Process Batch is enabled in the connector.", PropertyEditorType.JAVASCRIPT));
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            if (properties.get("splitType") != null) {
                this.splitType = (SplitType)((Object)properties.get("splitType"));
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("batchSkipRecords")))) {
                try {
                    this.batchSkipRecords = Integer.parseInt((String)properties.get("batchSkipRecords"));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Invalid number format in Number of Header Records: " + (String)properties.get("batchSkipRecords"));
                }
            }
            if (properties.get("batchMessageDelimiter") != null) {
                this.batchMessageDelimiter = (String)properties.get("batchMessageDelimiter");
            }
            if (properties.get("batchMessageDelimiterIncluded") != null) {
                this.batchMessageDelimiterIncluded = (Boolean)properties.get("batchMessageDelimiterIncluded");
            }
            if (properties.get("batchGroupingColumn") != null) {
                this.batchGroupingColumn = (String)properties.get("batchGroupingColumn");
            }
            if (properties.get("batchScript") != null) {
                this.batchScript = (String)properties.get("batchScript");
            }
        }
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public void setSplitType(SplitType splitType) {
        this.splitType = splitType;
    }

    public int getBatchSkipRecords() {
        return this.batchSkipRecords;
    }

    public void setBatchSkipRecords(int batchSkipRecords) {
        this.batchSkipRecords = batchSkipRecords;
    }

    public String getBatchMessageDelimiter() {
        return this.batchMessageDelimiter;
    }

    public void setBatchMessageDelimiter(String batchMessageDelimiter) {
        this.batchMessageDelimiter = batchMessageDelimiter;
    }

    public boolean isBatchMessageDelimiterIncluded() {
        return this.batchMessageDelimiterIncluded;
    }

    public void setBatchMessageDelimiterIncluded(boolean batchMessageDelimiterIncluded) {
        this.batchMessageDelimiterIncluded = batchMessageDelimiterIncluded;
    }

    public String getBatchGroupingColumn() {
        return this.batchGroupingColumn;
    }

    public void setBatchGroupingColumn(String batchGroupingColumn) {
        this.batchGroupingColumn = batchGroupingColumn;
    }

    public String getBatchScript() {
        return this.batchScript;
    }

    public void setBatchScript(String batchScript) {
        this.batchScript = batchScript;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        String splitType = "Record";
        DonkeyElement splitByRecordElement = element.removeChild("batchSplitByRecord");
        if (splitByRecordElement != null && StringUtils.equalsIgnoreCase((CharSequence)splitByRecordElement.getTextContent(), (CharSequence)"false")) {
            if (StringUtils.isNotEmpty((CharSequence)element.getChildElement("batchMessageDelimiter").getTextContent())) {
                splitType = "Delimiter";
            } else if (StringUtils.isNotEmpty((CharSequence)element.getChildElement("batchGroupingColumn").getTextContent())) {
                splitType = "Grouping_Column";
            } else if (StringUtils.isNotEmpty((CharSequence)element.getChildElement("batchScript").getTextContent())) {
                splitType = "JavaScript";
            }
        }
        element.addChildElementIfNotExists("splitType", splitType);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("splitType", (Object)this.splitType);
        purgedProperties.put("batchSkipRecords", this.batchSkipRecords);
        purgedProperties.put("batchMessageDelimiterIncluded", this.batchMessageDelimiterIncluded);
        purgedProperties.put("batchScriptLines", PurgeUtil.countLines((String)this.batchScript));
        return purgedProperties;
    }

    public static enum SplitType {
        Record,
        Delimiter,
        Grouping_Column,
        JavaScript;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }
}

