/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import software.amazon.awssdk.regions.Region;

public class AdvancedS3SettingsDialog
extends AdvancedSettingsDialog {
    private final String NAME_COLUMN_NAME = "Name";
    private final String VALUE_COLUMN_NAME = "Value";
    private boolean saved;
    private boolean anonymous;
    private boolean updatingRegion;
    private JLabel useDefaultCredentialProviderChainLabel;
    private JLabel anonymousWarningLabel;
    private JRadioButton useDefaultCredentialProviderChainYesRadio;
    private JRadioButton useDefaultCredentialProviderChainNoRadio;
    private JLabel useTemporaryCredentialsLabel;
    private JRadioButton useTemporaryCredentialsYesRadio;
    private JRadioButton useTemporaryCredentialsNoRadio;
    private ButtonGroup useTemporaryCredentialsButtonGroup;
    private JLabel durationLabel;
    private JTextField durationField;
    private JLabel regionLabel;
    private JTextField regionField;
    private JComboBox<String> regionComboBox;
    private JLabel customHttpHeadersLabel;
    private MirthTable customHttpHeadersTable;
    private JScrollPane customHttpHeadersScrollPane;
    private JButton newButton;
    private JButton deleteButton;
    private JButton okButton;
    private JButton cancelButton;

    public AdvancedS3SettingsDialog(S3SchemeProperties schemeProperties, boolean anonymous) {
        this.anonymous = anonymous;
        this.setTitle("S3 Advanced Settings");
        this.setDefaultCloseOperation(2);
        this.setLayout((LayoutManager)new MigLayout("insets 8 8 0 8, novisualpadding, hidemode 3"));
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        this.initLayout();
        if (anonymous) {
            this.useDefaultCredentialProviderChainLabel.setEnabled(false);
            this.anonymousWarningLabel.setVisible(true);
            this.useDefaultCredentialProviderChainYesRadio.setEnabled(false);
            this.useDefaultCredentialProviderChainNoRadio.setEnabled(false);
            this.useTemporaryCredentialsLabel.setEnabled(false);
            this.useTemporaryCredentialsYesRadio.setEnabled(false);
            this.useTemporaryCredentialsNoRadio.setEnabled(false);
            this.durationLabel.setEnabled(false);
            this.durationField.setEnabled(false);
        } else {
            this.anonymousWarningLabel.setVisible(false);
        }
        this.setFileSchemeProperties(schemeProperties);
        this.durationField.setBackground(null);
        this.setPreferredSize(new Dimension(600, 400));
        this.pack();
        this.setLocationRelativeTo((Component)PlatformUI.MIRTH_FRAME);
        this.setVisible(true);
    }

    @Override
    public boolean wasSaved() {
        return this.saved;
    }

    @Override
    public SchemeProperties getSchemeProperties() {
        S3SchemeProperties props = new S3SchemeProperties();
        props.setUseDefaultCredentialProviderChain(this.useDefaultCredentialProviderChainYesRadio.isSelected());
        if (this.useTemporaryCredentialsYesRadio.isSelected()) {
            props.setUseTemporaryCredentials(true);
        } else if (this.useTemporaryCredentialsNoRadio.isSelected()) {
            props.setUseTemporaryCredentials(false);
        }
        props.setDuration(NumberUtils.toInt((String)this.durationField.getText(), (int)7200));
        props.setRegion(this.regionField.getText());
        LinkedHashMap<String, ArrayList<String>> headers = new LinkedHashMap<String, ArrayList<String>>();
        for (int rowCount = 0; rowCount < this.customHttpHeadersTable.getRowCount(); ++rowCount) {
            String name = (String)this.customHttpHeadersTable.getValueAt(rowCount, 0);
            ArrayList<String> values = (ArrayList<String>)headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                headers.put(name, values);
            }
            values.add((String)this.customHttpHeadersTable.getValueAt(rowCount, 1));
        }
        props.setCustomHeaders(headers);
        return props;
    }

    public void setFileSchemeProperties(S3SchemeProperties schemeProperties) {
        if (schemeProperties.isUseDefaultCredentialProviderChain()) {
            this.useDefaultCredentialProviderChainYesRadio.setSelected(true);
        } else {
            this.useDefaultCredentialProviderChainNoRadio.setSelected(true);
        }
        if (schemeProperties.isUseTemporaryCredentials()) {
            this.useTemporaryCredentialsYesRadio.setSelected(true);
        } else {
            this.useTemporaryCredentialsNoRadio.setSelected(true);
        }
        this.useTemporaryRadioButtonActionPerformed();
        this.durationField.setText("" + schemeProperties.getDuration());
        this.updatingRegion = true;
        try {
            this.regionField.setText(schemeProperties.getRegion());
            this.regionFieldUpdated();
        }
        finally {
            this.updatingRegion = false;
        }
        Map headers = schemeProperties.getCustomHeaders();
        if (headers != null && headers.size() > 0) {
            DefaultTableModel model = (DefaultTableModel)this.customHttpHeadersTable.getModel();
            model.setNumRows(0);
            for (Map.Entry entry : headers.entrySet()) {
                List values = (List)entry.getValue();
                for (String value : values) {
                    model.addRow(new Object[]{entry.getKey(), value});
                }
            }
            this.deleteButton.setEnabled(true);
        } else {
            this.customHttpHeadersTable.setModel((TableModel)new RefreshTableModel(new Object[0][1], (Object[])new String[]{"Name", "Value"}));
            this.customHttpHeadersTable.getColumnModel().getColumn(this.customHttpHeadersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new CustomHttpHeadersTableCellEditor(true)));
            this.customHttpHeadersTable.getColumnModel().getColumn(this.customHttpHeadersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new CustomHttpHeadersTableCellEditor(false)));
        }
        this.useTemporaryRadioButtonActionPerformed();
    }

    public boolean validateProperties() {
        boolean valid = true;
        Object errors = "";
        this.durationField.setBackground(null);
        if (this.useTemporaryCredentialsYesRadio.isSelected()) {
            if (StringUtils.isBlank((CharSequence)this.durationField.getText())) {
                valid = false;
                errors = (String)errors + "Duration cannot be blank.\n";
                this.durationField.setBackground(UIConstants.INVALID_COLOR);
            } else {
                int duration = NumberUtils.toInt((String)this.durationField.getText(), (int)0);
                if (duration < 900 || duration > 129600) {
                    valid = false;
                    errors = (String)errors + "Duration must be between 900 seconds (15 minutes) and 129600 seconds (36 hours).\n";
                    this.durationField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)this.regionField.getText())) {
            valid = false;
            errors = (String)errors + "Region cannot be blank.\n";
            this.regionField.setBackground(UIConstants.INVALID_COLOR);
        } else {
            this.regionField.setBackground(null);
        }
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), (String)errors);
            return valid;
        }
        return valid;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useDefaultCredentialProviderChainLabel = new JLabel("Use Default Credential Provider Chain:");
        ButtonGroup useDefaultCredentialProviderChainButtonGroup = new ButtonGroup();
        String toolTipText = "<html>If enabled and no explicit credentials are provided, the default provider chain looks for credentials in this order:<br/><ul><li><b>Java system properties:</b> aws.accessKeyId and aws.secretAccessKey.</li><li><b>Environment variables:</b> AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.</li><li><b>Default credentials profile file:</b> Typically located at ~/.aws/credentials (location can vary per platform).</li><li><b>ECS container credentials:</b> Loaded from an Amazon ECS environment variable.</li><li><b>Instance profile credentials:</b> Loaded from the EC2 metadata service.</li></ul></html>";
        this.anonymousWarningLabel = new JLabel("Anonymous credentials are currently in use");
        this.anonymousWarningLabel.setForeground(Color.RED);
        this.useDefaultCredentialProviderChainYesRadio = new JRadioButton("Yes");
        this.useDefaultCredentialProviderChainYesRadio.setBackground(this.getBackground());
        this.useDefaultCredentialProviderChainYesRadio.setToolTipText(toolTipText);
        useDefaultCredentialProviderChainButtonGroup.add(this.useDefaultCredentialProviderChainYesRadio);
        this.useDefaultCredentialProviderChainNoRadio = new JRadioButton("No");
        this.useDefaultCredentialProviderChainNoRadio.setBackground(this.getBackground());
        this.useDefaultCredentialProviderChainNoRadio.setToolTipText(toolTipText);
        useDefaultCredentialProviderChainButtonGroup.add(this.useDefaultCredentialProviderChainNoRadio);
        this.useTemporaryCredentialsLabel = new JLabel("Use Temporary Credentials:");
        this.useTemporaryCredentialsYesRadio = new JRadioButton("Yes");
        this.useTemporaryCredentialsYesRadio.setSelected(true);
        this.useTemporaryCredentialsYesRadio.setFocusable(false);
        this.useTemporaryCredentialsYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useTemporaryCredentialsYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useTemporaryCredentialsYesRadio.setToolTipText("Select whether or not to use temporary credentials.");
        this.useTemporaryCredentialsYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedS3SettingsDialog.this.useTemporaryRadioButtonActionPerformed();
            }
        });
        this.useTemporaryCredentialsNoRadio = new JRadioButton("No");
        this.useTemporaryCredentialsNoRadio.setFocusable(false);
        this.useTemporaryCredentialsNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.useTemporaryCredentialsNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useTemporaryCredentialsNoRadio.setToolTipText("Select whether or not to use temporary credentials.");
        this.useTemporaryCredentialsNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedS3SettingsDialog.this.useTemporaryRadioButtonActionPerformed();
            }
        });
        this.useTemporaryCredentialsButtonGroup = new ButtonGroup();
        this.useTemporaryCredentialsButtonGroup.add(this.useTemporaryCredentialsYesRadio);
        this.useTemporaryCredentialsButtonGroup.add(this.useTemporaryCredentialsNoRadio);
        this.durationLabel = new JLabel("Duration (seconds):");
        this.durationField = new JTextField();
        this.durationField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.durationField.setToolTipText("<html>The duration that the temporary credentials are valid. Must be<br/>between 900 seconds (15 minutes) and 129600 seconds (36 hours).</html>");
        this.regionLabel = new JLabel("Region:");
        this.regionField = new JTextField();
        this.regionField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.update();
            }

            private void update() {
                if (!AdvancedS3SettingsDialog.this.updatingRegion) {
                    AdvancedS3SettingsDialog.this.updatingRegion = true;
                    try {
                        AdvancedS3SettingsDialog.this.regionFieldUpdated();
                    }
                    finally {
                        AdvancedS3SettingsDialog.this.updatingRegion = false;
                    }
                }
            }
        });
        ArrayList<String> regions = new ArrayList<String>();
        regions.add("Custom");
        for (Region region : Region.regions()) {
            regions.add(region.id());
        }
        this.regionComboBox = new JComboBox();
        this.regionComboBox.setModel(new DefaultComboBoxModel<String>(regions.toArray(new String[regions.size()])));
        this.regionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!AdvancedS3SettingsDialog.this.updatingRegion) {
                    AdvancedS3SettingsDialog.this.updatingRegion = true;
                    try {
                        String selectedRegion = (String)AdvancedS3SettingsDialog.this.regionComboBox.getSelectedItem();
                        if (!StringUtils.equals((CharSequence)selectedRegion, (CharSequence)"Custom")) {
                            AdvancedS3SettingsDialog.this.regionComboBoxActionPerformed();
                        }
                    }
                    finally {
                        AdvancedS3SettingsDialog.this.updatingRegion = false;
                    }
                }
            }
        });
        this.customHttpHeadersLabel = new JLabel("Custom HTTP Headers:");
        this.customHttpHeadersTable = new MirthTable();
        Object[][] tableData = new Object[0][1];
        this.customHttpHeadersTable.setModel((TableModel)new RefreshTableModel(tableData, (Object[])new String[]{"Name", "Value"}));
        this.customHttpHeadersTable.setOpaque(true);
        this.customHttpHeadersTable.getColumnModel().getColumn(this.customHttpHeadersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new CustomHttpHeadersTableCellEditor(true)));
        this.customHttpHeadersTable.getColumnModel().getColumn(this.customHttpHeadersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new CustomHttpHeadersTableCellEditor(false)));
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.customHttpHeadersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.customHttpHeadersTable.setToolTipText("These headers will be included on all PUT requests (writing objects).");
        this.customHttpHeadersTable.getTableHeader().setToolTipText(this.customHttpHeadersTable.getToolTipText());
        this.customHttpHeadersScrollPane = new JScrollPane();
        this.customHttpHeadersScrollPane.getViewport().add((Component)this.customHttpHeadersTable);
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableModel model = (DefaultTableModel)AdvancedS3SettingsDialog.this.customHttpHeadersTable.getModel();
                Vector<CallSite> row = new Vector<CallSite>();
                String header = "Property";
                for (int i = 1; i <= AdvancedS3SettingsDialog.this.customHttpHeadersTable.getRowCount() + 1; ++i) {
                    boolean exists = false;
                    for (int index = 0; index < AdvancedS3SettingsDialog.this.customHttpHeadersTable.getRowCount(); ++index) {
                        if (!((String)AdvancedS3SettingsDialog.this.customHttpHeadersTable.getValueAt(index, 0)).equalsIgnoreCase(header + i)) continue;
                        exists = true;
                    }
                    if (exists) continue;
                    row.add((CallSite)((Object)(header + i)));
                    break;
                }
                model.addRow(row);
                int rowSelectionNumber = AdvancedS3SettingsDialog.this.customHttpHeadersTable.getRowCount() - 1;
                AdvancedS3SettingsDialog.this.customHttpHeadersTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                Boolean enabled = AdvancedS3SettingsDialog.this.deleteButton.isEnabled();
                if (!enabled.booleanValue()) {
                    AdvancedS3SettingsDialog.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSelectionNumber = AdvancedS3SettingsDialog.this.customHttpHeadersTable.getSelectedRow();
                if (rowSelectionNumber > -1) {
                    DefaultTableModel model = (DefaultTableModel)AdvancedS3SettingsDialog.this.customHttpHeadersTable.getModel();
                    model.removeRow(rowSelectionNumber);
                    if (--rowSelectionNumber > -1) {
                        AdvancedS3SettingsDialog.this.customHttpHeadersTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                    }
                    if (AdvancedS3SettingsDialog.this.customHttpHeadersTable.getRowCount() == 0) {
                        AdvancedS3SettingsDialog.this.deleteButton.setEnabled(false);
                    }
                }
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedS3SettingsDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedS3SettingsDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gapy 6", "[right]13[grow]", "[][][][grow]"));
        propertiesPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "Amazon S3 Advanced Settings", 0, 0, new Font("Tahoma", 1, 11)));
        propertiesPanel.add(this.useDefaultCredentialProviderChainLabel);
        propertiesPanel.add((Component)this.useDefaultCredentialProviderChainYesRadio, "split 3");
        propertiesPanel.add(this.useDefaultCredentialProviderChainNoRadio);
        propertiesPanel.add((Component)this.anonymousWarningLabel, "gapleft 12");
        propertiesPanel.add((Component)this.useTemporaryCredentialsLabel, "newline");
        propertiesPanel.add((Component)this.useTemporaryCredentialsYesRadio, "split 2");
        propertiesPanel.add(this.useTemporaryCredentialsNoRadio);
        propertiesPanel.add((Component)this.durationLabel, "newline");
        propertiesPanel.add((Component)this.durationField, "w 100!");
        propertiesPanel.add((Component)this.regionLabel, "newline");
        propertiesPanel.add((Component)this.regionField, "w 100!, split 2");
        propertiesPanel.add(this.regionComboBox);
        propertiesPanel.add((Component)this.customHttpHeadersLabel, "newline, aligny top");
        propertiesPanel.add((Component)this.customHttpHeadersScrollPane, "span, grow, split 2");
        JPanel customHttpHeadersButtonPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        customHttpHeadersButtonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        customHttpHeadersButtonPanel.add((Component)this.newButton, "w 50!, wrap");
        customHttpHeadersButtonPanel.add((Component)this.deleteButton, "w 50!");
        propertiesPanel.add((Component)customHttpHeadersButtonPanel, "top");
        this.add(propertiesPanel, "grow, push, top, wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0 8 8 8, novisualpadding, hidemode 3, fill"));
        buttonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        buttonPanel.add((Component)new JSeparator(), "growx, sx, wrap");
        buttonPanel.add((Component)this.okButton, "newline, w 50!, sx, right, split");
        buttonPanel.add((Component)this.cancelButton, "w 50!");
        this.add(buttonPanel, "south, span");
    }

    private void useTemporaryRadioButtonActionPerformed() {
        this.durationLabel.setEnabled(this.useTemporaryCredentialsYesRadio.isSelected() && !this.anonymous);
        this.durationField.setEnabled(this.useTemporaryCredentialsYesRadio.isSelected() && !this.anonymous);
    }

    private void regionFieldUpdated() {
        String region = this.regionField.getText();
        if (this.isCustomRegion(region)) {
            this.regionComboBox.setSelectedItem("Custom");
        } else {
            this.regionComboBox.setSelectedItem(region);
        }
    }

    private boolean isCustomRegion(String region) {
        for (Region regionValue : Region.regions()) {
            if (!StringUtils.equals((CharSequence)region, (CharSequence)regionValue.id())) continue;
            return false;
        }
        return true;
    }

    private void regionComboBoxActionPerformed() {
        this.regionField.setText((String)this.regionComboBox.getSelectedItem());
    }

    private void okButtonActionPerformed() {
        if (this.customHttpHeadersTable.isEditing()) {
            this.customHttpHeadersTable.getCellEditor().stopCellEditing();
        }
        if (!this.validateProperties()) {
            return;
        }
        this.saved = true;
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.dispose();
    }

    class CustomHttpHeadersTableCellEditor
    extends TextFieldCellEditor {
        boolean checkProperties;

        public CustomHttpHeadersTableCellEditor(boolean checkProperties) {
            this.checkProperties = checkProperties;
        }

        public boolean isCellEditable(EventObject evt) {
            boolean editable = super.isCellEditable(evt);
            if (editable) {
                AdvancedS3SettingsDialog.this.deleteButton.setEnabled(false);
            }
            return editable;
        }

        protected boolean valueChanged(String value) {
            AdvancedS3SettingsDialog.this.deleteButton.setEnabled(true);
            return !this.checkProperties || value.length() != 0;
        }
    }
}

