/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.cache;

import com.mirth.connect.plugins.dynamiclookup.server.cache.FifoCache;
import com.mirth.connect.plugins.dynamiclookup.server.cache.SimpleCache;
import java.util.Collections;
import java.util.Map;

public class FifoCacheWrapper<K, V>
implements SimpleCache<K, V> {
    private final Map<K, V> map;

    public FifoCacheWrapper(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("FifoCache maxSize must be > 0");
        }
        this.map = Collections.synchronizedMap(new FifoCache(n));
    }

    @Override
    public V get(K k) {
        return this.map.get(k);
    }

    @Override
    public void put(K k, V v) {
        this.map.put(k, v);
    }

    @Override
    public void remove(K k) {
        this.map.remove(k);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

