/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.dao.impl;

import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupValueDao;
import com.mirth.connect.plugins.dynamiclookup.server.exception.ValueOperationException;
import com.mirth.connect.plugins.dynamiclookup.server.util.DatabaseDialect;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;

public class MyBatisLookupValueDao
implements LookupValueDao {
    private SqlSessionManager sqlSessionManager;
    DatabaseDialect.DatabaseType dbType;

    public MyBatisLookupValueDao(SqlSessionManager sqlSessionManager, DatabaseDialect.DatabaseType databaseType) {
        this.sqlSessionManager = sqlSessionManager;
        this.dbType = databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupValue getLookupValue(String string, String string2) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            LookupValue lookupValue = (LookupValue)sqlSession.selectOne("Lookup.getLookupValue", hashMap);
            return lookupValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String string, String string2) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            String string3 = (String)sqlSession.selectOne("Lookup.getValue", hashMap);
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupValue> getAllValues(String string) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            List list = sqlSession.selectList("Lookup.getLookupValues", hashMap);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupValue> searchLookupValues(String string, Integer n, Integer n2, String string2) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tableName", string);
            hashMap.put("offset", n);
            hashMap.put("limit", n2);
            hashMap.put("pattern", string2);
            List list = sqlSession.selectList("Lookup.searchLookupValues", hashMap);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupValue> getMatchingValues(String string, String string2) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyPattern", string2);
            List list = sqlSession.selectList("Lookup.getMatchingLookupValues", hashMap);
            return list;
        }
    }

    @Override
    public List<String> getKeys(String string, String string2) {
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertValue(String string, String string2, String string3) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            hashMap.put("valueData", string3);
            sqlSession.insert("Lookup.insertValue", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(String string, String string2, String string3) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            hashMap.put("valueData", string3);
            sqlSession.insert("Lookup.updateValue", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValue(String string, String string2) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            sqlSession.delete("Lookup.deleteValue", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllValues(String string) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            sqlSession.delete("Lookup.deleteAllValues", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    @Override
    public int importValues(String string, Map<String, String> map) {
        int n = 0;
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        Set<String> set = this.findExistingKeys(string, map.keySet());
        if (!set.isEmpty()) {
            for (String object : set) {
                map.remove(object);
            }
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("tableName", string);
                hashMap.put("keyValue", entry.getKey());
                hashMap.put("valueData", entry.getValue());
                try {
                    int n2 = sqlSession.insert("Lookup.insertValue", hashMap);
                    n += n2;
                }
                catch (Exception exception) {}
            }
            sqlSession.commit();
            int n3 = n;
            return n3;
        }
        catch (Exception exception) {
            try {
                sqlSession.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new RuntimeException("Import failed unexpectedly: " + exception.getMessage(), exception);
        }
        finally {
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getValueCount(String string) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            long l = (Long)sqlSession.selectOne("Lookup.getValueCount", hashMap);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long searchLookupValuesCount(String string, String string2) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("pattern", string2);
            long l = (Long)sqlSession.selectOne("Lookup.searchLookupValuesCount", hashMap);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(String string, String string2, String string3) {
        int n = 0;
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            hashMap.put("valueData", string3);
            n = sqlSession.insert("Lookup.putIfAbsent", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSwap(String string, String string2, String string3, String string4) {
        int n = 0;
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            hashMap.put("expectedValue", string3);
            hashMap.put("newValue", string4);
            n = sqlSession.insert("Lookup.compareAndSwap", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateValueByDelta(String string, String string2, Long l) {
        if (this.dbType == DatabaseDialect.DatabaseType.DERBY) {
            throw new ValueOperationException("Atomic delta update is not supported on Derby (CLOB field).");
        }
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tableName", string);
            hashMap.put("keyValue", string2);
            hashMap.put("delta", l);
            int n = sqlSession.update("Lookup.updateValueByDelta", hashMap);
            sqlSession.commit();
            bl = true;
            boolean bl2 = n > 0;
            return bl2;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    private Set<String> findExistingKeys(String string, Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>(1000);
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionManager.openSession();
            for (String string2 : collection) {
                arrayList.add(string2);
                if (arrayList.size() != 1000) continue;
                hashSet.addAll(this.selectExistingBatch(sqlSession, string, arrayList));
                arrayList.clear();
            }
            if (!arrayList.isEmpty()) {
                hashSet.addAll(this.selectExistingBatch(sqlSession, string, arrayList));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to query existing keys: " + exception.getMessage(), exception);
        }
        finally {
            if (sqlSession != null) {
                try {
                    sqlSession.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashSet;
    }

    private List<String> selectExistingBatch(SqlSession sqlSession, String string, List<String> list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("tableName", string);
        hashMap.put("keyValues", list);
        return sqlSession.selectList("Lookup.selectExistingKeys", hashMap);
    }
}

