/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.servlet;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.DuplicateGroupNameException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.GroupNotFoundException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.LookupApiException;
import com.mirth.connect.plugins.dynamiclookup.server.service.LookupService;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.LookupModelMapper;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.BatchGetValuesRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.ImportLookupGroupRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.ImportValuesRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.LookupGroupRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.LookupValueRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.BatchGetValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.CacheStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportGroupPagedResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupAuditEntriesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupStatisticsResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupAllValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.interfaces.LookupTableServletInterface;
import com.mirth.connect.plugins.dynamiclookup.shared.model.HistoryFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupAudit;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.UserController;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupTableServlet
extends MirthServlet
implements LookupTableServletInterface {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static final UserController userController = ControllerFactory.getFactory().createUserController();

    public LookupTableServlet(@Context HttpServletRequest httpServletRequest, @Context SecurityContext securityContext) {
        super(httpServletRequest, securityContext, "Lookup Table Management System");
    }

    public String getAllGroups() throws ClientException {
        try {
            List<LookupGroup> list = LookupService.getInstance().getAllGroups();
            return JsonUtils.toJson(list);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getAllGroups request. Error:  " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getGroupById(Integer n) throws ClientException {
        try {
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            return JsonUtils.toJson((Object)lookupGroup);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupById request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getGroupByName(String string) throws ClientException {
        try {
            if (string == null || string.trim().isEmpty()) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Group name must not be empty.");
            }
            LookupGroup lookupGroup = LookupService.getInstance().getGroupByName(string);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with name: " + string);
            }
            return JsonUtils.toJson((Object)lookupGroup);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupByName request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String createGroup(String string) throws ClientException {
        try {
            int n;
            LookupGroupRequest lookupGroupRequest;
            try {
                lookupGroupRequest = (LookupGroupRequest)JsonUtils.fromJson((String)string, LookupGroupRequest.class);
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid JSON format for group request: " + exception.getMessage());
            }
            try {
                lookupGroupRequest.validate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Validation failed: " + illegalArgumentException.getMessage());
            }
            LookupGroup lookupGroup = LookupModelMapper.fromGroupDto((LookupGroupRequest)lookupGroupRequest);
            try {
                n = LookupService.getInstance().createGroup(lookupGroup);
            }
            catch (DuplicateGroupNameException duplicateGroupNameException) {
                throw new LookupApiException(Response.Status.CONFLICT, "DUPLICATE_GROUP_NAME", "Group name already exists: " + lookupGroup.getName());
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while creating group: " + exception.getMessage());
            }
            LookupGroup lookupGroup2 = LookupService.getInstance().getGroupById(n);
            if (lookupGroup2 == null) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "GROUP_NOT_FOUND", "Group created but could not be retrieved with ID: " + n);
            }
            return JsonUtils.toJson((Object)lookupGroup2);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process createGroup request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String updateGroup(Integer n, String string) throws ClientException {
        try {
            LookupGroupRequest lookupGroupRequest;
            try {
                lookupGroupRequest = (LookupGroupRequest)JsonUtils.fromJson((String)string, LookupGroupRequest.class);
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid JSON format for group request: " + exception.getMessage());
            }
            try {
                lookupGroupRequest.validate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Validation failed: " + illegalArgumentException.getMessage());
            }
            LookupGroup lookupGroup = LookupModelMapper.fromGroupDto((LookupGroupRequest)lookupGroupRequest);
            lookupGroup.setId(n.intValue());
            try {
                LookupService.getInstance().updateGroup(lookupGroup);
            }
            catch (GroupNotFoundException groupNotFoundException) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            catch (DuplicateGroupNameException duplicateGroupNameException) {
                throw new LookupApiException(Response.Status.CONFLICT, "DUPLICATE_GROUP_NAME", "Group name already exists: " + lookupGroup.getName());
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while updating group: " + exception.getMessage());
            }
            LookupGroup lookupGroup2 = LookupService.getInstance().getGroupById(n);
            if (lookupGroup2 == null) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "GROUP_NOT_FOUND", "Group created but could not be retrieved with ID: " + n);
            }
            return JsonUtils.toJson((Object)lookupGroup2);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process updateGroup request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public void deleteGroup(Integer n) throws ClientException {
        try {
            LookupService.getInstance().deleteGroup(n);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
    }

    public String exportGroup(Integer n) throws ClientException {
        try {
            Map<String, String> map = LookupService.getInstance().getAllValues(n);
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            Date date = new Date();
            ExportLookupGroupResponse exportLookupGroupResponse = new ExportLookupGroupResponse(lookupGroup, map, date);
            return JsonUtils.toJson((Object)exportLookupGroupResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while creating group: " + exception.getMessage());
        }
    }

    public String exportGroupPaged(Integer n, Integer n2, Integer n3) throws ClientException {
        try {
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            int n4 = n2 != null ? n2 : 0;
            int n5 = n3 != null ? n3 : 10000;
            List<LookupValue> list = LookupService.getInstance().searchLookupValues(n, n4, n5, null);
            int n6 = LookupService.getInstance().searchLookupValuesCount(n, null);
            ExportGroupPagedResponse exportGroupPagedResponse = ExportGroupPagedResponse.fromResult((Integer)n, (int)n4, (int)n5, (int)n6, list);
            return JsonUtils.toJson((Object)exportGroupPagedResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process exportGroupPaged request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String importGroup(boolean bl, String string) throws ClientException {
        try {
            int n;
            ImportLookupGroupRequest importLookupGroupRequest;
            try {
                importLookupGroupRequest = (ImportLookupGroupRequest)JsonUtils.fromJson((String)string, ImportLookupGroupRequest.class);
                importLookupGroupRequest.validate();
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid import request: " + exception.getMessage());
            }
            LookupGroup lookupGroup = importLookupGroupRequest.getGroup();
            Map map = importLookupGroupRequest.getValues();
            String string2 = String.valueOf(this.getCurrentUserId());
            try {
                n = LookupService.getInstance().importGroup(lookupGroup, map, bl, string2);
            }
            catch (DuplicateGroupNameException duplicateGroupNameException) {
                throw new LookupApiException(Response.Status.CONFLICT, "DUPLICATE_GROUP_NAME", "Group name already exists: " + lookupGroup.getName());
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while import group: " + exception.getMessage());
            }
            ImportLookupGroupResponse importLookupGroupResponse = ImportLookupGroupResponse.fromResult((int)lookupGroup.getId(), (int)n, Collections.emptyList());
            return JsonUtils.toJson((Object)importLookupGroupResponse);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to import lookup group: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getAllValues(Integer n, Integer n2, Integer n3, String string) throws ClientException {
        try {
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            int n4 = n2 != null ? n2 : 0;
            int n5 = n3 != null ? n3 : Integer.MAX_VALUE;
            String string2 = string != null ? string.trim() : null;
            List<LookupValue> list = LookupService.getInstance().searchLookupValues(n, n4, n5, string2);
            int n6 = LookupService.getInstance().searchLookupValuesCount(n, string2);
            LookupAllValuesResponse lookupAllValuesResponse = LookupAllValuesResponse.fromResult((Integer)n, (String)lookupGroup.getName(), (int)n6, list, (int)n5, (int)n4);
            return JsonUtils.toJson((Object)lookupAllValuesResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getAllValues request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getValue(Integer n, String string) throws ClientException {
        try {
            String string2 = LookupService.getInstance().getValue(n, string);
            if (string2 == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "VALUE_NOT_FOUND", "Lookup value not found with key: " + string);
            }
            LookupValue lookupValue = new LookupValue(string, string2);
            return JsonUtils.toJson((Object)LookupModelMapper.toValueResponse((LookupValue)lookupValue, (Integer)n, (boolean)false));
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getValue request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String setValue(Integer n, String string, String string2) {
        try {
            LookupValueRequest lookupValueRequest;
            try {
                lookupValueRequest = (LookupValueRequest)JsonUtils.fromJson((String)string2, LookupValueRequest.class);
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid JSON format for value request: " + exception.getMessage());
            }
            try {
                lookupValueRequest.validate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Validation failed: " + illegalArgumentException.getMessage());
            }
            String string3 = String.valueOf(this.getCurrentUserId());
            try {
                LookupService.getInstance().setValue(n, string, lookupValueRequest.getValue(), string3);
            }
            catch (GroupNotFoundException groupNotFoundException) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            catch (Exception exception) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while set value: " + exception.getMessage());
            }
            LookupValue lookupValue = LookupService.getInstance().getLookupValue(n, string);
            if (lookupValue == null) {
                throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "GROUP_NOT_FOUND", "The value was saved, but failed to retrieve it afterward. groupId=" + n + ", key=" + string);
            }
            return JsonUtils.toJson((Object)LookupModelMapper.toValueResponse((LookupValue)lookupValue, (Integer)n));
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new MirthApiException((Throwable)exception);
        }
    }

    public void deleteValue(Integer n, String string) throws ClientException {
        try {
            String string2 = String.valueOf(this.getCurrentUserId());
            LookupService.getInstance().deleteValue(n, string, string2);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
    }

    public String importValues(Integer n, boolean bl, String string) {
        ImportValuesRequest importValuesRequest;
        try {
            importValuesRequest = (ImportValuesRequest)JsonUtils.fromJson((String)string, ImportValuesRequest.class);
        }
        catch (Exception exception) {
            throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid JSON format for import values request: " + exception.getMessage());
        }
        try {
            importValuesRequest.validate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Validation failed: " + illegalArgumentException.getMessage());
        }
        Map map = LookupModelMapper.fromImportValuesDto((ImportValuesRequest)importValuesRequest);
        String string2 = String.valueOf(this.getCurrentUserId());
        try {
            int n2 = LookupService.getInstance().importValues(n, map, bl, string2);
            ImportValuesResponse importValuesResponse = new ImportValuesResponse();
            importValuesResponse.setGroupId(n);
            importValuesResponse.setStatus("success");
            importValuesResponse.setImportedCount(n2);
            importValuesResponse.setErrors(Collections.emptyList());
            return JsonUtils.toJson((Object)importValuesResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while importing values: " + exception.getMessage());
        }
    }

    public String batchGetValues(Integer n, String string2) throws ClientException {
        BatchGetValuesRequest batchGetValuesRequest;
        try {
            batchGetValuesRequest = (BatchGetValuesRequest)JsonUtils.fromJson((String)string2, BatchGetValuesRequest.class);
        }
        catch (Exception exception) {
            throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Invalid JSON format for import values request: " + exception.getMessage());
        }
        try {
            batchGetValuesRequest.validate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LookupApiException(Response.Status.BAD_REQUEST, "INVALID_REQUEST", "Validation failed: " + illegalArgumentException.getMessage());
        }
        List list = LookupModelMapper.fromBatchGetValues((BatchGetValuesRequest)batchGetValuesRequest);
        try {
            Map<String, String> map = LookupService.getInstance().getBatchValues(n, list);
            BatchGetValuesResponse batchGetValuesResponse = new BatchGetValuesResponse();
            batchGetValuesResponse.setGroupId(n);
            batchGetValuesResponse.setValues(map);
            List list2 = list.stream().filter(string -> !map.containsKey(string)).collect(Collectors.toList());
            batchGetValuesResponse.setMissingKeys(list2);
            return JsonUtils.toJson((Object)batchGetValuesResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new LookupApiException(Response.Status.INTERNAL_SERVER_ERROR, "DATABASE_ERROR", "Database error while creating group: " + exception.getMessage());
        }
    }

    public String getGroupStatistics(Integer n) throws ClientException {
        try {
            LookupStatistics lookupStatistics = LookupService.getInstance().getStatistics(n);
            CacheStatistics cacheStatistics = LookupService.getInstance().getCacheStatistics(n);
            GroupStatisticsResponse groupStatisticsResponse = GroupStatisticsResponse.fromResult((LookupStatistics)lookupStatistics, (CacheStatistics)cacheStatistics);
            return JsonUtils.toJson((Object)groupStatisticsResponse);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String resetGroupStatistics(Integer n) throws ClientException {
        try {
            LookupService.getInstance().resetStatistics(n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("status", "success");
            hashMap.put("message", "Statistics reset successfully for group ID: " + n);
            return JsonUtils.toJson(hashMap);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String getGroupAuditEntries(Integer n, Integer n2, Integer n3) throws ClientException {
        try {
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            int n4 = n2 != null ? n2 : 0;
            int n5 = n3 != null ? n3 : Integer.MAX_VALUE;
            List<LookupAudit> list = LookupService.getInstance().getAuditEntries(n, n4, n5);
            int n6 = LookupService.getInstance().getAuditEntryCount(n);
            List list2 = userController.getAllUsers();
            GroupAuditEntriesResponse groupAuditEntriesResponse = GroupAuditEntriesResponse.fromResult((int)n, list, (int)n6, (int)n5, (int)n4, (List)list2);
            return JsonUtils.toJson((Object)groupAuditEntriesResponse);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupAuditEntries request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String searchGroupAuditEntries(Integer n, Integer n2, Integer n3, String string) throws ClientException {
        try {
            HistoryFilterState historyFilterState = string != null && !string.isEmpty() ? HistoryFilterState.fromJson((String)string) : new HistoryFilterState();
            LookupGroup lookupGroup = LookupService.getInstance().getGroupById(n);
            if (lookupGroup == null) {
                throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
            }
            int n4 = n2 != null ? n2 : 0;
            int n5 = n3 != null ? n3 : 100;
            List<LookupAudit> list = LookupService.getInstance().searchAuditEntries(n, n4, n5, historyFilterState);
            int n6 = LookupService.getInstance().searchAuditEntryCount(n, historyFilterState);
            List list2 = userController.getAllUsers();
            GroupAuditEntriesResponse groupAuditEntriesResponse = GroupAuditEntriesResponse.fromResult((int)n, list, (int)n6, (int)n5, (int)n4, (List)list2);
            return JsonUtils.toJson((Object)groupAuditEntriesResponse);
        }
        catch (LookupApiException lookupApiException) {
            throw lookupApiException;
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process searchGroupAuditEntries request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String clearGroupCache(Integer n) throws ClientException {
        try {
            LookupService.getInstance().clearGroupCache(n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("status", "success");
            hashMap.put("message", "Cache cleared successfully for group ID: " + n);
            return JsonUtils.toJson(hashMap);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            throw new LookupApiException(Response.Status.NOT_FOUND, "GROUP_NOT_FOUND", "Lookup group not found with ID: " + n);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process getGroupStatistics request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }

    public String clearAllCaches() throws ClientException {
        try {
            LookupService.getInstance().clearAllCaches();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("status", "success");
            hashMap.put("message", "All caches cleared successfully");
            return JsonUtils.toJson(hashMap);
        }
        catch (Exception exception) {
            throw new ClientException("Failed to process clearAllCaches request. Error: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), (Throwable)exception);
        }
    }
}

