/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.javascript;

import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.javascript.JavaScriptAuthenticator;
import com.mirth.connect.plugins.httpauth.javascript.JavaScriptHttpAuthProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.UUID;

public class JavaScriptAuthenticatorProvider
extends AuthenticatorProvider {
    private static final ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private String scriptId;
    private volatile String contextFactoryId;

    public JavaScriptAuthenticatorProvider(Connector connector, HttpAuthConnectorPluginProperties properties) throws Exception {
        super(connector, properties);
        JavaScriptHttpAuthProperties props = (JavaScriptHttpAuthProperties)properties;
        this.scriptId = UUID.randomUUID().toString();
        MirthContextFactory contextFactory = contextFactoryController.getContextFactory(connector.getResourceIds());
        this.contextFactoryId = contextFactory.getId();
        JavaScriptUtil.compileAndAddScript((String)connector.getChannelId(), (MirthContextFactory)contextFactory, (String)this.scriptId, (String)props.getScript(), (ContextType)ContextType.SOURCE_RECEIVER, null, null);
    }

    String getScriptId() {
        return this.scriptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MirthContextFactory getContextFactory() throws Exception {
        MirthContextFactory contextFactory = contextFactoryController.getContextFactory(this.getConnector().getResourceIds());
        if (!this.contextFactoryId.equals(contextFactory.getId())) {
            JavaScriptAuthenticatorProvider javaScriptAuthenticatorProvider = this;
            synchronized (javaScriptAuthenticatorProvider) {
                contextFactory = contextFactoryController.getContextFactory(this.getConnector().getResourceIds());
                if (!this.contextFactoryId.equals(contextFactory.getId())) {
                    JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.scriptId);
                    this.contextFactoryId = contextFactory.getId();
                }
            }
        }
        return contextFactory;
    }

    @Override
    public Authenticator getAuthenticator() throws Exception {
        return new JavaScriptAuthenticator(this);
    }

    @Override
    public void shutdown() {
        JavaScriptUtil.removeScriptFromCache((String)this.scriptId);
    }
}

