/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.userutil;

import com.mirth.connect.plugins.httpauth.userutil.AuthStatus;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationResult {
    private AuthStatus status;
    private String username;
    private String realm;
    private Map<String, List<String>> responseHeaders = new LinkedHashMap<String, List<String>>();

    public AuthenticationResult(AuthStatus status) {
        this.setStatus(status);
    }

    public AuthStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuthStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null.");
        }
        this.status = status;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        if (responseHeaders == null) {
            responseHeaders = new LinkedHashMap<String, List<String>>();
        }
        this.responseHeaders = responseHeaders;
    }

    public void addResponseHeader(String key, String value) {
        List<String> list = this.responseHeaders.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.responseHeaders.put(key, list);
        }
        list.add(value);
    }

    public static AuthenticationResult Challenged(String authenticateHeader) {
        AuthenticationResult result = new AuthenticationResult(AuthStatus.CHALLENGED);
        result.addResponseHeader("WWW-Authenticate", StringUtils.trimToEmpty((String)authenticateHeader));
        return result;
    }

    public static AuthenticationResult Success() {
        return new AuthenticationResult(AuthStatus.SUCCESS);
    }

    public static AuthenticationResult Success(String username, String realm) {
        AuthenticationResult result = new AuthenticationResult(AuthStatus.SUCCESS);
        result.setUsername(username);
        result.setRealm(realm);
        return result;
    }

    public static AuthenticationResult Failure() {
        return new AuthenticationResult(AuthStatus.FAILURE);
    }
}

