/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.panel;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.plugins.messagetrends.client.chart.LineTrendsChart;
import com.mirth.connect.plugins.messagetrends.client.chart.StackedTrendsChart;
import com.mirth.connect.plugins.messagetrends.client.chart.TrendsChart;
import com.mirth.connect.plugins.messagetrends.client.control.JumpToTimeDialog;
import com.mirth.connect.plugins.messagetrends.client.control.TrendsControlsBar;
import com.mirth.connect.plugins.messagetrends.client.plugin.MessageTrendsDashboardTabPlugin;
import com.mirth.connect.plugins.messagetrends.client.service.MessageTrendsServiceClient;
import com.mirth.connect.plugins.messagetrends.client.summary.SummaryAllView;
import com.mirth.connect.plugins.messagetrends.client.summary.SummaryMetricView;
import com.mirth.connect.plugins.messagetrends.client.summary.SummaryView;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import com.mirth.connect.plugins.messagetrends.shared.model.TimeRangePresets;
import com.mirth.connect.plugins.messagetrends.shared.util.Intervals;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsDashboardPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Frame parent;
    private final MessageTrendsDashboardTabPlugin plugin;
    private SelectionInfo selection;
    private TrendsControlsBar controlsBar;
    private JPanel chartCardPanel;
    private final Map<ChartType, TrendsChart> charts = new HashMap<ChartType, TrendsChart>();
    private TrendsChart activeChart;
    private String currentTitle = "Message Volume";
    private JPanel summaryCardPanel;
    private final Map<SummaryType, SummaryView> summaryViews = new HashMap<SummaryType, SummaryView>();
    private SummaryView activeSummary;
    private SwingWorker<List<MessageStatisticsTimeseries>, Void> inFlight;
    private List<MessageStatisticsTimeseries> lastData = Collections.emptyList();
    private final Map<String, Long> lastFetchByInterval = new HashMap<String, Long>();
    private Long lastStartTsMs;
    private Long lastEndTsMs;
    private Long endTsMs;
    private boolean isLive;
    private static final Color COLOR_RECEIVED = new Color(20, 110, 255);
    private static final Color COLOR_SENT = new Color(40, 170, 40);
    private static final Color COLOR_FILTERED = new Color(255, 140, 0);
    private static final Color COLOR_QUEUED = new Color(153, 102, 255);
    private static final Color COLOR_ERROR = new Color(200, 40, 40);
    private static final double SHIFT_FRACTION = 0.5;

    public MessageTrendsDashboardPanel(MessageTrendsDashboardTabPlugin messageTrendsDashboardTabPlugin) {
        this.plugin = messageTrendsDashboardTabPlugin;
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.initLayout();
        this.wireEvents();
        this.updateChartTitle("No Channel/Connector Selected");
    }

    private void initComponents() {
        this.controlsBar = new TrendsControlsBar();
        this.chartCardPanel = new JPanel(new CardLayout());
        LineTrendsChart lineTrendsChart = new LineTrendsChart();
        lineTrendsChart.setSeriesColors(COLOR_RECEIVED, COLOR_SENT, COLOR_FILTERED, COLOR_QUEUED, COLOR_ERROR);
        this.charts.put(ChartType.LINE, lineTrendsChart);
        this.chartCardPanel.add((Component)lineTrendsChart.getComponent(), ChartType.LINE.name());
        StackedTrendsChart stackedTrendsChart = new StackedTrendsChart();
        stackedTrendsChart.setSeriesColors(COLOR_RECEIVED, COLOR_SENT, COLOR_FILTERED, COLOR_QUEUED, COLOR_ERROR);
        this.charts.put(ChartType.STACKED, stackedTrendsChart);
        this.chartCardPanel.add((Component)stackedTrendsChart.getComponent(), ChartType.STACKED.name());
        this.activeChart = lineTrendsChart;
        this.summaryCardPanel = new JPanel(new CardLayout());
        SummaryAllView summaryAllView = new SummaryAllView();
        summaryAllView.setSeriesColors(COLOR_RECEIVED, COLOR_SENT, COLOR_FILTERED, COLOR_QUEUED, COLOR_ERROR);
        this.summaryViews.put(SummaryType.ALL, summaryAllView);
        this.summaryCardPanel.add((Component)summaryAllView.getComponent(), SummaryType.ALL.name());
        SummaryMetricView summaryMetricView = new SummaryMetricView();
        summaryMetricView.setSeriesColors(COLOR_RECEIVED, COLOR_SENT, COLOR_FILTERED, COLOR_QUEUED, COLOR_ERROR);
        this.summaryViews.put(SummaryType.METRIC, summaryMetricView);
        this.summaryCardPanel.add((Component)summaryMetricView.getComponent(), SummaryType.METRIC.name());
        this.activeSummary = summaryAllView;
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.summaryCardPanel, "Center");
        jPanel.setPreferredSize(new Dimension(10, 65));
        this.summaryCardPanel.setPreferredSize(new Dimension(10, 65));
        this.add((Component)this.controlsBar, "North");
        this.add((Component)this.chartCardPanel, "Center");
        this.add((Component)jPanel, "South");
    }

    private void wireEvents() {
        this.controlsBar.getViewCombo().addActionListener(actionEvent -> {
            View view = (View)((Object)((Object)this.controlsBar.getViewCombo().getSelectedItem()));
            SummaryType summaryType = view == View.ALL ? SummaryType.ALL : SummaryType.METRIC;
            this.switchSummaryView(summaryType);
            this.rebindDataset();
        });
        this.controlsBar.getChartCombo().addActionListener(actionEvent -> {
            Object object = this.controlsBar.getChartCombo().getSelectedItem();
            ChartType chartType = "Stacked".equals(object) ? ChartType.STACKED : ChartType.LINE;
            this.switchChart(chartType);
        });
        this.controlsBar.getIntervalCombo().addActionListener(actionEvent -> this.refreshData(RefreshMode.FORCE_LIVE));
        this.controlsBar.getRefreshButton().addActionListener(actionEvent -> this.refreshData(RefreshMode.FORCE_LIVE));
        this.controlsBar.getPrevButton().addActionListener(actionEvent -> {
            if (this.endTsMs == null) {
                this.refreshData(RefreshMode.FORCE_LIVE);
            } else {
                String string = (String)this.controlsBar.getTimeRangeCombo().getSelectedItem();
                long l = TimeRangePresets.toDuration((String)string).toMillis();
                this.endTsMs = this.endTsMs - (long)(0.5 * (double)l);
                this.refreshData(RefreshMode.KEEP_POSITION);
            }
        });
        this.controlsBar.getJumpButton().addActionListener(actionEvent -> {
            Long l = JumpToTimeDialog.showDialog(this.parent);
            if (l != null) {
                String string = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
                long l2 = (long)Intervals.minutesOf((String)string) * 60000L;
                this.endTsMs = MessageTrendsDashboardPanel.snapToBucket(l, l2);
                this.refreshData(RefreshMode.KEEP_POSITION);
            }
        });
        this.controlsBar.getNextButton().addActionListener(actionEvent -> {
            if (this.endTsMs == null) {
                this.refreshData(RefreshMode.FORCE_LIVE);
            } else {
                String string = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
                long l = (long)Intervals.minutesOf((String)string) * 60000L;
                long l2 = MessageTrendsDashboardPanel.snapToBucket(System.currentTimeMillis(), l);
                String string2 = (String)this.controlsBar.getTimeRangeCombo().getSelectedItem();
                long l3 = TimeRangePresets.toDuration((String)string2).toMillis();
                this.endTsMs = this.endTsMs + (long)(0.5 * (double)l3);
                if (this.endTsMs >= l2) {
                    this.refreshData(RefreshMode.FORCE_LIVE);
                } else {
                    this.refreshData(RefreshMode.KEEP_POSITION);
                }
            }
        });
    }

    public void setSelection(String string, String string2, Integer n, String string3) {
        long l;
        long l2;
        long l3;
        SelectionInfo selectionInfo = new SelectionInfo(string, string2, n, string3);
        if (this.selection == null || !Objects.equals(this.selection.getChannelId(), selectionInfo.getChannelId()) || !Objects.equals(this.selection.getConnectorId(), selectionInfo.getConnectorId())) {
            this.selection = selectionInfo;
            this.refreshData(RefreshMode.FORCE_LIVE);
            return;
        }
        String string4 = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
        if (Intervals.isValid((String)string4) && (l3 = System.currentTimeMillis()) - (l2 = this.lastFetchByInterval.getOrDefault(string4, 0L).longValue()) >= (l = (long)Intervals.minutesOf((String)string4) * 60000L) && this.isLive) {
            this.refreshData(RefreshMode.FORCE_LIVE);
        }
    }

    private void switchChart(ChartType chartType) {
        if (chartType == null) {
            return;
        }
        TrendsChart trendsChart = this.charts.get((Object)chartType);
        if (trendsChart == null || trendsChart == this.activeChart) {
            return;
        }
        String string = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
        int n = Intervals.isValid((String)string) ? Intervals.minutesOf((String)string) : 1;
        trendsChart.setIntervalMinutes(n);
        if (this.lastStartTsMs != null && this.lastEndTsMs != null && this.lastEndTsMs > this.lastStartTsMs) {
            trendsChart.setWindowRange(this.lastStartTsMs, this.lastEndTsMs);
        }
        trendsChart.setView((View)((Object)this.controlsBar.getViewCombo().getSelectedItem()));
        trendsChart.setTitle(this.currentTitle);
        trendsChart.setData(this.lastData);
        CardLayout cardLayout = (CardLayout)this.chartCardPanel.getLayout();
        cardLayout.show(this.chartCardPanel, chartType.name());
        this.activeChart = trendsChart;
    }

    private void switchSummaryView(SummaryType summaryType) {
        if (summaryType == null) {
            return;
        }
        SummaryView summaryView = this.summaryViews.get((Object)summaryType);
        if (summaryView == null || summaryView == this.activeSummary) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.summaryCardPanel.getLayout();
        cardLayout.show(this.summaryCardPanel, summaryType.name());
        this.activeSummary = summaryView;
    }

    public void blockSelection(SelectionBlockReason selectionBlockReason) {
        this.setControlsEnabled(false);
        this.reset(this.warningMessageForReason(selectionBlockReason));
    }

    public void unblockSelection() {
    }

    private void setControlsEnabled(boolean bl) {
        this.controlsBar.setControlsEnabled(bl);
        if (this.isLive && bl) {
            this.controlsBar.setNextEnabled(false);
        }
    }

    private String warningMessageForReason(SelectionBlockReason selectionBlockReason) {
        switch (selectionBlockReason) {
            case MULTI_SELECTED: {
                return "Multiple items selected. Please select exactly one channel or one connector.";
            }
        }
        return "No valid selection. Please select a channel or a connector.";
    }

    public void refreshData() {
        this.refreshData(RefreshMode.KEEP_POSITION);
    }

    public void refreshData(RefreshMode refreshMode) {
        SwingWorker<List<MessageStatisticsTimeseries>, Void> swingWorker;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::refreshData);
            return;
        }
        if (this.selection == null || this.selection.getChannelId() == null) {
            return;
        }
        final String string = this.selection.getChannelId();
        String string2 = this.selection.getChannelName();
        final String string3 = Objects.toString(this.selection.getConnectorId(), null);
        String string4 = this.selection.getConnectorName();
        final String string5 = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
        if (!Intervals.isValid((String)string5)) {
            this.parent.alertError((Component)this.parent, "Unsupported interval: " + string5);
            return;
        }
        if (refreshMode == RefreshMode.FORCE_LIVE) {
            this.lastFetchByInterval.put(string5, System.currentTimeMillis());
        }
        if (string3 == null) {
            this.updateChartTitle("Message Volume for Channel: " + string2);
        } else {
            this.updateChartTitle("Message Volume for Connector: " + string4 + " (Channel: " + string2 + ")");
        }
        long l = System.currentTimeMillis();
        long l2 = (long)Intervals.minutesOf((String)string5) * 60000L;
        long l3 = MessageTrendsDashboardPanel.snapToBucket(l, l2);
        this.endTsMs = refreshMode == RefreshMode.FORCE_LIVE || this.endTsMs == null ? Long.valueOf(l3) : Long.valueOf(MessageTrendsDashboardPanel.snapToBucket(this.endTsMs, l2));
        this.isLive = Objects.equals(this.endTsMs, l3);
        this.controlsBar.setLive(this.isLive);
        String string6 = (String)this.controlsBar.getTimeRangeCombo().getSelectedItem();
        long l4 = TimeRangePresets.toDuration((String)string6).toMillis();
        int n = (int)Math.max(1L, MessageTrendsDashboardPanel.ceilDiv(l4, l2));
        long l5 = (long)n * l2;
        long l6 = this.endTsMs - l5;
        final long l7 = l6 - l2;
        final long l8 = this.endTsMs;
        this.lastStartTsMs = l6;
        this.lastEndTsMs = this.endTsMs;
        this.activeChart.setIntervalMinutes(Intervals.minutesOf((String)string5));
        this.activeChart.setWindowRange(this.lastStartTsMs, this.lastEndTsMs);
        if (this.inFlight != null && !this.inFlight.isDone()) {
            this.inFlight.cancel(true);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setControlsEnabled(false);
        this.inFlight = swingWorker = new SwingWorker<List<MessageStatisticsTimeseries>, Void>(){

            @Override
            protected List<MessageStatisticsTimeseries> doInBackground() {
                try {
                    if (this.isCancelled()) {
                        return Collections.emptyList();
                    }
                    if (string3 == null) {
                        return MessageTrendsServiceClient.getInstance().getChannelStatistics(string, l7, l8, string5);
                    }
                    return MessageTrendsServiceClient.getInstance().getConnectorStatistics(string, string3, l7, l8, string5);
                }
                catch (ClientException clientException) {}
                finally {
                    return Collections.emptyList();
                }
            }

            @Override
            protected void done() {
                if (this != MessageTrendsDashboardPanel.this.inFlight || this.isCancelled()) {
                    return;
                }
                try {
                    List list = (List)this.get();
                    MessageTrendsDashboardPanel.this.lastData = list != null ? list : Collections.emptyList();
                    MessageTrendsDashboardPanel.this.rebindDataset();
                }
                catch (Exception exception) {
                    MessageTrendsDashboardPanel.this.parent.alertError((Component)MessageTrendsDashboardPanel.this.parent, "Error retrieving statistics. Exception: " + exception.getMessage());
                }
                finally {
                    MessageTrendsDashboardPanel.this.setCursor(Cursor.getDefaultCursor());
                    MessageTrendsDashboardPanel.this.setControlsEnabled(true);
                }
            }
        };
        swingWorker.execute();
    }

    private void rebindDataset() {
        String string = (String)this.controlsBar.getIntervalCombo().getSelectedItem();
        this.activeChart.setIntervalMinutes(Intervals.minutesOf((String)string));
        this.activeChart.setWindowRange(this.lastStartTsMs, this.lastEndTsMs);
        this.activeChart.setView((View)((Object)this.controlsBar.getViewCombo().getSelectedItem()));
        this.activeChart.setData(this.lastData);
        this.activeSummary.setWindowRange(this.lastStartTsMs, this.lastEndTsMs);
        this.activeSummary.setView((View)((Object)this.controlsBar.getViewCombo().getSelectedItem()));
        this.activeSummary.setData(this.lastData);
    }

    private void updateChartTitle(String string) {
        this.currentTitle = string;
        if (this.activeChart != null) {
            this.activeChart.setTitle(string);
        }
    }

    public void cleanup() {
    }

    public void reset(String string) {
        if (this.inFlight != null && !this.inFlight.isDone()) {
            this.inFlight.cancel(true);
        }
        this.selection = null;
        this.lastData = Collections.emptyList();
        this.lastStartTsMs = null;
        this.lastEndTsMs = null;
        if (this.activeChart != null) {
            this.activeChart.reset();
            this.activeChart.setTitle(string);
        }
        if (this.activeSummary != null) {
            this.activeSummary.reset();
        }
    }

    private static long snapToBucket(long l, long l2) {
        if (l2 <= 0L) {
            return l;
        }
        return l / l2 * l2;
    }

    private static long ceilDiv(long l, long l2) {
        return (l + l2 - 1L) / l2;
    }

    private static enum ChartType {
        LINE("Line"),
        STACKED("Stacked Bars");

        final String label;

        private ChartType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    private static enum SummaryType {
        ALL("All"),
        METRIC("Metric");

        final String label;

        private SummaryType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class SelectionInfo {
        private final String channelId;
        private final String channelName;
        private final Integer connectorId;
        private final String connectorName;

        public SelectionInfo(String string, String string2, Integer n, String string3) {
            this.channelId = string;
            this.channelName = string2;
            this.connectorId = n;
            this.connectorName = string3;
        }

        public boolean isChannelLevel() {
            return this.connectorId == null;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public Integer getConnectorId() {
            return this.connectorId;
        }

        public String getConnectorName() {
            return this.connectorName;
        }

        public String toString() {
            return this.isChannelLevel() ? "Channel[" + this.channelName + "]" : "Connector[" + this.connectorName + "] in Channel[" + this.channelName + "]";
        }
    }

    private static enum RefreshMode {
        KEEP_POSITION,
        FORCE_LIVE;

    }

    public static enum View {
        ALL("All Message Types"),
        RECEIVED("Received Only"),
        SENT("Sent Only"),
        FILTERED("Filtered Only"),
        QUEUED("Queued Only"),
        ERRORS("Errors Only");

        public final String label;

        private View(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum SelectionBlockReason {
        NO_SELECTION,
        MULTI_SELECTED;

    }
}

