/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class RangeTextFormatter {
    private static final SimpleDateFormat POINT_FMT = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat TIME_FMT = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat FULL_FMT = new SimpleDateFormat("yyyy/MM/dd HH:mm");

    public static String formatPoint(Date date) {
        return date != null ? POINT_FMT.format(date) : "\u2014";
    }

    public static String formatRange(Long l, Long l2) {
        if (l == null || l2 == null) {
            return "(no range)";
        }
        Date date = new Date(l);
        Date date2 = new Date(l2);
        boolean bl = DATE_FMT.format(date).equals(DATE_FMT.format(date2));
        if (bl) {
            return DATE_FMT.format(date) + " " + TIME_FMT.format(date) + " \u2192 " + TIME_FMT.format(date2);
        }
        return FULL_FMT.format(date) + " \u2192 " + FULL_FMT.format(date2);
    }
}

