/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Calendar;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/extensions/datapruner")
@Tag(name="Extension Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface DataPrunerServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "Data Pruner";
    public static final String PERMISSION_VIEW = "View Settings";
    public static final String PERMISSION_SAVE = "Save Settings";
    public static final String PERMISSION_START_STOP = "Start / Stop";
    public static final String TASK_START = "doStart";
    public static final String TASK_STOP = "doStop";

    @GET
    @Path(value="/status")
    @Operation(summary="Retrieves the current data pruner status.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dataPrunerStatusMap", ref="../apiexamples/data_pruner_status_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dataPrunerStatusMap", ref="../apiexamples/data_pruner_status_map_json")})})
    @MirthOperation(name="getDataPrunerStatusMap", display="Get status", permission="View Settings")
    public Map<String, String> getStatusMap() throws ClientException;

    @POST
    @Path(value="/_start")
    @Operation(summary="Starts the data pruner on-demand.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="calendar", ref="../apiexamples/calendar_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="calendar", ref="../apiexamples/calendar_json")})})
    @MirthOperation(name="startDataPruner", display="Start pruner", permission="Start / Stop")
    public Calendar start() throws ClientException;

    @POST
    @Path(value="/_stop")
    @Operation(summary="Stops the data pruner if currently running.")
    @MirthOperation(name="stopDataPruner", display="Stop pruner", permission="Start / Stop")
    public void stop() throws ClientException;
}

