/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.SchemeProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class FTPSchemeProperties
extends SchemeProperties {
    private List<String> initialCommands = new ArrayList<String>();

    public FTPSchemeProperties() {
    }

    public FTPSchemeProperties(FTPSchemeProperties props) {
        List<String> propCommands = props.getInitialCommands();
        if (CollectionUtils.isNotEmpty(propCommands)) {
            for (String command : props.getInitialCommands()) {
                this.initialCommands.add(command);
            }
        }
    }

    public List<String> getInitialCommands() {
        return this.initialCommands;
    }

    public void setInitialCommands(List<String> commands) {
        this.initialCommands = commands;
    }

    @Override
    public SchemeProperties getFileSchemeProperties() {
        return this;
    }

    @Override
    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        if (CollectionUtils.isNotEmpty(this.initialCommands)) {
            builder.append("[INITIAL COMMANDS]");
            builder.append(newLine);
            for (String command : this.initialCommands) {
                builder.append(command);
                builder.append(newLine);
            }
        }
        return builder.toString();
    }

    @Override
    public String getSummaryText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Initial Commands: ");
        builder.append(String.join((CharSequence)",", this.initialCommands));
        return builder.toString();
    }

    @Override
    public SchemeProperties clone() {
        return new FTPSchemeProperties(this);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("initialCommandsCount", this.initialCommands.size());
        return purgedProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

