/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.FileAction;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class FileReceiverProperties
extends ConnectorProperties
implements PollConnectorPropertiesInterface,
SourceConnectorPropertiesInterface {
    public static final String NAME = "File Reader";
    private PollConnectorProperties pollConnectorProperties = new PollConnectorProperties();
    private SourceConnectorProperties sourceConnectorProperties = new SourceConnectorProperties();
    private FileScheme scheme = FileScheme.FILE;
    private SchemeProperties schemeProperties = null;
    private String host = "";
    private String fileFilter = "*";
    private boolean regex = false;
    private boolean directoryRecursion = false;
    private boolean ignoreDot = true;
    private boolean anonymous = true;
    private String username = "anonymous";
    private String password = "anonymous";
    private String timeout = "10000";
    private boolean secure = true;
    private boolean passive = true;
    private boolean validateConnection = true;
    private FileAction afterProcessingAction = FileAction.NONE;
    private String moveToDirectory = "";
    private String moveToFileName = "";
    private FileAction errorReadingAction = FileAction.NONE;
    private FileAction errorResponseAction = FileAction.AFTER_PROCESSING;
    private String errorMoveToDirectory = "";
    private String errorMoveToFileName = "";
    private boolean checkFileAge = true;
    private String fileAge = "1000";
    private String fileSizeMinimum = "0";
    private String fileSizeMaximum = "";
    private boolean ignoreFileSizeMaximum = true;
    private String sortBy = "date";
    private boolean binary = false;
    private String charsetEncoding = "DEFAULT_ENCODING";
    public static final String SORT_BY_NAME = "name";
    public static final String SORT_BY_SIZE = "size";
    public static final String SORT_BY_DATE = "date";

    public FileScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(FileScheme scheme) {
        this.scheme = scheme;
    }

    public SchemeProperties getSchemeProperties() {
        return this.schemeProperties;
    }

    public void setSchemeProperties(SchemeProperties schemeProperties) {
        this.schemeProperties = schemeProperties;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(String fileFilter) {
        this.fileFilter = fileFilter;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public boolean isDirectoryRecursion() {
        return this.directoryRecursion;
    }

    public void setDirectoryRecursion(boolean directoryRecursion) {
        this.directoryRecursion = directoryRecursion;
    }

    public boolean isIgnoreDot() {
        return this.ignoreDot;
    }

    public void setIgnoreDot(boolean ignoreDot) {
        this.ignoreDot = ignoreDot;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public FileAction getAfterProcessingAction() {
        return this.afterProcessingAction;
    }

    public void setAfterProcessingAction(FileAction afterProcessingAction) {
        this.afterProcessingAction = afterProcessingAction;
    }

    public String getMoveToDirectory() {
        return this.moveToDirectory;
    }

    public void setMoveToDirectory(String moveToDirectory) {
        this.moveToDirectory = moveToDirectory;
    }

    public String getMoveToFileName() {
        return this.moveToFileName;
    }

    public void setMoveToFileName(String moveToFileName) {
        this.moveToFileName = moveToFileName;
    }

    public FileAction getErrorReadingAction() {
        return this.errorReadingAction;
    }

    public void setErrorReadingAction(FileAction errorReadingAction) {
        this.errorReadingAction = errorReadingAction;
    }

    public FileAction getErrorResponseAction() {
        return this.errorResponseAction;
    }

    public void setErrorResponseAction(FileAction errorResponseAction) {
        this.errorResponseAction = errorResponseAction;
    }

    public String getErrorMoveToDirectory() {
        return this.errorMoveToDirectory;
    }

    public void setErrorMoveToDirectory(String errorMoveToDirectory) {
        this.errorMoveToDirectory = errorMoveToDirectory;
    }

    public String getErrorMoveToFileName() {
        return this.errorMoveToFileName;
    }

    public void setErrorMoveToFileName(String errorMoveToFileName) {
        this.errorMoveToFileName = errorMoveToFileName;
    }

    public boolean isCheckFileAge() {
        return this.checkFileAge;
    }

    public void setCheckFileAge(boolean checkFileAge) {
        this.checkFileAge = checkFileAge;
    }

    public String getFileAge() {
        return this.fileAge;
    }

    public void setFileAge(String fileAge) {
        this.fileAge = fileAge;
    }

    public String getFileSizeMinimum() {
        return this.fileSizeMinimum;
    }

    public void setFileSizeMinimum(String fileSizeMinimum) {
        this.fileSizeMinimum = fileSizeMinimum;
    }

    public String getFileSizeMaximum() {
        return this.fileSizeMaximum;
    }

    public void setFileSizeMaximum(String fileSizeMaximum) {
        this.fileSizeMaximum = fileSizeMaximum;
    }

    public boolean isIgnoreFileSizeMaximum() {
        return this.ignoreFileSizeMaximum;
    }

    public void setIgnoreFileSizeMaximum(boolean ignoreFileSizeMaximum) {
        this.ignoreFileSizeMaximum = ignoreFileSizeMaximum;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public String getProtocol() {
        return "File";
    }

    public String getName() {
        return NAME;
    }

    public String toFormattedString() {
        return null;
    }

    public PollConnectorProperties getPollConnectorProperties() {
        return this.pollConnectorProperties;
    }

    public SourceConnectorProperties getSourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    public boolean canBatch() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        DonkeyElement processBatchElement = element.removeChild("processBatch");
        DonkeyElement sourcePropertiesElement = element.getChildElement("sourceConnectorProperties");
        if (processBatchElement != null && sourcePropertiesElement != null) {
            sourcePropertiesElement.addChildElementIfNotExists("processBatch", processBatchElement.getTextContent());
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
        DonkeyElement schemeProperties;
        if (element.getChildElement("scheme").getTextContent().equalsIgnoreCase("sftp") && (schemeProperties = element.addChildElementIfNotExists("schemeProperties")) != null) {
            schemeProperties.setAttribute("class", "com.mirth.connect.connectors.file.SftpSchemeProperties");
            schemeProperties.addChildElementIfNotExists("passwordAuth", "true");
            schemeProperties.addChildElementIfNotExists("keyAuth", "false");
            schemeProperties.addChildElementIfNotExists("keyFile");
            schemeProperties.addChildElementIfNotExists("passPhrase");
            schemeProperties.addChildElementIfNotExists("hostKeyChecking", "ask");
            schemeProperties.addChildElementIfNotExists("knownHostsFile");
            schemeProperties.addChildElementIfNotExists("configurationSettings");
        }
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
        DonkeyElement schemeProperties;
        if (element.getChildElement("scheme").getTextContent().equalsIgnoreCase("smb") && (schemeProperties = element.addChildElementIfNotExists("schemeProperties")) != null) {
            schemeProperties.setAttribute("class", "com.mirth.connect.connectors.file.SmbSchemeProperties");
            schemeProperties.addChildElementIfNotExists("smbMinVersion", "SMB1");
            schemeProperties.addChildElementIfNotExists("smbMaxVersion", "SMB311");
        }
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("pollConnectorProperties", this.pollConnectorProperties.getPurgedProperties());
        purgedProperties.put("sourceConnectorProperties", this.sourceConnectorProperties.getPurgedProperties());
        purgedProperties.put("scheme", this.scheme);
        purgedProperties.put("schemePurgedProperties", this.schemeProperties.getPurgedProperties());
        purgedProperties.put("regex", this.regex);
        purgedProperties.put("directoryRecursion", this.directoryRecursion);
        purgedProperties.put("ignoreDot", this.ignoreDot);
        purgedProperties.put("anonymous", this.anonymous);
        purgedProperties.put("timeout", PurgeUtil.getNumericValue((String)this.timeout));
        purgedProperties.put("secure", this.secure);
        purgedProperties.put("passive", this.passive);
        purgedProperties.put("validateConnection", this.validateConnection);
        purgedProperties.put("afterProcessingAction", this.afterProcessingAction);
        purgedProperties.put("errorReadingAction", this.errorReadingAction);
        purgedProperties.put("checkFileAge", this.checkFileAge);
        purgedProperties.put("fileAge", PurgeUtil.getNumericValue((String)this.fileAge));
        purgedProperties.put("fileSizeMinimum", PurgeUtil.getNumericValue((String)this.fileSizeMinimum));
        purgedProperties.put("fileSizeMaximum", PurgeUtil.getNumericValue((String)this.fileSizeMaximum));
        purgedProperties.put("ignoreFileSizeMaximum", this.ignoreFileSizeMaximum);
        purgedProperties.put("sortBy", this.sortBy);
        return purgedProperties;
    }
}

