-- Oracle Migration script for Lookup Table Management System

-- Create LOOKUP_GROUP table
CREATE TABLE LOOKUP_GROUP (
    ID NUMBER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    NAME VARCHAR2(255) NOT NULL,
    DESCRIPTION CLOB,
    VERSION VARCHAR2(50),
    CACHE_SIZE NUMBER DEFAULT 1000,
    CACHE_POLICY VARCHAR2(50) DEFAULT 'LRU',
    CREATED_DATE TIMESTAMP DEFAULT SYSDATE,
    UPDATED_DATE TIMESTAMP DEFAULT SYSDATE
);


CREATE UNIQUE INDEX IDX_LOOKUP_GROUP_NAME ON LOOKUP_GROUP (NAME);

-- Create LOOKUP_AUDIT table
CREATE TABLE LOOKUP_AUDIT (
    ID NUMBER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    GROUP_ID NUMBER NOT NULL,
    TABLE_NAME VARCHAR2(255) NOT NULL,
    KEY_VALUE VARCHAR2(255) NOT NULL,
    ACTION VARCHAR2(50) NOT NULL,
    OLD_VALUE CLOB,
    NEW_VALUE CLOB,
    USER_ID VARCHAR2(255),
    AUDIT_TIMESTAMP TIMESTAMP DEFAULT SYSDATE,
    CONSTRAINT FK_LOOKUP_AUDIT_GROUP FOREIGN KEY (GROUP_ID)
        REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);

-- Add indexes
CREATE INDEX IDX_LOOKUP_AUDIT_GROUP ON LOOKUP_AUDIT (GROUP_ID);
CREATE INDEX IDX_LOOKUP_AUDIT_KEY ON LOOKUP_AUDIT (TABLE_NAME, KEY_VALUE);

-- Optional statistics table
CREATE TABLE LOOKUP_STATISTICS (
    GROUP_ID NUMBER PRIMARY KEY,
    TOTAL_LOOKUPS NUMBER DEFAULT 0,
    CACHE_HITS NUMBER DEFAULT 0,
    LAST_ACCESSED TIMESTAMP NULL,
    RESET_DATE TIMESTAMP DEFAULT SYSDATE,
    CONSTRAINT FK_LOOKUP_STATS_GROUP FOREIGN KEY (GROUP_ID)
        REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);