/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.converters.XMLPrettyPrinter;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.ER7Reader;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2DeserializationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2SerializationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.XMLEncodedHL7Handler;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ER7Serializer
implements IMessageSerializer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private PipeParser serializationPipeParser = null;
    private XMLParser serializationXmlParser = null;
    private PipeParser deserializationPipeParser = null;
    private XMLParser deserializationXmlParser = null;
    private boolean skipIntermediateDelimiter = false;
    private String serializationSegmentDelimiter = null;
    private String deserializationSegmentDelimiter = null;
    private HL7v2SerializationProperties serializationProperties;
    private HL7v2DeserializationProperties deserializationProperties;
    private static Pattern ampersandPattern = Pattern.compile("&amp;");
    private static Pattern prettyPattern1 = Pattern.compile("\\s*<([^/][^>]*)>");
    private static Pattern prettyPattern2 = Pattern.compile("<([^>]*/|/[^>]*)>\\s*");

    public ER7Serializer(SerializerProperties properties) {
        ParserConfiguration parserConfiguration;
        this.serializationProperties = (HL7v2SerializationProperties)properties.getSerializationProperties();
        this.deserializationProperties = (HL7v2DeserializationProperties)properties.getDeserializationProperties();
        DefaultHapiContext context = new DefaultHapiContext();
        if (this.serializationProperties != null) {
            this.serializationSegmentDelimiter = StringUtil.unescape((String)this.serializationProperties.getSegmentDelimiter());
            if (this.serializationSegmentDelimiter.equals("\r") || this.serializationSegmentDelimiter.equals("\n") || this.serializationSegmentDelimiter.equals("\r\n")) {
                this.skipIntermediateDelimiter = true;
            }
            if (this.serializationProperties.isUseStrictParser()) {
                this.serializationPipeParser = new CustomPipeParser((HapiContext)context);
                this.serializationXmlParser = new CustomDefaultXMLParser((HapiContext)context);
                if (!this.serializationProperties.isUseStrictValidation()) {
                    context.setValidationContext((ValidationContext)new NoValidation());
                }
                parserConfiguration = context.getParserConfiguration();
                parserConfiguration.setXmlDisableWhitespaceTrimmingOnNodeNames(new HashSet<String>(Arrays.asList("NTE.3", "OBX.5")));
            }
        }
        if (this.deserializationProperties != null) {
            this.deserializationSegmentDelimiter = StringUtil.unescape((String)this.deserializationProperties.getSegmentDelimiter());
            if (this.deserializationProperties.isUseStrictParser()) {
                this.deserializationPipeParser = new CustomPipeParser((HapiContext)context);
                this.deserializationXmlParser = new CustomDefaultXMLParser((HapiContext)context);
                if (!this.deserializationProperties.isUseStrictValidation()) {
                    context.setValidationContext((ValidationContext)new NoValidation());
                }
                parserConfiguration = context.getParserConfiguration();
                parserConfiguration.setXmlDisableWhitespaceTrimmingOnNodeNames(new HashSet<String>(Arrays.asList("NTE.3", "OBX.5")));
            }
        }
        try {
            context.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDeserializationSegmentDelimiter() {
        return this.deserializationSegmentDelimiter;
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        if (toXml) {
            if (this.serializationProperties.isUseStrictParser()) {
                serializationRequired = true;
            }
        } else if (this.deserializationProperties.isUseStrictParser()) {
            serializationRequired = true;
        }
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        try {
            boolean transformed = false;
            ER7Serializer serializer = (ER7Serializer)outboundSerializer;
            String outputSegmentDelimiter = serializer.getDeserializationSegmentDelimiter();
            if (this.serializationProperties.isConvertLineBreaks()) {
                if (this.skipIntermediateDelimiter) {
                    return StringUtil.convertLineBreaks((String)message, (String)outputSegmentDelimiter);
                }
                message = StringUtil.convertLineBreaks((String)message, (String)this.serializationSegmentDelimiter);
                transformed = true;
            }
            if (!this.serializationSegmentDelimiter.equals(outputSegmentDelimiter)) {
                message = StringUtils.replace((String)message, (String)this.serializationSegmentDelimiter, (String)outputSegmentDelimiter);
                transformed = true;
            }
            if (transformed) {
                return message;
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming ER7", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming ER7", (Throwable)e));
        }
        return null;
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            if (this.serializationProperties.isConvertLineBreaks()) {
                source = StringUtil.convertLineBreaks((String)source, (String)this.serializationSegmentDelimiter);
            }
            if (this.serializationProperties.isUseStrictParser()) {
                Message message = null;
                if ((source = source.trim()).length() > 0 && source.charAt(0) == '<') {
                    if (this.serializationProperties.isUseStrictValidation()) {
                        message = this.serializationXmlParser.parse(source);
                    }
                } else {
                    message = this.serializationPipeParser.parse(source);
                }
                if (message != null) {
                    source = this.serializationXmlParser.encode(message);
                }
                if (this.serializationProperties.isStripNamespaces()) {
                    source = StringUtil.stripNamespaces((String)source);
                }
                return source;
            }
            ER7Reader er7Reader = new ER7Reader(this.serializationProperties.isHandleRepetitions(), this.serializationProperties.isHandleSubcomponents(), this.serializationSegmentDelimiter);
            StringWriter stringWriter = new StringWriter();
            XMLPrettyPrinter serializer = new XMLPrettyPrinter((Writer)stringWriter);
            serializer.setEncodeEntities(true);
            er7Reader.setContentHandler((ContentHandler)serializer);
            er7Reader.parse(new InputSource(new StringReader(source)));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting ER7 to XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting ER7 to XML", (Throwable)e));
        }
    }

    public String fromXML(String source) throws MessageSerializerException {
        try {
            if (this.deserializationProperties.isUseStrictParser()) {
                String tmpSource = source;
                Integer i = 0;
                Integer i2 = tmpSource.indexOf(">");
                while (tmpSource.substring(i, i2).contains("<?")) {
                    i = i2;
                    i2 = tmpSource.indexOf(">", i + 1);
                }
                if (!tmpSource.substring(i, i2).contains(" xmlns=")) {
                    tmpSource = source.substring(0, i2).concat(" xmlns=\"urn:hl7-org:v2xml\"").concat(source.substring(i2));
                }
                return this.deserializationPipeParser.encode(this.deserializationXmlParser.parse(tmpSource));
            }
            String fieldSeparator = this.getNodeValue(source, "<MSH.1>", "</MSH.1>");
            if (StringUtils.isEmpty((CharSequence)fieldSeparator)) {
                fieldSeparator = "|";
            }
            String componentSeparator = "^";
            String repetitionSeparator = "~";
            String subcomponentSeparator = "&";
            String escapeCharacter = "\\";
            String separators = ampersandPattern.matcher(this.getNodeValue(source, "<MSH.2>", "</MSH.2>")).replaceAll("&");
            if (separators.length() == 4) {
                componentSeparator = separators.substring(0, 1);
                repetitionSeparator = separators.substring(1, 2);
                escapeCharacter = separators.substring(2, 3);
                subcomponentSeparator = separators.substring(3, 4);
            }
            XMLEncodedHL7Handler handler = new XMLEncodedHL7Handler(this.deserializationSegmentDelimiter, fieldSeparator, componentSeparator, repetitionSeparator, escapeCharacter, subcomponentSeparator, true);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(new StringReader(prettyPattern2.matcher(prettyPattern1.matcher(source).replaceAll("<$1>")).replaceAll("<$1>"))));
            return handler.getOutput().toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting XML to ER7", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to ER7", (Throwable)e));
        }
    }

    private String getNodeValue(String source, String startTag, String endTag) {
        int startIndex = -1;
        startIndex = source.indexOf(startTag);
        if (startIndex != -1) {
            return source.substring(startIndex + startTag.length(), source.indexOf(endTag, startIndex));
        }
        return "";
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.populateMetaData(message, map);
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
        block22: {
            try {
                int i;
                char c;
                int index;
                if (this.serializationProperties.isUseStrictParser()) {
                    Message hapiMessage = this.serializationPipeParser.parse(message.trim());
                    Terser terser = new Terser(hapiMessage);
                    try {
                        map.put("message_source", terser.get("/MSH-4-1"));
                    }
                    catch (HL7Exception e) {
                        this.logger.error("Error populating ER7 metadata.", (Throwable)e);
                    }
                    try {
                        map.put("message_type", terser.get("/MSH-9-1") + "-" + terser.get("/MSH-9-2"));
                    }
                    catch (HL7Exception e) {
                        this.logger.error("Error populating ER7 metadata.", (Throwable)e);
                    }
                    map.put("mirth_version", hapiMessage.getVersion());
                    break block22;
                }
                for (index = 0; index < message.length() && message.charAt(index) <= ' '; ++index) {
                }
                int segmentDelimiterIndex = -1;
                if (this.serializationProperties.isConvertLineBreaks()) {
                    for (int tempIndex = index; segmentDelimiterIndex == -1 && tempIndex < message.length(); ++tempIndex) {
                        if (!message.startsWith("\r", tempIndex) && !message.startsWith("\n", tempIndex) && (this.skipIntermediateDelimiter || !message.startsWith(this.serializationSegmentDelimiter, tempIndex))) continue;
                        segmentDelimiterIndex = tempIndex;
                    }
                } else {
                    segmentDelimiterIndex = message.indexOf(this.serializationSegmentDelimiter, index);
                }
                if (segmentDelimiterIndex == -1) {
                    segmentDelimiterIndex = message.length();
                }
                boolean mshFound = false;
                if (message.startsWith("MSH", index)) {
                    mshFound = true;
                }
                if (!(mshFound || message.startsWith("FHS", index) || message.startsWith("BHS", index))) {
                    return;
                }
                if ((index += 3) >= segmentDelimiterIndex || index >= message.length()) {
                    return;
                }
                char fieldSeparator = message.charAt(index++);
                int[] encodingCharacters = new int[]{-1, -1, -1, -1};
                while (index < segmentDelimiterIndex && index < message.length() && (c = message.charAt(index)) != fieldSeparator) {
                    for (i = 0; i < encodingCharacters.length; ++i) {
                        if (encodingCharacters[i] != -1) continue;
                        encodingCharacters[i] = c;
                        break;
                    }
                    ++index;
                }
                if (index >= segmentDelimiterIndex || index >= message.length()) {
                    return;
                }
                if ((index = message.indexOf(fieldSeparator, index + 1)) == -1 || index >= segmentDelimiterIndex || index >= message.length()) {
                    return;
                }
                map.put("message_source", this.getComponent(message, index + 1, fieldSeparator, encodingCharacters, segmentDelimiterIndex, false));
                for (i = 4; i <= 8; ++i) {
                    if ((index = message.indexOf(fieldSeparator, index + 1)) != -1 && index < segmentDelimiterIndex) continue;
                    return;
                }
                map.put("message_type", this.getComponent(message, index + 1, fieldSeparator, encodingCharacters, segmentDelimiterIndex, true));
                if (mshFound) {
                    for (i = 9; i <= 11; ++i) {
                        if ((index = message.indexOf(fieldSeparator, index + 1)) != -1 && index < segmentDelimiterIndex) continue;
                        return;
                    }
                    map.put("mirth_version", this.getComponent(message, index + 1, fieldSeparator, encodingCharacters, segmentDelimiterIndex, false));
                }
            }
            catch (Exception e) {
                this.logger.error("Error populating ER7 metadata.", (Throwable)e);
            }
        }
    }

    private String getComponent(String message, int index, int fieldSeparator, int[] encodingCharacters, int segmentDelimiterIndex, boolean combineSecond) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean resultEnd = false;
        int c = -1;
        int componentSeparator = encodingCharacters[0];
        int repetitionMarker = encodingCharacters[1];
        int subcomponentSeparator = encodingCharacters[3];
        while (index < segmentDelimiterIndex && index < message.length()) {
            char c2 = message.charAt(index);
            c = c2;
            if (c2 == fieldSeparator || c == componentSeparator || this.serializationProperties.isHandleRepetitions() && c == repetitionMarker) break;
            if (this.serializationProperties.isHandleSubcomponents() && c == subcomponentSeparator) {
                resultEnd = true;
            } else if (!resultEnd) {
                result.append((char)c);
            }
            ++index;
        }
        if (combineSecond && c == componentSeparator) {
            boolean secondFound = false;
            ++index;
            while (index < segmentDelimiterIndex && index < message.length()) {
                char c3 = message.charAt(index);
                c = c3;
                if (c3 == fieldSeparator || c == componentSeparator || this.serializationProperties.isHandleRepetitions() && c == repetitionMarker || this.serializationProperties.isHandleSubcomponents() && c == subcomponentSeparator) break;
                if (!secondFound) {
                    result.append('-');
                    secondFound = true;
                }
                result.append((char)c);
                ++index;
            }
        }
        return result.toString();
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }

    private class CustomPipeParser
    extends PipeParser {
        public CustomPipeParser(HapiContext context) {
            super(context);
        }

        protected Message instantiateMessage(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
            Message message = super.instantiateMessage(theName, theVersion, isExplicit);
            message.setParser((Parser)this);
            return message;
        }
    }

    private class CustomDefaultXMLParser
    extends DefaultXMLParser {
        public CustomDefaultXMLParser(HapiContext context) {
            super(context);
        }

        protected Message instantiateMessage(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
            Message message = super.instantiateMessage(theName, theVersion, isExplicit);
            message.setParser((Parser)this);
            return message;
        }
    }
}

