/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.CustomDriver;
import com.mirth.connect.connectors.jdbc.DatabaseReceiver;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverException;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverProperties;
import com.mirth.connect.connectors.jdbc.JdbcUtils;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.userutil.MirthCachedRowSet;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseReceiverQuery
implements DatabaseReceiverDelegate {
    private PreparedStatement selectStatement;
    private PreparedStatement updateStatement;
    private List<String> selectParams = new ArrayList<String>();
    private List<String> updateParams = new ArrayList<String>();
    private Connection selectConnection;
    private Connection updateConnection;
    private DatabaseReceiver connector;
    private DatabaseReceiverProperties connectorProperties;
    private final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private Logger logger = LogManager.getLogger(this.getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private CustomDriver customDriver;
    private String contextFactoryId;

    public DatabaseReceiverQuery(DatabaseReceiver connector) {
        this.connector = connector;
    }

    @Override
    public void deploy() throws ConnectorTaskException {
        MirthContextFactory contextFactory;
        this.connectorProperties = (DatabaseReceiverProperties)this.connector.getConnectorProperties();
        if (this.connectorProperties.getSelect() == null) {
            throw new ConnectorTaskException("A query has not been defined");
        }
        try {
            contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
            this.contextFactoryId = contextFactory.getId();
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error retrieving context factory.", (Throwable)e);
        }
        try {
            this.initDriver(contextFactory);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
    }

    @Override
    public void start() throws ConnectorTaskException {
        if (this.connectorProperties.isKeepConnectionOpen()) {
            try {
                this.checkContextFactory();
            }
            catch (Exception e) {
                throw new ConnectorTaskException((Throwable)e);
            }
            this.initConnection();
        }
    }

    private void initConnection() throws ConnectorTaskException {
        int attempts = 0;
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        int maxRetryCount = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryCount(), channelId, channelName), (int)0);
        int retryInterval = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryInterval(), channelId, channelName), (int)0);
        boolean done = false;
        while (!done) {
            try {
                this.initSelectConnection();
                if (this.connectorProperties.getUpdateMode() != 1) {
                    this.initUpdateConnection();
                }
                done = true;
            }
            catch (SQLException e) {
                this.closeSelectConnection();
                this.closeUpdateConnection();
                if (attempts++ < maxRetryCount) {
                    this.logger.error("An error occurred while initializing the connection on channel " + this.connector.getChannelId() + ",  retrying after " + retryInterval + " ms...", (Throwable)e);
                    try {
                        Thread.sleep(retryInterval);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw new ConnectorTaskException("Thread interrupted while trying to initialize database connection", (Throwable)e);
                    }
                }
                throw new ConnectorTaskException("Failed to initialize database connection", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() throws ConnectorTaskException {
        if (this.connectorProperties.isKeepConnectionOpen()) {
            this.closeSelectConnection();
            if (this.connectorProperties.getUpdateMode() != 1) {
                this.closeUpdateConnection();
            }
        }
    }

    @Override
    public void undeploy() {
    }

    @Override
    public Object poll() throws DatabaseReceiverException, InterruptedException {
        ResultSet resultSet = null;
        int attempts = 0;
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        int maxRetryCount = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryCount(), channelId, channelName), (int)0);
        int retryInterval = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryInterval(), channelId, channelName), (int)0);
        boolean done = false;
        boolean contextFactoryChanged = false;
        try {
            contextFactoryChanged = this.checkContextFactory();
        }
        catch (Exception e) {
            throw new DatabaseReceiverException(e);
        }
        while (!done && !this.connector.isTerminated()) {
            MirthCachedRowSet cachedRowSet = null;
            try {
                if (contextFactoryChanged || !this.connectorProperties.isKeepConnectionOpen()) {
                    this.initSelectConnection();
                    if (this.connectorProperties.getUpdateMode() == 3) {
                        this.initUpdateConnection();
                    }
                }
                int objectIndex = 1;
                for (Object param : JdbcUtils.getParameters(this.selectParams, this.connector.getChannelId(), this.connector.getChannel().getName(), null, null, null, true)) {
                    this.selectStatement.setObject(objectIndex++, param);
                }
                resultSet = this.selectStatement.executeQuery();
                if (this.connectorProperties.isCacheResults()) {
                    cachedRowSet = new MirthCachedRowSet();
                    cachedRowSet.populate(resultSet);
                    DbUtils.closeQuietly((ResultSet)resultSet);
                    resultSet = cachedRowSet;
                }
                done = true;
            }
            catch (SQLException e) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly(cachedRowSet);
                if (attempts++ < maxRetryCount && !this.connector.isTerminated()) {
                    this.logger.error("An error occurred while polling for messages on channel " + this.connector.getChannelId() + ", retrying after " + retryInterval + " ms...", (Throwable)e);
                    Thread.sleep(retryInterval);
                    if (!this.connectorProperties.isKeepConnectionOpen() || JdbcUtils.isValidConnection(this.selectConnection)) continue;
                    try {
                        this.initSelectConnection();
                    }
                    catch (SQLException sQLException) {}
                    continue;
                }
                throw new DatabaseReceiverException(e);
            }
        }
        return resultSet;
    }

    @Override
    public void runPostProcess(Map<String, Object> resultMap, ConnectorMessage mergedConnectorMessage) throws DatabaseReceiverException, InterruptedException {
        if (this.connectorProperties.getUpdateMode() == 3) {
            try {
                this.runUpdateStatement(NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryCount(), this.connector.getChannelId(), this.connector.getChannel().getName())), resultMap, mergedConnectorMessage);
            }
            catch (SQLException e) {
                throw new DatabaseReceiverException(e);
            }
        }
    }

    @Override
    public void runAggregatePostProcess(List<Map<String, Object>> resultsList, ConnectorMessage mergedConnectorMessage) throws DatabaseReceiverException, InterruptedException {
    }

    @Override
    public void afterPoll() throws DatabaseReceiverException {
        if (this.connectorProperties.getUpdateMode() == 2) {
            try {
                this.initUpdateConnection();
                this.runUpdateStatement(NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryCount(), this.connector.getChannelId(), this.connector.getChannel().getName())), null, null);
            }
            catch (SQLException e) {
                throw new DatabaseReceiverException(e);
            }
        }
        if (!this.connectorProperties.isKeepConnectionOpen()) {
            this.closeSelectConnection();
            this.closeUpdateConnection();
        }
    }

    private void runUpdateStatement(int retryCount, Map<String, Object> resultMap, ConnectorMessage mergedConnectorMessage) throws SQLException {
        try {
            int i = 1;
            for (Object param : JdbcUtils.getParameters(this.updateParams, this.connector.getChannelId(), this.connector.getChannel().getName(), mergedConnectorMessage, resultMap, null, true)) {
                this.updateStatement.setObject(i++, param);
            }
            this.updateStatement.execute();
        }
        catch (SQLException e) {
            if (retryCount < 1) {
                throw e;
            }
            if (!JdbcUtils.isValidConnection(this.updateConnection)) {
                this.initUpdateConnection();
            }
            this.logger.error("An error occurred while executing the post-process SQL, retrying", (Throwable)e);
            this.runUpdateStatement(retryCount - 1, resultMap, mergedConnectorMessage);
        }
    }

    private void initDriver(MirthContextFactory contextFactory) throws Exception {
        this.customDriver = null;
        try {
            ClassLoader isolatedClassLoader = contextFactory.getIsolatedClassLoader();
            if (isolatedClassLoader != null) {
                this.customDriver = new CustomDriver(isolatedClassLoader, this.connectorProperties.getDriver());
                this.logger.debug("Custom driver created: " + this.customDriver.toString() + ", Version " + this.customDriver.getMajorVersion() + "." + this.customDriver.getMinorVersion());
            } else {
                this.logger.debug("Custom classloader is not being used, defaulting to DriverManager.");
            }
        }
        catch (Exception e) {
            this.logger.debug("Error creating custom driver, defaulting to DriverManager.", (Throwable)e);
        }
        if (this.customDriver == null) {
            Class.forName(this.connectorProperties.getDriver());
        }
    }

    private boolean checkContextFactory() throws Exception {
        MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
        if (!this.contextFactoryId.equals(contextFactory.getId())) {
            this.initDriver(contextFactory);
            this.contextFactoryId = contextFactory.getId();
            return true;
        }
        return false;
    }

    private void initSelectConnection() throws SQLException {
        this.closeSelectConnection();
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        String url = this.replacer.replaceValues(this.connectorProperties.getUrl(), channelId, channelName);
        String username = this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName);
        String password = this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName);
        this.selectConnection = this.customDriver != null ? this.customDriver.connect(url, username, password) : DriverManager.getConnection(url, username, password);
        this.selectConnection.setAutoCommit(true);
        this.selectParams.clear();
        this.selectStatement = this.selectConnection.prepareStatement(JdbcUtils.extractParameters(this.connectorProperties.getSelect(), this.selectParams));
        if (!this.connectorProperties.isCacheResults()) {
            this.selectStatement.setFetchSize(NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getFetchSize(), channelId, channelName)));
        }
    }

    private void closeSelectConnection() {
        DbUtils.closeQuietly((Statement)this.selectStatement);
        try {
            if (this.selectConnection != null && !this.selectConnection.isClosed()) {
                this.selectConnection.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to close database connection", (Throwable)e);
        }
    }

    private void initUpdateConnection() throws SQLException {
        this.closeUpdateConnection();
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        String url = this.replacer.replaceValues(this.connectorProperties.getUrl(), channelId, channelName);
        String username = this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName);
        String password = this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName);
        this.updateConnection = this.customDriver != null ? this.customDriver.connect(url, username, password) : DriverManager.getConnection(url, username, password);
        this.updateConnection.setAutoCommit(true);
        this.updateParams.clear();
        this.updateStatement = this.updateConnection.prepareStatement(JdbcUtils.extractParameters(this.connectorProperties.getUpdate(), this.updateParams));
    }

    private void closeUpdateConnection() {
        DbUtils.closeQuietly((Statement)this.updateStatement);
        try {
            if (this.updateConnection != null && !this.updateConnection.isClosed()) {
                this.updateConnection.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to close database connection", (Throwable)e);
        }
    }
}

