/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.digest;

import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.plugins.httpauth.digest.DigestAuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.digest.DigestHttpAuthProperties;
import com.mirth.connect.server.channel.MirthMessageMaps;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class DigestAuthenticator
extends Authenticator {
    private static final String USERNAME = "username";
    private static final String REALM = "realm";
    private static final String DOMAIN = "domain";
    private static final String URI = "uri";
    private static final String NONCE = "nonce";
    private static final String NONCE_COUNT = "nc";
    private static final String CLIENT_NONCE = "cnonce";
    private static final String ALGORITHM = "algorithm";
    private static final String QOP = "qop";
    private static final String RESPONSE = "response";
    private static final String OPAQUE = "opaque";
    private static final String STALE = "stale";
    private static final long MAX_NONCE_AGE = 60000000000L;
    private static final int MAX_NONCE_COUNT = 1024;
    private Logger logger = LogManager.getLogger(this.getClass());
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private DigestAuthenticatorProvider provider;
    private SecureRandom rng = new SecureRandom();
    private Map<String, Nonce> nonceMap = new ConcurrentHashMap<String, Nonce>();
    private MessageMaps messageMaps;

    public DigestAuthenticator(DigestAuthenticatorProvider provider) {
        this.provider = provider;
        this.messageMaps = new MirthMessageMaps(provider.getConnector().getChannelId());
    }

    DigestAuthenticator(DigestAuthenticatorProvider provider, MessageMaps messageMaps) {
        this.provider = provider;
        this.messageMaps = messageMaps;
    }

    @Override
    public AuthenticationResult authenticate(RequestInfo request) {
        Status status;
        DigestHttpAuthProperties properties;
        block48: {
            properties = this.getReplacedProperties(request);
            List<String> authHeaderList = request.getHeaders().get(HttpHeader.AUTHORIZATION.asString());
            CaseInsensitiveMap directives = new CaseInsensitiveMap();
            String nonceString = null;
            String nonceCountString = null;
            String nonceOpaque = "";
            status = Status.INVALID;
            if (CollectionUtils.isNotEmpty(authHeaderList)) {
                String authHeader = authHeaderList.iterator().next();
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(authHeader, "=, ", true, false);
                String directive = null;
                String lastToken = null;
                while (tokenizer.hasMoreTokens()) {
                    char c;
                    String token = tokenizer.nextToken();
                    if (token.length() == 1 && ((c = token.charAt(0)) == '=' || c == ',' || c == ' ')) {
                        if (c == '=') {
                            directive = lastToken;
                            continue;
                        }
                        if (c != ',') continue;
                        directive = null;
                        continue;
                    }
                    if (directive != null) {
                        directives.put(directive, token);
                        directive = null;
                    }
                    lastToken = token;
                }
                nonceString = (String)directives.get(NONCE);
                nonceCountString = (String)directives.get(NONCE_COUNT);
                if (StringUtils.isNotBlank((CharSequence)nonceString)) {
                    Nonce nonce = this.nonceMap.get(nonceString);
                    if (nonce != null) {
                        nonceOpaque = nonce.getOpaque();
                        if (nonce.isExpired()) {
                            status = Status.STALE;
                        } else if (StringUtils.isNotBlank((CharSequence)nonceCountString)) {
                            try {
                                status = nonce.updateCount(Long.parseLong(nonceCountString, 16));
                            }
                            catch (NumberFormatException c) {}
                        } else {
                            status = nonce.incrementCount();
                        }
                    } else {
                        status = Status.STALE;
                    }
                }
            }
            this.cleanupNonces();
            if (status != Status.INVALID) {
                try {
                    String rsp;
                    String ha2;
                    String ha1;
                    String username = (String)directives.get(USERNAME);
                    String realm = (String)directives.get(REALM);
                    String uri = (String)directives.get(URI);
                    String response = (String)directives.get(RESPONSE);
                    String clientNonceString = (String)directives.get(CLIENT_NONCE);
                    String qop = (String)directives.get(QOP);
                    String algorithm = (String)directives.get(ALGORITHM);
                    String opaque = StringUtils.trimToEmpty((String)((String)directives.get(OPAQUE)));
                    if (StringUtils.isBlank((CharSequence)username)) {
                        throw new Exception("Username missing.");
                    }
                    if (StringUtils.isBlank((CharSequence)realm)) {
                        throw new Exception("Realm missing.");
                    }
                    if (uri == null) {
                        throw new Exception("URI missing.");
                    }
                    if (StringUtils.isBlank((CharSequence)response)) {
                        throw new Exception("Response digest missing.");
                    }
                    String requestURI = request.getRequestURI();
                    if (StringUtils.isEmpty((CharSequence)uri) && StringUtils.equals((CharSequence)requestURI, (CharSequence)"/")) {
                        requestURI = "";
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)properties.getRealm(), (CharSequence)realm)) {
                        throw new Exception("Realm \"" + realm + "\" does not match expected realm \"" + properties.getRealm() + "\".");
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)requestURI, (CharSequence)uri)) {
                        throw new Exception("URI \"" + uri + "\" does not match the request URI \"" + requestURI + "\".");
                    }
                    if (!StringUtils.equals((CharSequence)opaque, (CharSequence)nonceOpaque)) {
                        throw new Exception("Opaque value \"" + opaque + "\" does not match the expected value \"" + properties.getOpaque() + "\".");
                    }
                    Map<String, String> credentialsSource = this.getCredentials(properties);
                    String password = credentialsSource.get(username);
                    if (password == null) {
                        throw new Exception("Credentials for username " + username + " not found.");
                    }
                    if (algorithm == null || StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)DigestHttpAuthProperties.Algorithm.MD5.toString()) && properties.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5)) {
                        ha1 = this.digest(username, realm, password);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)DigestHttpAuthProperties.Algorithm.MD5_SESS.toString()) && properties.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5_SESS)) {
                        if (StringUtils.isBlank((CharSequence)clientNonceString)) {
                            throw new Exception("Client nonce missing.");
                        }
                        String credentialsDigest = this.digest(username, realm, password);
                        ha1 = this.digest(credentialsDigest, nonceString, clientNonceString);
                    } else {
                        throw new Exception("Algorithm \"" + algorithm + "\" not supported.");
                    }
                    if (qop == null || StringUtils.equalsIgnoreCase((CharSequence)qop, (CharSequence)DigestHttpAuthProperties.QOPMode.AUTH.toString()) && properties.getQopModes().contains(DigestHttpAuthProperties.QOPMode.AUTH)) {
                        ha2 = this.digest(request.getMethod(), uri);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)qop, (CharSequence)DigestHttpAuthProperties.QOPMode.AUTH_INT.toString()) && properties.getQopModes().contains(DigestHttpAuthProperties.QOPMode.AUTH_INT)) {
                        String entityDigest = this.digest(new Object[]{request.getEntityProvider().getEntity()});
                        ha2 = this.digest(request.getMethod(), uri, entityDigest);
                    } else {
                        throw new Exception("Quality of protection mode \"" + qop + "\" not supported.");
                    }
                    if (qop == null) {
                        rsp = this.digest(ha1, nonceString, ha2);
                    } else {
                        if (StringUtils.isBlank((CharSequence)nonceCountString)) {
                            throw new Exception("Nonce count missing.");
                        }
                        if (StringUtils.isBlank((CharSequence)clientNonceString)) {
                            throw new Exception("Client nonce missing.");
                        }
                        rsp = this.digest(ha1, nonceString, nonceCountString, clientNonceString, qop, ha2);
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("H(A1): " + ha1);
                        this.logger.trace("H(A2): " + ha2);
                        this.logger.trace("response: " + rsp);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)rsp, (CharSequence)response)) {
                        if (status == Status.VALID) {
                            return AuthenticationResult.Success(username, realm);
                        }
                        break block48;
                    }
                    throw new Exception("Response digest \"" + response + "\" does not match expected digest \"" + rsp + "\".");
                }
                catch (Exception e) {
                    this.logger.debug("Error validating digest response.", (Throwable)e);
                    status = Status.INVALID;
                }
            }
        }
        Nonce nonce = new Nonce(properties.getOpaque());
        this.nonceMap.put(nonce.getValue(), nonce);
        String contextPath = "/";
        try {
            contextPath = new URI(request.getRequestURI()).getPath();
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        HashMap<String, String> responseDirectives = new HashMap<String, String>();
        responseDirectives.put(REALM, properties.getRealm());
        responseDirectives.put(DOMAIN, contextPath);
        responseDirectives.put(NONCE, nonce.getValue());
        responseDirectives.put(ALGORITHM, StringUtils.join((Iterable)properties.getAlgorithms(), (char)','));
        if (CollectionUtils.isNotEmpty((Collection)properties.getQopModes())) {
            responseDirectives.put(QOP, StringUtils.join((Iterable)properties.getQopModes(), (char)','));
        }
        if (StringUtils.isNotBlank((CharSequence)nonce.getOpaque())) {
            responseDirectives.put(OPAQUE, nonce.getOpaque());
        }
        if (status == Status.STALE) {
            responseDirectives.put(STALE, "true");
        }
        StringBuilder digestBuilder = new StringBuilder("Digest ");
        Iterator it = responseDirectives.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            digestBuilder.append((String)entry.getKey());
            digestBuilder.append("=\"");
            digestBuilder.append((String)entry.getValue());
            digestBuilder.append('\"');
            if (!it.hasNext()) continue;
            digestBuilder.append(", ");
        }
        return AuthenticationResult.Challenged(digestBuilder.toString());
    }

    protected Map<String, String> getCredentials(DigestHttpAuthProperties properties) {
        HashMap<String, String> credentialsSource;
        block6: {
            if (properties.isUseCredentialsVariable()) {
                credentialsSource = new HashMap<String, String>();
                try {
                    Map source = (Map)this.messageMaps.get(properties.getCredentialsVariable(), null);
                    if (source != null) {
                        for (Map.Entry entry : source.entrySet()) {
                            credentialsSource.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                        }
                        break block6;
                    }
                    this.logger.warn("Credentials map variable '" + properties.getCredentialsVariable() + "' not found.");
                }
                catch (Exception e) {
                    this.logger.warn("Error getting credentials from map " + properties.getCredentialsVariable() + "'.", (Throwable)e);
                }
            } else {
                credentialsSource = properties.getCredentialsMap();
            }
        }
        return credentialsSource;
    }

    private void cleanupNonces() {
        Set<String> keySet = this.nonceMap.keySet();
        for (String nonceString : keySet.toArray(new String[keySet.size()])) {
            Nonce nonce = this.nonceMap.get(nonceString);
            if (nonce == null || !nonce.isExpired()) continue;
            this.nonceMap.remove(nonceString);
        }
    }

    private String digest(Object ... parts) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] instanceof InputStream) {
                int len;
                InputStream is = (InputStream)parts[i];
                byte[] buffer = new byte[1024];
                while ((len = IOUtils.read((InputStream)is, (byte[])buffer, (int)0, (int)buffer.length)) > 0) {
                    md.update(buffer, 0, len);
                }
            } else if (parts[i] instanceof byte[]) {
                md.update((byte[])parts[i]);
            } else {
                md.update(String.valueOf(parts[i]).getBytes(StandardCharsets.ISO_8859_1));
            }
            if (i >= parts.length - 1) continue;
            md.update((byte)58);
        }
        return TypeUtil.toString((byte[])md.digest(), (int)16);
    }

    private DigestHttpAuthProperties getReplacedProperties(RequestInfo request) {
        DigestHttpAuthProperties properties = new DigestHttpAuthProperties((DigestHttpAuthProperties)this.provider.getProperties());
        String channelId = this.provider.getConnector().getChannelId();
        String channelName = this.provider.getConnector().getChannel().getName();
        HashMap<String, Object> map = new HashMap<String, Object>();
        request.populateMap(map);
        properties.setRealm(this.replacer.replaceValues(properties.getRealm(), channelId, channelName, map));
        properties.setOpaque(this.replacer.replaceValues(properties.getOpaque(), channelId, channelName, map));
        LinkedHashMap<String, String> credentials = new LinkedHashMap<String, String>();
        for (Map.Entry entry : properties.getCredentialsMap().entrySet()) {
            String username = this.replacer.replaceValues((String)entry.getKey(), channelId, channelName, map);
            if (!StringUtils.isNotBlank((CharSequence)username)) continue;
            credentials.put(username, this.replacer.replaceValues((String)entry.getValue(), channelId, channelName, map));
        }
        properties.setCredentialsMap(credentials);
        properties.setCredentialsVariable(this.replacer.replaceValues(properties.getCredentialsVariable(), map));
        return properties;
    }

    private static enum Status {
        VALID,
        INVALID,
        STALE;

    }

    private class Nonce {
        private String value;
        private String opaque;
        private long created;
        private long count;

        public Nonce(String opaque) {
            this.opaque = StringUtils.trimToEmpty((String)opaque);
            byte[] buffer = new byte[24];
            DigestAuthenticator.this.rng.nextBytes(buffer);
            this.value = new String(Base64.encodeBase64((byte[])buffer), StandardCharsets.ISO_8859_1);
            this.created = System.nanoTime();
            this.count = 0L;
        }

        public String getValue() {
            return this.value;
        }

        public String getOpaque() {
            return this.opaque;
        }

        public boolean isExpired() {
            return System.nanoTime() - this.created > 60000000000L;
        }

        public synchronized Status incrementCount() {
            ++this.count;
            return this.count <= 1024L ? Status.VALID : Status.STALE;
        }

        public synchronized Status updateCount(long count) {
            if (count <= this.count) {
                return Status.INVALID;
            }
            this.count = count;
            if (this.count > 1024L) {
                return Status.STALE;
            }
            return Status.VALID;
        }
    }
}

