/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.oauth2;

import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.plugins.httpauth.oauth2.OAuth2AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.oauth2.OAuth2HttpAuthProperties;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.HttpUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class OAuth2Authenticator
extends Authenticator {
    private static final int SOCKET_TIMEOUT = 30000;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private OAuth2AuthenticatorProvider provider;

    public OAuth2Authenticator(OAuth2AuthenticatorProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationResult authenticate(RequestInfo request) throws Exception {
        Object object;
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block8: {
            OAuth2HttpAuthProperties properties = this.getReplacedProperties(request);
            client = null;
            response = null;
            try {
                List<String> headerList;
                List<String> paramList;
                RegistryBuilder socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
                ConnectorPluginProperties pluginProperties = null;
                if (CollectionUtils.isNotEmpty((Collection)properties.getConnectorPluginProperties())) {
                    pluginProperties = (ConnectorPluginProperties)properties.getConnectorPluginProperties().iterator().next();
                }
                this.provider.getHttpConfiguration().configureSocketFactoryRegistry(pluginProperties, socketFactoryRegistry);
                BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry.build());
                httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(30000).build());
                HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
                HttpUtil.configureClientBuilder((HttpClientBuilder)clientBuilder);
                client = clientBuilder.build();
                HttpClientContext context = HttpClientContext.create();
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setStaleConnectionCheckEnabled(true).build();
                context.setRequestConfig(requestConfig);
                URIBuilder uriBuilder = new URIBuilder(properties.getVerificationURL());
                if (properties.getTokenLocation() == OAuth2HttpAuthProperties.TokenLocation.QUERY && CollectionUtils.isNotEmpty(paramList = request.getQueryParameters().get(properties.getLocationKey()))) {
                    for (String value : paramList) {
                        uriBuilder.addParameter(properties.getLocationKey(), value);
                    }
                }
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                if (properties.getTokenLocation() == OAuth2HttpAuthProperties.TokenLocation.HEADER && CollectionUtils.isNotEmpty(headerList = request.getHeaders().get(properties.getLocationKey()))) {
                    for (String value : headerList) {
                        httpGet.addHeader(properties.getLocationKey(), value);
                    }
                }
                if ((response = client.execute((HttpUriRequest)httpGet, (HttpContext)context)).getStatusLine().getStatusCode() >= 400) break block8;
                object = AuthenticationResult.Success();
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                HttpClientUtils.closeQuietly(client);
                throw throwable;
            }
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            HttpClientUtils.closeQuietly((HttpClient)client);
            return object;
        }
        object = AuthenticationResult.Failure();
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return object;
    }

    private OAuth2HttpAuthProperties getReplacedProperties(RequestInfo request) {
        OAuth2HttpAuthProperties properties = new OAuth2HttpAuthProperties((OAuth2HttpAuthProperties)this.provider.getProperties());
        String channelId = this.provider.getConnector().getChannelId();
        String channelName = this.provider.getConnector().getChannel().getName();
        HashMap<String, Object> map = new HashMap<String, Object>();
        request.populateMap(map);
        properties.setLocationKey(this.replacer.replaceValues(properties.getLocationKey(), channelId, channelName, map));
        properties.setVerificationURL(this.replacer.replaceValues(properties.getVerificationURL(), channelId, channelName, map));
        return properties;
    }
}

