/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.fscc;

import java.nio.charset.StandardCharsets;
import jcifs.Encodable;
import jcifs.internal.util.SMBUtil;

public class FsctlPipeWaitRequest
implements Encodable {
    private final byte[] nameBytes;
    private final long timeout;
    private final boolean timeoutSpecified;

    public FsctlPipeWaitRequest(String name) {
        this.nameBytes = name.getBytes(StandardCharsets.UTF_16LE);
        this.timeoutSpecified = false;
        this.timeout = 0L;
    }

    public FsctlPipeWaitRequest(String name, long timeout) {
        this.nameBytes = name.getBytes(StandardCharsets.UTF_16LE);
        this.timeoutSpecified = true;
        this.timeout = timeout;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt8(this.timeout, dst, dstIndex);
        SMBUtil.writeInt4(this.nameBytes.length, dst, dstIndex += 8);
        dst[dstIndex += 4] = (byte)(this.timeoutSpecified ? 1 : 0);
        ++dstIndex;
        System.arraycopy(this.nameBytes, 0, dst, ++dstIndex, this.nameBytes.length);
        return (dstIndex += this.nameBytes.length) - start;
    }

    @Override
    public int size() {
        return 14 + this.nameBytes.length;
    }
}

