/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans2;

import jcifs.Configuration;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class Trans2QueryPathInformation
extends SmbComTransaction {
    private final int informationLevel;

    public Trans2QueryPathInformation(Configuration config, String filename, int informationLevel) {
        super(config, (byte)50, (byte)5);
        this.path = filename;
        this.informationLevel = informationLevel;
        this.totalDataCount = 0;
        this.maxParameterCount = 2;
        this.maxDataCount = 40;
        this.maxSetupCount = 0;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.getSubCommand();
        dst[dstIndex++] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(Trans2QueryPathInformation.mapInformationLevel(this.informationLevel), dst, dstIndex);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    static long mapInformationLevel(int il) {
        switch (il) {
            case 4: {
                return 257L;
            }
            case 5: {
                return 258L;
            }
            case 20: {
                return 260L;
            }
        }
        throw new IllegalArgumentException("Unsupported information level " + il);
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Trans2QueryPathInformation[" + super.toString() + ",informationLevel=0x" + Hexdump.toHexString(this.informationLevel, 3) + ",filename=" + this.path + "]");
    }
}

