/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupGroupDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel descriptionLabel;
    private JTextArea descriptionField;
    private JScrollPane descriptionScrollPane;
    private JLabel versionLabel;
    private JTextField versionField;
    private JLabel cacheSizeLabel;
    private JTextField cacheSizeField;
    private JLabel cachePolicyLabel;
    private JComboBox<String> cachePolicyComboBox;
    private JButton saveButton;
    private JButton cancelButton;
    private Frame parent;
    private LookupGroup lookupGroup;
    private boolean saved = false;

    public LookupGroupDialog(Frame frame, LookupGroup lookupGroup, boolean bl) {
        super((Window)frame, true);
        this.parent = frame;
        this.lookupGroup = lookupGroup;
        this.initComponents();
        this.initLayout();
        this.resetComponents(lookupGroup);
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("%s", bl ? "Edit Group" : "Add Group"));
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.nameLabel = new JLabel("Name:");
        this.nameField = new JTextField();
        this.descriptionLabel = new JLabel("Description:");
        this.descriptionField = new JTextArea();
        this.descriptionField.setWrapStyleWord(true);
        this.descriptionField.setLineWrap(true);
        this.descriptionScrollPane = new JScrollPane(this.descriptionField, 20, 31);
        this.descriptionScrollPane.setPreferredSize(new Dimension(200, 50));
        this.versionLabel = new JLabel("Version:");
        this.versionField = new JTextField();
        this.cacheSizeLabel = new JLabel("Cache Size:");
        this.cacheSizeField = new JTextField();
        this.cacheSizeField.setDocument((Document)new MirthFieldConstraints(8, false, false, true));
        this.cachePolicyLabel = new JLabel("Cache Policy:");
        this.cachePolicyComboBox = new JComboBox();
        this.cachePolicyComboBox.addItem("LRU");
        this.cachePolicyComboBox.addItem("FIFO");
        this.cachePolicyComboBox.getModel().setSelectedItem("LRU");
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][fill]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setMinimumSize(this.getMinimumSize());
        jPanel.setMaximumSize(this.getMaximumSize());
        jPanel.add((Component)this.nameLabel, "right");
        jPanel.add((Component)this.nameField, "w 200!");
        jPanel.add((Component)this.descriptionLabel, "newline, right");
        jPanel.add(this.descriptionScrollPane);
        jPanel.add((Component)this.versionLabel, "newline, right");
        jPanel.add((Component)this.versionField, "w 100!");
        jPanel.add((Component)this.cacheSizeLabel, "newline, right");
        jPanel.add((Component)this.cacheSizeField, "w 100!, split 2");
        JLabel jLabel = new JLabel("<html><span style='color:#666;'>0 = disabled</span></html>");
        jPanel.add((Component)jLabel, "gapleft 6");
        jPanel.add((Component)this.cachePolicyLabel, "newline, right");
        jPanel.add(this.cachePolicyComboBox, "w 100!");
        this.add(jPanel, "growx");
        this.add(new JSeparator(), "newline, sx, growx");
        this.add(this.saveButton, "newline, sx, right, split 2");
        this.add(this.cancelButton);
    }

    private void resetComponents(LookupGroup lookupGroup) {
        this.nameField.setText(lookupGroup.getName());
        this.descriptionField.setText(lookupGroup.getDescription());
        this.versionField.setText(lookupGroup.getVersion());
        this.cacheSizeField.setText(String.valueOf(lookupGroup.getCacheSize()));
        this.cachePolicyComboBox.getModel().setSelectedItem(lookupGroup.getCachePolicy());
    }

    private void save() {
        if (!this.validateProperties()) {
            return;
        }
        this.lookupGroup.setName(this.nameField.getText().trim());
        this.lookupGroup.setDescription(this.descriptionField.getText().trim());
        this.lookupGroup.setVersion(this.versionField.getText().trim());
        this.lookupGroup.setCacheSize(Integer.parseInt(this.cacheSizeField.getText().trim()));
        this.lookupGroup.setCachePolicy((String)this.cachePolicyComboBox.getSelectedItem());
        try {
            LookupGroup lookupGroup = this.lookupGroup.getId() > 0 ? LookupServiceClient.getInstance().updateGroup(this.lookupGroup) : LookupServiceClient.getInstance().createGroup(this.lookupGroup);
            this.lookupGroup.setId(lookupGroup.getId());
            this.lookupGroup.setCreatedDate(lookupGroup.getCreatedDate());
            this.lookupGroup.setUpdatedDate(lookupGroup.getUpdatedDate());
            this.saved = true;
            this.close();
        }
        catch (LookupApiClientException lookupApiClientException) {
            this.showError(lookupApiClientException.getError().getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving group", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }

    private void close() {
        this.dispose();
    }

    public boolean isSaved() {
        return this.saved;
    }

    private boolean validateProperties() {
        String string;
        String string2;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        this.resetInvalidComponents();
        String string3 = this.nameField.getText().trim();
        if (StringUtils.isEmpty((CharSequence)string3)) {
            bl = false;
            this.nameField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a name.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string2 = this.versionField.getText().trim()))) {
            bl = false;
            this.versionField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a version.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string = this.cacheSizeField.getText().trim()))) {
            bl = false;
            this.cacheSizeField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a cache size.").append(System.lineSeparator());
        }
        if (!bl) {
            this.showError(stringBuilder.toString());
        }
        return bl;
    }

    public void resetInvalidComponents() {
        this.nameField.setBackground(null);
        this.versionField.setBackground(null);
        this.cacheSizeField.setBackground(null);
    }

    protected void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), string);
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }
}

