/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.model;

import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;

public class LookupGroupTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Group Name", "Updated Date"};
    private final List<LookupGroup> allGroups = new ArrayList<LookupGroup>();
    private List<LookupGroup> filteredGroups = new ArrayList<LookupGroup>();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
    private String lastFilterText = "";

    @Override
    public int getRowCount() {
        return this.filteredGroups.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LookupGroup lookupGroup = this.filteredGroups.get(n);
        switch (n2) {
            case 0: {
                return lookupGroup.getName();
            }
            case 1: {
                return this.formatter.format(lookupGroup.getUpdatedDate());
            }
        }
        return null;
    }

    public void addGroup(LookupGroup lookupGroup) {
        this.allGroups.add(lookupGroup);
        this.reapplyFilter();
        this.fireTableDataChanged();
    }

    public void removeGroup(int n) {
        LookupGroup lookupGroup = this.filteredGroups.get(n);
        this.allGroups.remove(lookupGroup);
        this.reapplyFilter();
        this.fireTableDataChanged();
    }

    public void updateGroupById(LookupGroup lookupGroup) {
        int n = this.getIndexByGroupId(lookupGroup.getId());
        if (n >= 0) {
            this.allGroups.set(n, lookupGroup);
            this.reapplyFilter();
            this.fireTableDataChanged();
        }
    }

    public void addOrUpdateGroup(LookupGroup lookupGroup) {
        int n = this.getIndexByGroupId(lookupGroup.getId());
        if (n >= 0) {
            this.allGroups.set(n, lookupGroup);
        } else {
            this.allGroups.add(lookupGroup);
        }
        this.reapplyFilter();
        this.fireTableDataChanged();
    }

    public LookupGroup getGroup(int n) {
        return this.filteredGroups.get(n);
    }

    public void setGroups(List<LookupGroup> list) {
        this.allGroups.clear();
        this.allGroups.addAll(list);
        this.reapplyFilter();
        this.fireTableDataChanged();
    }

    public List<LookupGroup> getAllGroups() {
        return new ArrayList<LookupGroup>(this.allGroups);
    }

    public void clear() {
        this.allGroups.clear();
        this.filteredGroups.clear();
        this.fireTableDataChanged();
    }

    public void setFilter(String string) {
        this.lastFilterText = string != null ? string.trim().toLowerCase() : "";
        this.filteredGroups = this.lastFilterText.isEmpty() ? new ArrayList<LookupGroup>(this.allGroups) : this.allGroups.stream().filter(lookupGroup -> lookupGroup.getName().toLowerCase().contains(this.lastFilterText)).collect(Collectors.toList());
        this.fireTableDataChanged();
    }

    public void clearFilter() {
        this.setFilter("");
    }

    public void reapplyFilter() {
        this.setFilter(this.lastFilterText);
    }

    public int getIndexByGroupId(int n) {
        for (int i = 0; i < this.allGroups.size(); ++i) {
            if (this.allGroups.get(i).getId() != n) continue;
            return i;
        }
        return -1;
    }

    public int getFilteredIndexByGroupId(int n) {
        for (int i = 0; i < this.filteredGroups.size(); ++i) {
            if (this.filteredGroups.get(i).getId() != n) continue;
            return i;
        }
        return -1;
    }

    public boolean containsGroupId(int n) {
        return this.getIndexByGroupId(n) >= 0;
    }
}

