/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.dialog.ImportLookupGroupDialog;
import com.mirth.connect.plugins.dynamiclookup.client.dialog.LookupGroupDialog;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.model.LookupGroupTableModel;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.client.util.FileChooser;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.ImportLookupGroupRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportGroupPagedResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final com.mirth.connect.client.ui.Frame parent = PlatformUI.MIRTH_FRAME;
    private JTextField groupFilterField;
    private JButton addGroupButton;
    private JButton importButton;
    private JTable groupTable;
    private LookupGroupTableModel groupTableModel;
    private JPopupMenu groupPopupMenu;

    public GroupPanel() {
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.groupFilterField = new JTextField();
        this.groupFilterField.setToolTipText("Filter groups by name");
        this.groupFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GroupPanel.this.filterGroups();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GroupPanel.this.filterGroups();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GroupPanel.this.filterGroups();
            }
        });
        this.addGroupButton = new JButton("Add");
        this.addGroupButton.addActionListener(actionEvent -> this.handleAddGroup());
        this.importButton = new JButton("Import JSON");
        this.importButton.setToolTipText("Import a lookup group and its values from a JSON file");
        this.importButton.addActionListener(actionEvent -> this.handleImportJson());
        this.groupTableModel = new LookupGroupTableModel();
        this.groupTable = new JTable(this.groupTableModel);
        this.groupTable.setRowHeight(26);
        this.groupTable.setSelectionMode(0);
        this.groupPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Edit");
        jMenuItem.addActionListener(actionEvent -> this.handleEditGroup());
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(actionEvent -> this.handleDeleteGroup());
        JMenuItem jMenuItem3 = new JMenuItem("Export JSON");
        jMenuItem3.addActionListener(actionEvent -> this.handleExportJson());
        this.groupPopupMenu.add(jMenuItem);
        this.groupPopupMenu.add(jMenuItem2);
        this.groupPopupMenu.add(jMenuItem3);
        this.groupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            private void showPopup(MouseEvent mouseEvent) {
                int n = GroupPanel.this.groupTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    GroupPanel.this.groupTable.setRowSelectionInterval(n, n);
                    GroupPanel.this.groupPopupMenu.show(GroupPanel.this.groupTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 8, fill"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createTitledBorder("Lookup Groups"));
        jPanel.add((Component)this.groupFilterField, "w 150!, growx, split 3");
        jPanel.add(this.addGroupButton);
        jPanel.add((Component)this.importButton, "wrap");
        jPanel.add((Component)new JScrollPane(this.groupTable), "grow, push, wrap");
        this.add((Component)jPanel, "grow, push");
    }

    private void filterGroups() {
        String string = this.groupFilterField.getText().trim().toLowerCase();
        this.groupTableModel.setFilter(string);
    }

    private void handleAddGroup() {
        LookupGroup lookupGroup = new LookupGroup();
        LookupGroupDialog lookupGroupDialog = new LookupGroupDialog(this.parent, lookupGroup, false);
        if (lookupGroupDialog.isSaved()) {
            int n = this.groupTable.getSelectedRow();
            this.groupTableModel.addGroup(lookupGroup);
            if (n >= 0 && n < this.groupTableModel.getRowCount()) {
                this.groupTable.setRowSelectionInterval(n, n);
            }
        }
    }

    private void importFromJSON(final File file) {
        if (file == null || !this.checkJsonFile(file)) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)this.parent, "<html>If the group you're importing already exists,<br><b>its information will be updated</b> and <b>all existing values will be permanently deleted</b> and replaced.<br><br>Do you want to proceed with updating the group?</html>", "Confirm Import Overwrite", 0, 2);
        if (n != 0) {
            return;
        }
        final JDialog jDialog = new JDialog((Frame)this.parent, "Importing JSON", true);
        final JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setStringPainted(true);
        final JLabel jLabel = new JLabel("Imported 0 entries");
        JButton jButton = new JButton("Cancel");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jDialog.setLayout(new BorderLayout(10, 10));
        jDialog.add((Component)jLabel, "North");
        jDialog.add((Component)jProgressBar, "Center");
        jDialog.add((Component)jPanel, "South");
        jDialog.setSize(350, 120);
        jDialog.setLocationRelativeTo((Component)this.parent);
        jDialog.setDefaultCloseOperation(0);
        final SwingWorker<Void, int[]> swingWorker = new SwingWorker<Void, int[]>(){
            int finalGroupId = -1;

            @Override
            protected Void doInBackground() throws Exception {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(file);
                int n = 0;
                JsonNode jsonNode2 = jsonNode.get("values");
                if (jsonNode2 != null && jsonNode2.isObject()) {
                    n = jsonNode2.size();
                }
                try (JsonParser jsonParser = objectMapper.getFactory().createParser(file);){
                    int n2 = -1;
                    boolean bl = false;
                    int n3 = 1000;
                    int n4 = 0;
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken != JsonToken.START_OBJECT) {
                        throw new IllegalStateException("Expected START_OBJECT at beginning of JSON file.");
                    }
                    while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                        Object object;
                        Object object2;
                        String string = jsonParser.getCurrentName();
                        if ("group".equals(string)) {
                            jsonParser.nextToken();
                            object2 = (JsonNode)jsonParser.readValueAsTree();
                            object = new ImportLookupGroupRequest();
                            object.setGroup((LookupGroup)JsonUtils.fromJson((String)object2.toString(), LookupGroup.class));
                            object.setValues(Collections.emptyMap());
                            object.validate();
                            ImportLookupGroupResponse importLookupGroupResponse = LookupServiceClient.getInstance().importGroup(true, JsonUtils.toJson((Object)object));
                            n2 = importLookupGroupResponse.getGroupId();
                            bl = true;
                            this.finalGroupId = n2;
                            continue;
                        }
                        if ("values".equals(string)) {
                            if (!bl) {
                                throw new IllegalStateException("JSON file does not contain a valid 'group' object.");
                            }
                            jsonParser.nextToken();
                            while (jsonParser.nextToken() != JsonToken.END_OBJECT && !this.isCancelled()) {
                                object2 = jsonParser.getCurrentName();
                                jsonParser.nextToken();
                                object = jsonParser.getValueAsString();
                                linkedHashMap.put((String)object2, (String)object);
                                ++n4;
                                if (linkedHashMap.size() < n3) continue;
                                LookupServiceClient.getInstance().importValues(n2, false, linkedHashMap);
                                linkedHashMap.clear();
                                this.publishProgress(n4, n);
                            }
                            if (linkedHashMap.isEmpty() || this.isCancelled()) continue;
                            LookupServiceClient.getInstance().importValues(n2, false, linkedHashMap);
                            this.publishProgress(n4, n);
                            continue;
                        }
                        jsonParser.skipChildren();
                    }
                    com.mirth.connect.client.ui.Frame.userPreferences.put("currentDirectory", file.getParent());
                }
                catch (Exception exception) {
                    GroupPanel.this.logger.error("Failed to import lookup group from JSON file", (Throwable)exception);
                    throw exception;
                }
                return null;
            }

            private void publishProgress(int n, int n2) {
                int n3 = n2 > 0 ? (int)((double)n / (double)n2 * 100.0) : 0;
                n3 = Math.min(n3, 100);
                this.publish((V[])new int[][]{{n3, n, n2}});
            }

            @Override
            protected void process(List<int[]> list) {
                if (!list.isEmpty()) {
                    int[] nArray = list.get(list.size() - 1);
                    jProgressBar.setIndeterminate(false);
                    jProgressBar.setValue(nArray[0]);
                    jLabel.setText("Imported " + nArray[1] + " of " + nArray[2] + " entries");
                }
            }

            @Override
            protected void done() {
                block7: {
                    jDialog.dispose();
                    if (this.isCancelled()) {
                        JOptionPane.showMessageDialog((Component)GroupPanel.this.parent, "Import cancelled by user.", "Import Cancelled", 2);
                        return;
                    }
                    try {
                        this.get();
                        JOptionPane.showMessageDialog((Component)GroupPanel.this.parent, "Import completed successfully.", "Import Complete", 1);
                        if (this.finalGroupId == -1) break block7;
                        LookupGroup lookupGroup = GroupPanel.this.groupTable.getSelectedRow() >= 0 ? GroupPanel.this.groupTableModel.getGroup(GroupPanel.this.groupTable.getSelectedRow()) : null;
                        try {
                            int n;
                            LookupGroup lookupGroup2 = LookupServiceClient.getInstance().getGroupById(this.finalGroupId);
                            GroupPanel.this.groupTableModel.addOrUpdateGroup(lookupGroup2);
                            if (lookupGroup != null && (n = GroupPanel.this.groupTableModel.getFilteredIndexByGroupId(lookupGroup.getId())) >= 0) {
                                GroupPanel.this.groupTable.setRowSelectionInterval(n, n);
                                GroupPanel.this.groupTable.scrollRectToVisible(GroupPanel.this.groupTable.getCellRect(n, 0, true));
                            }
                        }
                        catch (Exception exception) {
                            GroupPanel.this.logger.warn("Imported group added, but failed to update table", (Throwable)exception);
                        }
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        GroupPanel.this.showError("Import failed: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getSimpleName()));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        GroupPanel.this.showError("Import was interrupted.");
                    }
                }
            }
        };
        jButton.addActionListener(actionEvent -> swingWorker.cancel(true));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (JOptionPane.showConfirmDialog(jDialog, "Cancel import?", "Confirm", 0) == 0) {
                    swingWorker.cancel(true);
                }
            }
        });
        swingWorker.execute();
        jDialog.setVisible(true);
    }

    private void handleImportJson() {
        ImportLookupGroupDialog importLookupGroupDialog = new ImportLookupGroupDialog(this.parent);
        if (!importLookupGroupDialog.isSaved()) {
            return;
        }
        Properties properties = importLookupGroupDialog.getImportProperties();
        String string = properties.getProperty("defaultGroup");
        if ("system".equals(properties.getProperty("importMethod"))) {
            String string2 = "/defaultLookUpTables/default-" + string.replace(" ", "_") + "-group.json";
            try (InputStream inputStream = this.getClass().getResourceAsStream(string2);){
                if (inputStream == null) {
                    throw new Exception("Resource not found: " + string2);
                }
                File file = File.createTempFile("default-", ".json");
                file.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    inputStream.transferTo(fileOutputStream);
                }
                this.importFromJSON(file);
            }
            catch (Exception exception) {
                this.logger.error("Failed to load resource: " + string2, (Throwable)exception);
            }
        } else if ("file".equals(properties.getProperty("importMethod"))) {
            this.importFromJSON(properties.getProperty("filePath") != null ? new File(properties.getProperty("filePath")) : null);
        } else {
            this.showError("Invalid import method selected.");
        }
    }

    private boolean checkJsonFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".json")) {
            this.showError("File does not have a .json extension.");
            return false;
        }
        try {
            Path path = file.toPath();
            String string = Files.probeContentType(path);
            if (string == null || !string.equals("application/json") && !string.equals("text/plain")) {
                this.showError("File does not appear to be a valid JSON (detected type: " + string + ").");
                return false;
            }
        }
        catch (IOException iOException) {
            this.showError("Failed to detect file type: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    private void handleEditGroup() {
        LookupGroup lookupGroup;
        LookupGroup lookupGroup2;
        LookupGroupDialog lookupGroupDialog;
        int n = this.groupTable.getSelectedRow();
        if (n >= 0 && (lookupGroupDialog = new LookupGroupDialog(this.parent, lookupGroup2 = new LookupGroup(lookupGroup = this.groupTableModel.getGroup(n)), true)).isSaved()) {
            this.groupTableModel.updateGroupById(lookupGroup2);
            int n2 = this.groupTableModel.getFilteredIndexByGroupId(lookupGroup2.getId());
            if (n2 >= 0) {
                this.groupTable.setRowSelectionInterval(n2, n2);
                this.groupTable.scrollRectToVisible(this.groupTable.getCellRect(n2, 0, true));
            }
        }
    }

    private void handleDeleteGroup() {
        int n = this.groupTable.getSelectedRow();
        if (n >= 0) {
            LookupGroup lookupGroup = this.groupTableModel.getGroup(n);
            int n2 = JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you want to delete group: " + lookupGroup.getName() + "?", "Confirm Delete", 0);
            if (n2 != 0) {
                return;
            }
            try {
                LookupServiceClient.getInstance().deleteGroup(lookupGroup.getId());
                this.groupTableModel.removeGroup(n);
                if (this.groupTableModel.getRowCount() > 0) {
                    int n3 = Math.min(n, this.groupTableModel.getRowCount() - 1);
                    this.groupTable.setRowSelectionInterval(n3, n3);
                } else {
                    this.groupTable.clearSelection();
                }
            }
            catch (LookupApiClientException lookupApiClientException) {
                this.showError(lookupApiClientException.getError().getMessage());
            }
            catch (Exception exception) {
                this.logger.error("Unexpected error while remove value", (Throwable)exception);
                this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
            }
        }
    }

    private void handleExportJson() {
        String string;
        int n = this.groupTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        final LookupGroup lookupGroup = this.groupTableModel.getGroup(n);
        String string2 = lookupGroup.getName().toLowerCase().replaceAll("[^a-z0-9]+", "_");
        String string3 = "lookup_group_" + string2 + "_export_" + (string = new SimpleDateFormat("yyyy_MM_dd_HH_mm").format(new Date())) + ".json";
        final File file = new FileChooser().createFileForExport(this.parent, string3, "json");
        if (file == null) {
            return;
        }
        final JDialog jDialog = new JDialog((Frame)this.parent, "Exporting JSON", true);
        final JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setStringPainted(true);
        final JLabel jLabel = new JLabel("Exported 0 of ? entries");
        JButton jButton = new JButton("Cancel");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jDialog.setLayout(new BorderLayout(10, 10));
        jDialog.add((Component)jLabel, "North");
        jDialog.add((Component)jProgressBar, "Center");
        jDialog.add((Component)jPanel, "South");
        jDialog.setSize(350, 120);
        jDialog.setLocationRelativeTo((Component)this.parent);
        jDialog.setDefaultCloseOperation(0);
        final SwingWorker<Void, int[]> swingWorker = new SwingWorker<Void, int[]>(){

            @Override
            protected Void doInBackground() throws Exception {
                int n = 0;
                int n2 = 10000;
                int n3 = 0;
                int n4 = -1;
                Date date = null;
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                try {
                    ExportGroupPagedResponse exportGroupPagedResponse = LookupServiceClient.getInstance().exportGroupPaged(lookupGroup.getId(), n, n2);
                    date = exportGroupPagedResponse.getExportDate();
                    n4 = exportGroupPagedResponse.getTotalCount();
                    linkedHashMap.putAll(exportGroupPagedResponse.getValues());
                    this.publishProgress(n3 += exportGroupPagedResponse.getValues().size(), n4);
                    while (!this.isCancelled() && exportGroupPagedResponse.getPagination().isHasMore()) {
                        exportGroupPagedResponse = LookupServiceClient.getInstance().exportGroupPaged(lookupGroup.getId(), n += n2, n2);
                        linkedHashMap.putAll(exportGroupPagedResponse.getValues());
                        this.publishProgress(n3 += exportGroupPagedResponse.getValues().size(), n4);
                    }
                    ExportLookupGroupResponse exportLookupGroupResponse = new ExportLookupGroupResponse();
                    exportLookupGroupResponse.setGroup(lookupGroup);
                    exportLookupGroupResponse.setValues(linkedHashMap);
                    exportLookupGroupResponse.setExportDate(date);
                    String string = JsonUtils.toJsonPretty((Object)exportLookupGroupResponse);
                    Files.write(file.toPath(), string.getBytes(), new OpenOption[0]);
                }
                catch (Exception exception) {
                    GroupPanel.this.logger.error("Failed to export group to JSON", (Throwable)exception);
                    throw exception;
                }
                return null;
            }

            private void publishProgress(int n, int n2) {
                int n3 = n2 > 0 ? (int)((double)n / (double)n2 * 100.0) : 0;
                n3 = Math.min(n3, 100);
                this.publish((V[])new int[][]{{n3, n, n2}});
            }

            @Override
            protected void process(List<int[]> list) {
                if (!list.isEmpty()) {
                    int[] nArray = list.get(list.size() - 1);
                    jProgressBar.setValue(nArray[0]);
                    jLabel.setText("Exported " + nArray[1] + " of " + nArray[2] + " entries");
                }
            }

            @Override
            protected void done() {
                jDialog.dispose();
                if (this.isCancelled()) {
                    JOptionPane.showMessageDialog((Component)GroupPanel.this.parent, "Export cancelled by user.", "Cancelled", 2);
                    return;
                }
                try {
                    this.get();
                    JOptionPane.showMessageDialog((Component)GroupPanel.this.parent, "JSON export completed.", "Export Complete", 1);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    GroupPanel.this.showError("Export failed: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getSimpleName()));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    GroupPanel.this.showError("Export was interrupted.");
                }
            }
        };
        jButton.addActionListener(actionEvent -> swingWorker.cancel(true));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(jDialog, "Export is still in progress. Do you want to cancel?", "Confirm Cancel", 0);
                if (n == 0) {
                    swingWorker.cancel(true);
                }
            }
        });
        swingWorker.execute();
        jDialog.setVisible(true);
    }

    public void addGroupSelectionListener(ListSelectionListener listSelectionListener) {
        this.groupTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public LookupGroup getSelectedGroup() {
        int n = this.groupTable.getSelectedRow();
        return n >= 0 ? this.groupTableModel.getGroup(n) : null;
    }

    public void clearGroups() {
        this.groupTableModel.clear();
    }

    public void updateGroupTable(List<LookupGroup> list) {
        this.groupTableModel.setGroups(list);
    }

    private void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)this.parent, string);
    }
}

