/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthDatePicker;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import com.mirth.connect.model.User;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.model.LookupAuditTableModel;
import com.mirth.connect.plugins.dynamiclookup.client.panel.NoGroupSelectedPanel;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupAuditEntriesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.HistoryFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.DateFormatter;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoryPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Frame parent = PlatformUI.MIRTH_FRAME;
    private JPanel noGroupSelectedPanel;
    private JPanel contentPanel;
    private JTable auditTable;
    private LookupAuditTableModel auditTableModel;
    private JTextField keyFilterField;
    private JComboBox<String> actionFilterComboBox;
    private JComboBox<String> userFilterComboBox;
    private MirthDatePicker startDatePicker;
    private MirthTimePicker startTimePicker;
    private MirthDatePicker endDatePicker;
    private MirthTimePicker endTimePicker;
    private JButton searchButton;
    private JButton clearButton;
    private JButton prevPageButton;
    private JButton nextPageButton;
    private JButton goToPageButton;
    private JLabel pageInfoLabel;
    private JComboBox<Integer> pageSizeComboBox;
    private LookupGroup selectedGroup;
    private Map<Integer, String> userMapById = new LinkedHashMap<Integer, String>();
    private int currentPage = 1;
    private int pageSize = 25;
    private int totalCount = 0;

    public HistoryPanel() {
        this.initComponents();
        this.initLayout();
        this.updateHistory(null);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.noGroupSelectedPanel = new NoGroupSelectedPanel();
        this.startDatePicker = new MirthDatePicker();
        this.startTimePicker = new MirthTimePicker();
        this.startTimePicker.setSaveEnabled(false);
        this.startDatePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HistoryPanel.this.startTimePicker.setEnabled(HistoryPanel.this.startDatePicker.getDate() != null);
            }
        });
        this.endDatePicker = new MirthDatePicker();
        this.endTimePicker = new MirthTimePicker();
        this.endTimePicker.setSaveEnabled(false);
        this.endDatePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HistoryPanel.this.endTimePicker.setEnabled(HistoryPanel.this.endDatePicker.getDate() != null);
            }
        });
        this.keyFilterField = new JTextField();
        this.keyFilterField.setToolTipText("Filter History by Key");
        this.keyFilterField.addActionListener(actionEvent -> {
            this.currentPage = 1;
            this.loadPage(this.currentPage);
        });
        this.actionFilterComboBox = new JComboBox<String>(new String[]{"ALL", "CREATE", "UPDATE", "DELETE", "DELETE_ALL", "IMPORT", "CLEAR_ALL"});
        this.userFilterComboBox = new JComboBox<String>(new String[0]);
        this.searchButton = new JButton("", UIManager.getIcon("FileView.fileIcon"));
        this.searchButton.setIcon(UIConstants.ICON_FILE_PICKER);
        this.searchButton.setToolTipText("Search");
        this.searchButton.setIconTextGap(5);
        this.searchButton.addActionListener(actionEvent -> {
            this.currentPage = 1;
            this.loadPage(this.currentPage);
        });
        this.clearButton = new JButton("");
        this.clearButton.setIcon(UIConstants.ICON_X);
        this.clearButton.setToolTipText("Clear");
        this.clearButton.addActionListener(actionEvent -> {
            this.clearFilterFields();
            this.currentPage = 1;
            this.loadPage(this.currentPage);
        });
        this.auditTableModel = new LookupAuditTableModel();
        this.auditTable = new JTable(this.auditTableModel);
        this.auditTable.setRowHeight(26);
        this.prevPageButton = new JButton("Previous");
        this.prevPageButton.addActionListener(actionEvent -> this.goToPage(this.currentPage - 1));
        this.nextPageButton = new JButton("Next");
        this.nextPageButton.addActionListener(actionEvent -> this.goToPage(this.currentPage + 1));
        this.goToPageButton = new JButton("Go");
        this.goToPageButton.addActionListener(actionEvent -> this.showGoToPageDialog());
        this.pageInfoLabel = new JLabel("Page 1");
        this.pageSizeComboBox = new JComboBox<Integer>(new Integer[]{10, 25, 50, 100, 200, 500, 1000});
        this.pageSizeComboBox.setSelectedItem(this.pageSize);
        this.pageSizeComboBox.addActionListener(actionEvent -> {
            int n = (Integer)this.pageSizeComboBox.getSelectedItem();
            if (n != this.pageSize) {
                this.currentPage = 1;
                this.pageSize = n;
                this.loadPage(this.currentPage);
            }
        });
    }

    private void initLayout() {
        this.setLayout(new CardLayout());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 8, wrap, fill"));
        this.contentPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fillx, wrap"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("insets 0", "[60!][120!]10[100!]", ""));
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        JLabel jLabel = new JLabel("Start Time:");
        jLabel.setHorizontalAlignment(4);
        jPanel2.add((Component)jLabel, "gapright 5");
        jPanel2.add((Component)this.startDatePicker, "w 120!, gapright 10");
        jPanel2.add((Component)this.startTimePicker, "w 100!, wrap");
        JLabel jLabel2 = new JLabel("End Time:");
        jLabel2.setHorizontalAlignment(4);
        jPanel2.add((Component)jLabel2, "gapright 5");
        jPanel2.add((Component)this.endDatePicker, "w 120!, gapright 10");
        jPanel2.add((Component)this.endTimePicker, "w 100!");
        jPanel.add((Component)jPanel2, "growx, wrap");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("insets 0", "[60!][230!]20[][80!]20[][80!]", ""));
        jPanel3.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel3.add((Component)new JLabel("Key:"), "align left, gapright 5");
        jPanel3.add((Component)this.keyFilterField, "w 230!");
        jPanel3.add((Component)new JLabel("Action:"), "align left");
        jPanel3.add(this.actionFilterComboBox);
        jPanel3.add((Component)new JLabel("User:"), "align left");
        jPanel3.add(this.userFilterComboBox);
        jPanel.add((Component)jPanel3, "growx, wrap");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("insets 0", "[60!][]10[]", ""));
        jPanel4.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel4.add((Component)new JLabel("Search:"), "align left, gapright 5");
        jPanel4.add(this.searchButton);
        jPanel4.add(this.clearButton);
        jPanel.add((Component)jPanel4, "growx, wrap");
        this.contentPanel.add((Component)jPanel, "growx, wrap");
        this.contentPanel.add((Component)new JScrollPane(this.auditTable), "grow, push, wrap");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel6.add(new JLabel("Page size:"));
        jPanel6.add(this.pageSizeComboBox);
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel7.add(this.prevPageButton);
        jPanel7.add(this.pageInfoLabel);
        jPanel7.add(this.nextPageButton);
        jPanel7.add(this.goToPageButton);
        jPanel5.add((Component)jPanel6, "West");
        jPanel5.add((Component)jPanel7, "East");
        this.contentPanel.add((Component)jPanel5, "growx, wrap");
        this.add((Component)this.contentPanel, "content");
        this.add((Component)this.noGroupSelectedPanel, "noGroup");
    }

    public void updateHistory(LookupGroup lookupGroup) {
        boolean bl = lookupGroup != null;
        this.contentPanel.setVisible(bl);
        this.noGroupSelectedPanel.setVisible(!bl);
        if (!Objects.equals(this.selectedGroup, lookupGroup)) {
            this.clearFilterFields();
        }
        this.selectedGroup = lookupGroup;
        this.currentPage = 1;
        this.loadPage(this.currentPage);
    }

    private void loadPage(final int n) {
        this.auditTableModel.clear();
        if (this.selectedGroup == null) {
            return;
        }
        final int n2 = (n - 1) * this.pageSize;
        new SwingWorker<GroupAuditEntriesResponse, Void>(){

            @Override
            protected GroupAuditEntriesResponse doInBackground() throws Exception {
                HistoryFilterState historyFilterState = HistoryPanel.this.buildHistoryFilterStateFromUI();
                return LookupServiceClient.getInstance().searchAuditEntries(HistoryPanel.this.selectedGroup.getId(), n2, HistoryPanel.this.pageSize, historyFilterState);
            }

            @Override
            protected void done() {
                try {
                    GroupAuditEntriesResponse groupAuditEntriesResponse = (GroupAuditEntriesResponse)this.get();
                    List list = groupAuditEntriesResponse.getEntries();
                    HistoryPanel.this.totalCount = groupAuditEntriesResponse.getTotalEntries();
                    HistoryPanel.this.auditTableModel.setValues(list);
                    HistoryPanel.this.currentPage = n;
                    HistoryPanel.this.updatePaginationControls();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof LookupApiClientException) {
                        HistoryPanel.this.showError("Failed to load audit entries: " + throwable.getMessage());
                    } else {
                        HistoryPanel.this.logger.error("Unexpected error while loading audit entries", (Throwable)executionException);
                        HistoryPanel.this.showError("An unexpected error occurred: " + throwable.getMessage());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    HistoryPanel.this.showError("Operation was interrupted.");
                }
            }
        }.execute();
    }

    private void updatePaginationControls() {
        int n = (int)Math.ceil((double)this.totalCount / (double)this.pageSize);
        this.pageInfoLabel.setText("Page " + this.currentPage + " of " + n);
        this.prevPageButton.setEnabled(this.currentPage > 1);
        this.nextPageButton.setEnabled(this.currentPage < n);
    }

    private void goToPage(int n) {
        if (n >= 1 && (n - 1) * this.pageSize < this.totalCount) {
            this.loadPage(n);
        }
    }

    private void showGoToPageDialog() {
        Integer n;
        int n2;
        if (this.totalCount == 0) {
            return;
        }
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        int n3 = (int)Math.ceil((double)this.totalCount / (double)this.pageSize);
        for (n2 = 1; n2 <= n3; ++n2) {
            jComboBox.addItem(n2);
        }
        n2 = JOptionPane.showConfirmDialog(this, jComboBox, "Select Page", 2);
        if (n2 == 0 && (n = (Integer)jComboBox.getSelectedItem()) != null) {
            this.loadPage(n);
        }
    }

    public void updateCachedUserMap() {
        try {
            this.parent.retrieveUsers();
        }
        catch (ClientException clientException) {
            this.parent.alertThrowable((Component)this, (Throwable)clientException);
            return;
        }
        this.userMapById.clear();
        this.userMapById.put(-1, "ALL");
        this.userMapById.put(0, "System");
        for (User object : this.parent.users) {
            this.userMapById.put(object.getId(), object.getUsername());
        }
        this.userFilterComboBox.removeAllItems();
        for (String string : this.userMapById.values()) {
            this.userFilterComboBox.addItem(string);
        }
        this.userFilterComboBox.setSelectedIndex(0);
    }

    private String getSelectedUserId() {
        String string = (String)this.userFilterComboBox.getSelectedItem();
        if (string == null || string.equals("ALL")) {
            return null;
        }
        for (Map.Entry<Integer, String> entry : this.userMapById.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return String.valueOf(entry.getKey());
        }
        return null;
    }

    private void clearFilterFields() {
        this.keyFilterField.setText("");
        this.actionFilterComboBox.setSelectedIndex(0);
        this.userFilterComboBox.setSelectedIndex(0);
        this.startDatePicker.setDate(null);
        this.endDatePicker.setDate(null);
    }

    private HistoryFilterState buildHistoryFilterStateFromUI() {
        String string = this.normalizeField(this.keyFilterField.getText());
        String string2 = this.normalizeComboBoxValue((String)this.actionFilterComboBox.getSelectedItem());
        String string3 = this.getSelectedUserId();
        Date date = this.getCombinedDateTime(this.startDatePicker, this.startTimePicker);
        Date date2 = this.getCombinedDateTime(this.endDatePicker, this.endTimePicker);
        HistoryFilterState historyFilterState = new HistoryFilterState();
        historyFilterState.setKeyValue(string);
        historyFilterState.setAction(string2);
        historyFilterState.setUserId(string3);
        historyFilterState.setStartDate(date);
        historyFilterState.setEndDate(date2);
        return historyFilterState;
    }

    private String normalizeField(String string) {
        return string == null || string.trim().isEmpty() ? null : string.trim();
    }

    private String normalizeComboBoxValue(String string) {
        return string == null || "ALL".equals(string.trim()) ? null : string.trim();
    }

    private Date getCombinedDateTime(MirthDatePicker mirthDatePicker, MirthTimePicker mirthTimePicker) {
        try {
            Date date = mirthDatePicker.getDate();
            String string = mirthTimePicker.getDate();
            if (date != null && string != null) {
                DateFormatter dateFormatter = new DateFormatter(new SimpleDateFormat("hh:mm aa"));
                Date date2 = (Date)dateFormatter.stringToValue(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.setTime(date);
                if (mirthTimePicker.isEnabled()) {
                    calendar3.set(11, calendar2.get(11));
                    calendar3.set(12, calendar2.get(12));
                    calendar3.set(13, calendar2.get(13));
                    calendar3.set(14, 0);
                } else {
                    calendar3.set(11, 0);
                    calendar3.set(12, 0);
                    calendar3.set(13, 0);
                    calendar3.set(14, 0);
                }
                return calendar3.getTime();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)this.parent, string);
    }
}

