/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.plugin;

import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.plugins.CodeTemplatePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupTableReferencePlugin
extends CodeTemplatePlugin {
    private static final Logger logger = LogManager.getLogger(LookupTableReferencePlugin.class);

    public LookupTableReferencePlugin(String string) {
        super(string);
    }

    public Map<String, List<CodeTemplate>> getReferenceItems() {
        HashMap<String, List<CodeTemplate>> hashMap = new HashMap<String, List<CodeTemplate>>();
        ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>();
        arrayList.add(new CodeTemplate("Lookup Value by Key", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var value = LookupHelper.get(group, key);", "Retrieves a value from the specified lookup group using the given key. Returns null if no match is found."));
        arrayList.add(new CodeTemplate("Lookup Value by Key with TTL", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var value = LookupHelper.get(group, key, /*ttlHours*/ 0, /*ttlMinutes*/ 30);", "Retrieves a value from the specified lookup group using the given key and a TTL expressed in hours and minutes. If both values are 0, TTL is ignored. If the cached or database value is older than the TTL, null is returned."));
        arrayList.add(new CodeTemplate("Lookup Value with Default Fallback", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var value = LookupHelper.get(group, key, defaultValue);", "Retrieves a value from a lookup group, or returns the default if the group or key is missing."));
        arrayList.add(new CodeTemplate("Lookup Value with TTL and Default Fallback", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var value = LookupHelper.get(group, key, /*ttlHours*/ 0, /*ttlMinutes*/ 30, /*defaultValue*/ 'N/A');", "Retrieves a value from the specified lookup group using the given key and a TTL expressed in hours and minutes. If both hours and minutes are 0, TTL is ignored. If the value is missing or stale, the provided default value is returned instead."));
        arrayList.add(new CodeTemplate("Lookup Values Matching Pattern", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var values = LookupHelper.getMatching(group, keyPattern);", "Retrieves key-value pairs from the specified lookup group where keys match a pattern. Returns an empty map if the group does not exist or no matches are found."));
        arrayList.add(new CodeTemplate("Batch Lookup by Keys", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var keys = [\"key1\", \"key2\", \"key3\"];\nvar values = LookupHelper.getBatch(group, keys);", "Retrieves multiple key-value pairs from the specified lookup group in a single operation. Returns an empty map if the group is not found or none of the keys exist."));
        arrayList.add(new CodeTemplate("Batch Lookup by Keys with TTL", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var keys = [\"key1\", \"key2\", \"key3\"];\nvar batch = LookupHelper.getBatch(group, keys, /*ttlHours*/ 0, /*ttlMinutes*/ 30);", "Retrieves multiple key-value pairs from the specified lookup group using a TTL expressed in hours and minutes. If both hours and minutes are 0, TTL is ignored. Only values updated within the TTL window are returned. Returns an empty map if the group is not found, or if all values are stale or missing."));
        arrayList.add(new CodeTemplate("Lookup Key Existence in Group", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var found = LookupHelper.exists(group, key);", "Checks whether the specified key exists in the given lookup group. Returns true if found; false if the group or key does not exist, or if an error occurs."));
        arrayList.add(new CodeTemplate("Get Lookup Cache Statistics", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var stats = LookupHelper.getCacheStats(group);", "Retrieves cache and usage statistics for the specified lookup group, including hit/miss counts, hit rate, evictions, total lookups, and last accessed time. Returns an empty map if the group is not found or an error occurs."));
        arrayList.add(new CodeTemplate("Set Lookup Value by Key", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.set(group, key, value);", "Sets a value in the specified lookup group using the given key. Returns true if successful, false otherwise."));
        arrayList.add(new CodeTemplate("Deletes a lookup value by group name and key", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.deleteValue(group, key);", "Deletes a value in the specified lookup group by key. Returns true if successful, false otherwise."));
        arrayList.add(new CodeTemplate("Deletes all lookup values in the specified group", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.deleteAllValues(group);", "Deletes all values in the given lookup group. Returns true if successful, false otherwise."));
        arrayList.add(new CodeTemplate("Imports multiple values into a lookup group", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var payload = {\n  \"key1\": \"value1\",\n  \"key2\": \"value2\"\n};\nvar res = LookupHelper.importValues(group, payload, true);\nif (!res || String(res.ok) !== 'true') {\n  logger.error('Import values failed for group: ' + group + (res ? (' - ' + res.errorMessage) : ''));\n} else {\n  logger.info('Imported ' + res.importedCount + ' entries into groupId=' + res.groupId);\n}", "Imports key-value pairs into the specified lookup group. If clearExisting is true, all existing values are removed before import. Returns { ok: 'true', groupId, importedCount } on success; otherwise { ok: 'false', errorCode, errorMessage }."));
        arrayList.add(new CodeTemplate("Put Lookup Value If Absent", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.putIfAbsent(group, key, value);\nif (!success) {\n  logger.warn('Key already exists or insert failed in group: ' + group);\n}", "Inserts a value into the specified lookup group only if the key does not already exist. Returns true if the value was inserted, false otherwise."));
        arrayList.add(new CodeTemplate("Compare and Swap Lookup Value", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.compareAndSwap(group, key, expectedValue, newValue);\nif (!success) {\n  logger.warn('Compare-and-swap failed for group: ' + group + ', key: ' + key + ', expectedValue: ' + expectedValue + ', newValue: ' + newValue);\n}", "Atomically updates a lookup value only if its current value matches the expected value. Returns true if the value was successfully updated; false if the key does not exist, the value does not match, or an error occurred."));
        arrayList.add(new CodeTemplate("Update Lookup Value by Delta", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.updateValueByDelta(group, key, delta);\nif (!success) {\n  logger.warn('Failed to update lookup value by delta for group: ' + group + ', key: ' + key + ', delta: ' + delta);\n}", "Atomically increments or decrements the numeric value of a lookup key by the specified delta. Returns true if the value was successfully updated; false if the group or key was not found, or if an error occurred."));
        arrayList.add(new CodeTemplate("Creates a lookup group", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var payload = {\n  name: 'MyGroup',\n  description: 'optional',\n  version: '1.0.0',\n  cacheSize: '1000',\n  cachePolicy: 'LRU' // or 'FIFO'\n};\nvar res = LookupHelper.createGroup(payload);\nif (!res || String(res.ok) !== 'true') {\n  logger.error('Create group failed: ' + (res ? (res.errorCode + ' - ' + res.errorMessage) : 'unknown'));\n} else {\n  logger.info('Created group id=' + res.group.id + ', name=' + res.group.name);\n}\n", "Creates a lookup group with fields: name, description, version, cacheSize, cachePolicy. Returns { ok: 'true', group: {...} } on success; otherwise { ok: 'false', errorCode, errorMessage }."));
        arrayList.add(new CodeTemplate("Deletes a lookup group", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "var success = LookupHelper.deleteGroup(group);\n", "Deletes the specified lookup group by name. Returns true if successful, false otherwise."));
        hashMap.put("Lookup Table Functions", arrayList);
        return hashMap;
    }

    public String getPluginPointName() {
        return "Lookup Table Reference Plugin";
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }
}

