/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.ServiceRegistry;
import org.dcm4che2.net.service.CEchoSCP;
import org.dcm4che2.net.service.CFindSCP;
import org.dcm4che2.net.service.CGetSCP;
import org.dcm4che2.net.service.CMoveSCP;
import org.dcm4che2.net.service.CStoreSCP;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.NActionSCP;
import org.dcm4che2.net.service.NCreateSCP;
import org.dcm4che2.net.service.NDeleteSCP;
import org.dcm4che2.net.service.NEventReportSCU;
import org.dcm4che2.net.service.NGetSCP;
import org.dcm4che2.net.service.NSetSCP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomServiceRegistry
implements ServiceRegistry {
    static Logger log = LoggerFactory.getLogger(DicomServiceRegistry.class);
    private final HashSet<String> sopCUIDs = new HashSet();
    private final HashMap<String, DicomService> cstoreSCP = new HashMap();
    private final HashMap<String, DicomService> cgetSCP = new HashMap();
    private final HashMap<String, DicomService> cmoveSCP = new HashMap();
    private final HashMap<String, DicomService> cfindSCP = new HashMap();
    private final HashMap<String, DicomService> cechoSCP = new HashMap(1);
    private final HashMap<String, DicomService> neventReportSCU = new HashMap();
    private final HashMap<String, DicomService> ngetSCP = new HashMap();
    private final HashMap<String, DicomService> nsetSCP = new HashMap();
    private final HashMap<String, DicomService> nactionSCP = new HashMap();
    private final HashMap<String, DicomService> ncreateSCP = new HashMap();
    private final HashMap<String, DicomService> ndeleteSCP = new HashMap();

    private void registerInto(HashMap<String, DicomService> registry, DicomService service) {
        String[] sopClasses = service.getSopClasses();
        for (int i = 0; i < sopClasses.length; ++i) {
            registry.put(sopClasses[i], service);
            this.sopCUIDs.add(sopClasses[i]);
        }
        String serviceClass = service.getServiceClass();
        if (serviceClass != null) {
            registry.put(serviceClass, service);
            this.sopCUIDs.add(serviceClass);
        }
    }

    private void unregisterFrom(HashMap<String, DicomService> registry, DicomService service) {
        Iterator<Map.Entry<String, DicomService>> iter = registry.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, DicomService> element = iter.next();
            if (element.getValue() != service) continue;
            iter.remove();
        }
    }

    @Override
    public void register(DicomService service) {
        if (service instanceof CStoreSCP) {
            this.registerInto(this.cstoreSCP, service);
        }
        if (service instanceof CGetSCP) {
            this.registerInto(this.cgetSCP, service);
        }
        if (service instanceof CMoveSCP) {
            this.registerInto(this.cmoveSCP, service);
        }
        if (service instanceof CFindSCP) {
            this.registerInto(this.cfindSCP, service);
        }
        if (service instanceof CEchoSCP) {
            this.registerInto(this.cechoSCP, service);
        }
        if (service instanceof NEventReportSCU) {
            this.registerInto(this.neventReportSCU, service);
        }
        if (service instanceof NGetSCP) {
            this.registerInto(this.ngetSCP, service);
        }
        if (service instanceof NSetSCP) {
            this.registerInto(this.nsetSCP, service);
        }
        if (service instanceof NActionSCP) {
            this.registerInto(this.nactionSCP, service);
        }
        if (service instanceof NCreateSCP) {
            this.registerInto(this.ncreateSCP, service);
        }
        if (service instanceof NDeleteSCP) {
            this.registerInto(this.ndeleteSCP, service);
        }
    }

    @Override
    public void unregister(DicomService service) {
        if (service instanceof CStoreSCP) {
            this.unregisterFrom(this.cstoreSCP, service);
        }
        if (service instanceof CGetSCP) {
            this.unregisterFrom(this.cgetSCP, service);
        }
        if (service instanceof CMoveSCP) {
            this.unregisterFrom(this.cmoveSCP, service);
        }
        if (service instanceof CFindSCP) {
            this.unregisterFrom(this.cfindSCP, service);
        }
        if (service instanceof CEchoSCP) {
            this.unregisterFrom(this.cechoSCP, service);
        }
        if (service instanceof NEventReportSCU) {
            this.unregisterFrom(this.neventReportSCU, service);
        }
        if (service instanceof NGetSCP) {
            this.unregisterFrom(this.ngetSCP, service);
        }
        if (service instanceof NSetSCP) {
            this.unregisterFrom(this.nsetSCP, service);
        }
        if (service instanceof NActionSCP) {
            this.unregisterFrom(this.nactionSCP, service);
        }
        if (service instanceof NCreateSCP) {
            this.unregisterFrom(this.ncreateSCP, service);
        }
        if (service instanceof NDeleteSCP) {
            this.unregisterFrom(this.ndeleteSCP, service);
        }
    }

    private Object getFrom(HashMap<String, DicomService> registry, DicomObject cmd, int tag) throws DicomServiceException {
        String cuid = cmd.getString(tag);
        DicomService scp = registry.get(cuid);
        if (scp == null) {
            throw new DicomServiceException(cmd, this.sopCUIDs.contains(cuid) ? 529 : 280);
        }
        return scp;
    }

    private CStoreSCP getCStoreSCP(DicomObject cmd) throws DicomServiceException {
        return (CStoreSCP)this.getFrom(this.cstoreSCP, cmd, 2);
    }

    private CGetSCP getCGetSCP(DicomObject cmd) throws DicomServiceException {
        return (CGetSCP)this.getFrom(this.cgetSCP, cmd, 2);
    }

    private CFindSCP getCFindSCP(DicomObject cmd) throws DicomServiceException {
        return (CFindSCP)this.getFrom(this.cfindSCP, cmd, 2);
    }

    private CMoveSCP getCMoveSCP(DicomObject cmd) throws DicomServiceException {
        return (CMoveSCP)this.getFrom(this.cmoveSCP, cmd, 2);
    }

    private CEchoSCP getCEchoSCP(DicomObject cmd) throws DicomServiceException {
        return (CEchoSCP)this.getFrom(this.cechoSCP, cmd, 2);
    }

    private NEventReportSCU getNEventReportSCU(DicomObject cmd) throws DicomServiceException {
        return (NEventReportSCU)this.getFrom(this.neventReportSCU, cmd, 2);
    }

    private NGetSCP getNGetSCP(DicomObject cmd) throws DicomServiceException {
        return (NGetSCP)this.getFrom(this.ngetSCP, cmd, 3);
    }

    private NSetSCP getNSetSCP(DicomObject cmd) throws DicomServiceException {
        return (NSetSCP)this.getFrom(this.nsetSCP, cmd, 3);
    }

    private NActionSCP getNActionSCP(DicomObject cmd) throws DicomServiceException {
        return (NActionSCP)this.getFrom(this.nactionSCP, cmd, 3);
    }

    private NCreateSCP getNCreateSCP(DicomObject cmd) throws DicomServiceException {
        return (NCreateSCP)this.getFrom(this.ncreateSCP, cmd, 2);
    }

    private NDeleteSCP getNDeleteSCP(DicomObject cmd) throws DicomServiceException {
        return (NDeleteSCP)this.getFrom(this.ndeleteSCP, cmd, 3);
    }

    @Override
    public void process(Association as, int pcid, DicomObject cmd, PDVInputStream dataStream, String tsuid) throws IOException {
        try {
            int cmdfield = cmd.getInt(256);
            if (cmdfield == 1) {
                this.getCStoreSCP(cmd).cstore(as, pcid, cmd, dataStream, tsuid);
            } else {
                DicomObject dataset = null;
                if (dataStream != null) {
                    dataset = dataStream.readDataset();
                    if (log.isDebugEnabled()) {
                        log.debug("Dataset:\n" + dataset);
                    }
                }
                switch (cmdfield) {
                    case 16: {
                        this.getCGetSCP(cmd).cget(as, pcid, cmd, dataset);
                        break;
                    }
                    case 32: {
                        this.getCFindSCP(cmd).cfind(as, pcid, cmd, dataset);
                        break;
                    }
                    case 33: {
                        this.getCMoveSCP(cmd).cmove(as, pcid, cmd, dataset);
                        break;
                    }
                    case 48: {
                        this.getCEchoSCP(cmd).cecho(as, pcid, cmd);
                        break;
                    }
                    case 256: {
                        this.getNEventReportSCU(cmd).neventReport(as, pcid, cmd, dataset);
                        break;
                    }
                    case 272: {
                        this.getNGetSCP(cmd).nget(as, pcid, cmd, dataset);
                        break;
                    }
                    case 288: {
                        this.getNSetSCP(cmd).nset(as, pcid, cmd, dataset);
                        break;
                    }
                    case 304: {
                        this.getNActionSCP(cmd).naction(as, pcid, cmd, dataset);
                        break;
                    }
                    case 320: {
                        this.getNCreateSCP(cmd).ncreate(as, pcid, cmd, (DicomObject)(dataStream != null ? dataset : null));
                        break;
                    }
                    case 336: {
                        this.getNDeleteSCP(cmd).ndelete(as, pcid, cmd, dataset);
                        break;
                    }
                    case 4095: {
                        as.onCancelRQ(cmd);
                        break;
                    }
                    default: {
                        throw new DicomServiceException(cmd, 529);
                    }
                }
            }
        }
        catch (DicomServiceException e) {
            as.writeDimseRSP(pcid, e.getCommand(), e.getDataset());
        }
    }
}

