/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelProperties;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.plugins.datapruner.DataPrunerException;
import com.mirth.connect.plugins.datapruner.DataPrunerInterface;
import com.mirth.connect.plugins.datapruner.DataPrunerStatus;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.ListRangeIterator;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.util.messagewriter.AttachmentSource;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterFactory;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataPruner
implements Runnable {
    public static final int DEFAULT_PRUNING_BLOCK_SIZE = 1000;
    public static final int DEFAULT_ARCHIVING_BLOCK_SIZE = 50;
    private static final int ID_RETRIEVE_LIMIT = 100000;
    private int numExported;
    private int retryCount = 3;
    private boolean skipIncomplete = true;
    private Status[] skipStatuses;
    private int prunerBlockSize = 1000;
    private boolean archiveEnabled;
    private int archiverBlockSize = 50;
    private MessageWriterOptions archiverOptions;
    private boolean pruneEvents;
    private Integer maxEventAge;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private String serverId = ControllerFactory.getFactory().createConfigurationController().getServerId();
    private DonkeyDaoFactory readOnlyDaoFactory;
    private AtomicBoolean running = new AtomicBoolean(false);
    private Thread pruneThread;
    private DataPrunerStatus status = new DataPrunerStatus();
    private DataPrunerStatus lastStatus;
    private Logger logger = LogManager.getLogger(this.getClass());
    private PollConnectorProperties pollingProperties;
    private DataPrunerInterface dataPrunerInterface;

    public DataPruner() {
        this.skipStatuses = new Status[]{Status.ERROR, Status.QUEUED, Status.PENDING};
        this.pollingProperties = new PollConnectorProperties();
    }

    public int getNumExported() {
        return this.numExported;
    }

    public void setNumExported(int numExported) {
        this.numExported = numExported;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isSkipIncomplete() {
        return this.skipIncomplete;
    }

    public void setSkipIncomplete(boolean skipIncomplete) {
        this.skipIncomplete = skipIncomplete;
    }

    public Status[] getSkipStatuses() {
        return this.skipStatuses;
    }

    public void setSkipStatuses(Status[] skipStatuses) {
        this.skipStatuses = skipStatuses;
    }

    public int getPrunerBlockSize() {
        return this.prunerBlockSize;
    }

    public void setPrunerBlockSize(int prunerBlockSize) {
        this.prunerBlockSize = prunerBlockSize;
    }

    public boolean isArchiveEnabled() {
        return this.archiveEnabled;
    }

    public void setArchiveEnabled(boolean archiveEnabled) {
        this.archiveEnabled = archiveEnabled;
    }

    public int getArchiverBlockSize() {
        return this.archiverBlockSize;
    }

    public void setArchiverBlockSize(int archiverBlockSize) {
        this.archiverBlockSize = archiverBlockSize;
    }

    public MessageWriterOptions getArchiverOptions() {
        return this.archiverOptions;
    }

    public void setArchiverOptions(MessageWriterOptions archiverOptions) {
        this.archiverOptions = archiverOptions;
    }

    public boolean isPruneEvents() {
        return this.pruneEvents;
    }

    public void setPruneEvents(boolean pruneEvents) {
        this.pruneEvents = pruneEvents;
    }

    public Integer getMaxEventAge() {
        return this.maxEventAge;
    }

    public void setMaxEventAge(Integer maxEventAge) {
        this.maxEventAge = maxEventAge;
    }

    public PollConnectorProperties getPollingProperties() {
        return this.pollingProperties;
    }

    public void setPollingProperties(PollConnectorProperties pollingProperties) {
        this.pollingProperties = pollingProperties;
    }

    public DataPrunerStatus getPrunerStatus() {
        return this.status;
    }

    public DataPrunerStatus getLastPrunerStatus() {
        return this.lastStatus;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void registerDataPrunerInterface(DataPrunerInterface dataPrunerInterface) {
        this.dataPrunerInterface = dataPrunerInterface;
    }

    public synchronized boolean start() {
        if (!this.running.compareAndSet(false, true)) {
            this.logger.warn("The data pruner is already running");
            return false;
        }
        this.status = new DataPrunerStatus();
        this.status.setStartTime(Calendar.getInstance());
        this.logger.debug("Triggering data pruner task");
        this.pruneThread = new Thread((Runnable)this, "Data Pruner Thread");
        this.pruneThread.start();
        return true;
    }

    public synchronized void stop() throws InterruptedException {
        if (this.running.get()) {
            this.logger.debug("Halting Data Pruner");
            if (this.pruneThread != null) {
                this.pruneThread.interrupt();
                this.logger.debug("Waiting for Data Pruner to terminate");
                this.pruneThread.join();
            }
            this.logger.debug("Data Pruner halted successfully");
        }
    }

    private DonkeyDaoFactory getReadOnlyDaoFactory() {
        if (this.readOnlyDaoFactory == null) {
            this.readOnlyDaoFactory = Donkey.getInstance().getReadOnlyDaoFactory();
        }
        return this.readOnlyDaoFactory;
    }

    private Queue<PrunerTask> buildTaskQueue() throws Exception {
        List channels = ChannelController.getInstance().getChannels(null);
        Map metadataMap = this.configurationController.getChannelMetadata();
        LinkedList<PrunerTask> queue = new LinkedList<PrunerTask>();
        block5: for (Channel channel : channels) {
            if (channel instanceof InvalidChannel) continue;
            ChannelProperties properties = channel.getProperties();
            ChannelMetadata metadata = (ChannelMetadata)metadataMap.get(channel.getId());
            if (metadata == null) {
                metadata = new ChannelMetadata();
            }
            Integer pruneMetaDataDays = metadata.getPruningSettings().getPruneMetaDataDays();
            Integer pruneContentDays = metadata.getPruningSettings().getPruneContentDays();
            Calendar contentDateThreshold = null;
            Calendar messageDateThreshold = null;
            switch (properties.getMessageStorageMode()) {
                case DEVELOPMENT: 
                case PRODUCTION: 
                case RAW: {
                    if (pruneContentDays != null) {
                        contentDateThreshold = Calendar.getInstance();
                        contentDateThreshold.set(5, contentDateThreshold.get(5) - pruneContentDays);
                    }
                }
                case METADATA: {
                    if (pruneMetaDataDays != null) {
                        messageDateThreshold = Calendar.getInstance();
                        messageDateThreshold.set(5, messageDateThreshold.get(5) - pruneMetaDataDays);
                    }
                    if (messageDateThreshold == null && contentDateThreshold == null) continue block5;
                    queue.add(new PrunerTask(channel.getId(), channel.getName(), messageDateThreshold, contentDateThreshold, metadata.getPruningSettings().isArchiveEnabled(), metadata.getPruningSettings().isPruneErroredMessages()));
                    this.status.getPendingChannelIds().add(channel.getId());
                    continue block5;
                }
                case DISABLED: {
                    continue block5;
                }
            }
            String errorMessage = "Unrecognized message storage mode: " + properties.getMessageStorageMode().toString();
            this.logger.error(errorMessage);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("Channel", channel.getName());
            attributes.put("Error", errorMessage);
            this.eventController.dispatchEvent((Event)new ServerEvent(this.serverId, "Data Pruner", ServerEvent.Level.ERROR, ServerEvent.Outcome.FAILURE, attributes));
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            HashMap<String, String> attributes;
            Queue<PrunerTask> taskQueue;
            this.logger.debug("Executing pruner, started at " + new SimpleDateFormat("MM/dd/yyyy hh:mm aa").format(Calendar.getInstance().getTime()));
            if (this.pruneEvents) {
                this.pruneEvents();
            }
            String date = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
            String archiveFolder = this.archiveEnabled ? this.archiverOptions.getRootFolder() + IOUtils.DIR_SEPARATOR + date : null;
            try {
                taskQueue = this.buildTaskQueue();
            }
            catch (Exception e) {
                this.status.setEndTime(Calendar.getInstance());
                this.lastStatus = (DataPrunerStatus)SerializationUtils.clone((Serializable)this.status);
                this.running.set(false);
                return;
            }
            this.logger.debug("Pruner task queue built, " + taskQueue.size() + " channels will be processed");
            if (taskQueue.isEmpty()) {
                attributes = new HashMap<String, String>();
                attributes.put("No messages to prune.", "");
                this.eventController.dispatchEvent((Event)new ServerEvent(this.serverId, "Data Pruner", ServerEvent.Level.INFORMATION, ServerEvent.Outcome.SUCCESS, attributes));
            }
            while (!taskQueue.isEmpty()) {
                attributes = new HashMap();
                ThreadUtils.checkInterruptedStatus();
                PrunerTask task = taskQueue.poll();
                try {
                    this.status.setCurrentChannelId(task.getChannelId());
                    this.status.setCurrentChannelName(task.getChannelName());
                    this.status.setTaskStartTime(Calendar.getInstance());
                    PruneResult result = this.pruneChannel(task.getChannelId(), task.getChannelName(), task.getMessageDateThreshold(), task.getContentDateThreshold(), archiveFolder, task.isArchiveEnabled(), task.isPruneErroredMessages());
                    this.status.getProcessedChannelIds().add(task.getChannelId());
                    attributes.put("Channel ID", task.getChannelId());
                    attributes.put("Channel Name", task.getChannelName());
                    if (this.archiveEnabled && task.isArchiveEnabled()) {
                        attributes.put("Messages Archived", Long.toString(result.numMessagesArchived));
                    }
                    attributes.put("Messages Pruned", Long.toString(result.numMessagesPruned));
                    attributes.put("Content Rows Pruned", Long.toString(result.numContentPruned));
                    attributes.put("Time Elapsed", this.getTimeElapsed());
                    if (task.getMessageDateThreshold() != null) {
                        attributes.put("Message Date Threshold", String.valueOf(task.getMessageDateThreshold().getTime()));
                    }
                    if (task.getContentDateThreshold() != null) {
                        attributes.put("Content Date Threshold", String.valueOf(task.getContentDateThreshold().getTime()));
                    }
                    this.eventController.dispatchEvent((Event)new ServerEvent(this.serverId, "Data Pruner", ServerEvent.Level.INFORMATION, ServerEvent.Outcome.SUCCESS, attributes));
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.status.getFailedChannelIds().add(task.getChannelId());
                    attributes.put("channel", task.getChannelName());
                    attributes.put("error", e.getMessage());
                    attributes.put("trace", ExceptionUtils.getStackTrace((Throwable)e));
                    this.eventController.dispatchEvent((Event)new ServerEvent(this.serverId, "Data Pruner", ServerEvent.Level.ERROR, ServerEvent.Outcome.FAILURE, attributes));
                    Throwable t = e;
                    if (e instanceof DataPrunerException) {
                        t = e.getCause();
                    }
                    this.logger.error("Failed to prune messages for channel " + task.getChannelName() + " (" + task.getChannelId() + ").", t);
                }
                finally {
                    this.status.getPendingChannelIds().remove(task.getChannelId());
                    this.status.setCurrentChannelId(null);
                    this.status.setCurrentChannelName(null);
                }
            }
            this.logger.debug("Pruner job finished executing");
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            ServerEvent event = new ServerEvent(this.serverId, "Data Pruner Halted");
            event.setLevel(ServerEvent.Level.INFORMATION);
            event.setOutcome(ServerEvent.Outcome.SUCCESS);
            this.eventController.dispatchEvent((Event)event);
            this.logger.debug("Data Pruner halted");
        }
        catch (Throwable t) {
            this.logger.error("An error occurred while executing the data pruner", t);
        }
        finally {
            this.status.setEndTime(Calendar.getInstance());
            this.lastStatus = (DataPrunerStatus)SerializationUtils.clone((Serializable)this.status);
            this.running.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneEvents() {
        this.logger.debug("Pruning events");
        this.status.setPruningEvents(true);
        try {
            this.status.setTaskStartTime(Calendar.getInstance());
            Calendar dateThreshold = Calendar.getInstance();
            dateThreshold.set(5, dateThreshold.get(5) - this.maxEventAge);
            if (this.dataPrunerInterface != null) {
                this.dataPrunerInterface.beforeDataPruner();
            }
            try (SqlSession session = SqlConfig.getInstance().getSqlSessionManager().openSession(true);){
                HashMap<String, Calendar> params = new HashMap<String, Calendar>();
                params.put("dateThreshold", dateThreshold);
                int numEventsPruned = session.delete("Message.pruneEvents", params);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("Events Pruned", Integer.toString(numEventsPruned));
                attributes.put("Time Elapsed", this.getTimeElapsed());
                this.eventController.dispatchEvent((Event)new ServerEvent(this.serverId, "Data Pruner", ServerEvent.Level.INFORMATION, ServerEvent.Outcome.SUCCESS, attributes));
            }
        }
        finally {
            this.status.setEndTime(Calendar.getInstance());
            this.status.setPruningEvents(false);
            if (this.dataPrunerInterface != null) {
                this.dataPrunerInterface.afterDataPruner();
            }
        }
    }

    public PruneResult pruneChannel(String channelId, String channelName, Calendar messageDateThreshold, Calendar contentDateThreshold, String archiveFolder, boolean channelArchiveEnabled) throws InterruptedException, DataPrunerException {
        return this.pruneChannel(channelId, channelName, messageDateThreshold, contentDateThreshold, archiveFolder, channelArchiveEnabled, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PruneResult pruneChannel(String channelId, String channelName, Calendar messageDateThreshold, Calendar contentDateThreshold, String archiveFolder, boolean channelArchiveEnabled, boolean pruneErroredMessages) throws InterruptedException, DataPrunerException {
        this.logger.debug("Executing pruner for channel: " + channelId);
        if (messageDateThreshold == null && contentDateThreshold == null) {
            return new PruneResult();
        }
        if (messageDateThreshold != null && contentDateThreshold != null && contentDateThreshold.getTimeInMillis() <= messageDateThreshold.getTimeInMillis()) {
            contentDateThreshold = null;
        }
        int retries = this.retryCount;
        long localChannelId = com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getLocalChannelId(channelId);
        while (true) {
            ThreadUtils.checkInterruptedStatus();
            try {
                long maxMessageId;
                try (DonkeyDao dao = this.getReadOnlyDaoFactory().getDao();){
                    maxMessageId = dao.getMaxMessageId(channelId);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("localChannelId", localChannelId);
                params.put("maxMessageId", maxMessageId);
                params.put("skipIncomplete", this.isSkipIncomplete());
                params.put("dateThreshold", contentDateThreshold == null ? messageDateThreshold : contentDateThreshold);
                params.put("limit", 100000);
                if (this.getSkipStatuses().length > 0) {
                    ArrayList<Status> statusesToSkip = new ArrayList<Status>(Arrays.asList(this.getSkipStatuses()));
                    if (pruneErroredMessages) {
                        statusesToSkip.remove(Status.ERROR);
                    }
                    params.put("skipStatuses", statusesToSkip);
                }
                PruneResult result = new PruneResult();
                PruneIds messageIds = new PruneIds();
                PruneIds contentMessageIds = new PruneIds();
                if (!this.archiveEnabled || !channelArchiveEnabled) {
                    this.getIdsToPrune(params, messageDateThreshold, messageIds, contentMessageIds);
                } else {
                    this.archiveAndGetIdsToPrune(params, channelId, messageDateThreshold, archiveFolder, messageIds, contentMessageIds);
                    result.numMessagesArchived = this.numExported;
                }
                while (messageIds.hasNext()) {
                    this.pruneChannelByIds(localChannelId, messageIds, false, result);
                }
                while (contentMessageIds.hasNext()) {
                    this.pruneChannelByIds(localChannelId, contentMessageIds, true, result);
                }
                return result;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                if (retries > 0) {
                    this.logger.error("Failed to prune messages for channel " + channelName + " (" + channelId + "). Attempts remaining: " + retries + ".", t);
                    --retries;
                    continue;
                }
                throw new DataPrunerException("Failed to prune messages", t);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIdsToPrune(Map<String, Object> params, Calendar messageDateThreshold, PruneIds messageIds, PruneIds contentMessageIds) throws InterruptedException {
        List maps;
        long minMessageId = 0L;
        do {
            ThreadUtils.checkInterruptedStatus();
            try (SqlSession session = SqlConfig.getInstance().getSqlSessionManager().openSession(true);){
                params.put("minMessageId", minMessageId);
                maps = session.selectList("Message.getMessagesToPrune", params);
            }
            for (Map map : maps) {
                long receivedDate = ((Calendar)map.get("mm_received_date")).getTimeInMillis();
                long id = (Long)map.get("id");
                if (messageDateThreshold != null && receivedDate < messageDateThreshold.getTimeInMillis()) {
                    messageIds.add(id);
                } else {
                    contentMessageIds.add(id);
                }
                minMessageId = id + 1L;
            }
        } while (maps != null && maps.size() == 100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveAndGetIdsToPrune(Map<String, Object> params, String channelId, Calendar messageDateThreshold, String archiveFolder, PruneIds messageIds, PruneIds contentMessageIds) throws Throwable {
        String tempChannelFolder = archiveFolder + "/." + channelId;
        String finalChannelFolder = archiveFolder + "/" + channelId;
        try {
            MessageWriterOptions messageWriterOptions = (MessageWriterOptions)SerializationUtils.clone((Serializable)this.archiverOptions);
            messageWriterOptions.setBaseFolder(System.getProperty("user.dir"));
            if (messageWriterOptions.getArchiveFormat() == null) {
                messageWriterOptions.setRootFolder(tempChannelFolder);
            } else {
                messageWriterOptions.setRootFolder(archiveFolder);
                messageWriterOptions.setArchiveFileName(channelId);
            }
            this.logger.debug("Running archiver, channel: " + channelId + ", root folder: " + messageWriterOptions.getRootFolder() + ", archive format: " + messageWriterOptions.getArchiveFormat() + ", archive filename: " + messageWriterOptions.getArchiveFileName() + ", file pattern: " + messageWriterOptions.getFilePattern());
            this.numExported = 0;
            this.status.setArchiving(true);
            MessageWriter archiver = MessageWriterFactory.getInstance().getMessageWriter(messageWriterOptions, ConfigurationController.getInstance().getEncryptor());
            AttachmentSource attachmentSource = null;
            if (messageWriterOptions.includeAttachments()) {
                attachmentSource = new AttachmentSource(){

                    public List<Attachment> getMessageAttachments(Message message) throws ClientException {
                        return MessageController.getInstance().getMessageAttachment(message.getChannelId(), message.getMessageId(), true);
                    }
                };
            }
            long minMessageId = 0L;
            try {
                List maps;
                do {
                    ThreadUtils.checkInterruptedStatus();
                    try (SqlSession session = SqlConfig.getInstance().getReadOnlySqlSessionManager().openSession(true);){
                        params.put("minMessageId", minMessageId);
                        maps = session.selectList("Message.getMessagesToPrune", params);
                    }
                    ArrayList<Long> archiveMessageIds = new ArrayList<Long>();
                    Iterator iterator = maps.iterator();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        long receivedDate = ((Calendar)map.get("mm_received_date")).getTimeInMillis();
                        long id = (Long)map.get("id");
                        if (messageDateThreshold != null && receivedDate < messageDateThreshold.getTimeInMillis()) {
                            messageIds.add(id);
                        } else {
                            contentMessageIds.add(id);
                        }
                        minMessageId = id + 1L;
                        archiveMessageIds.add(id);
                        if (archiveMessageIds.size() != this.archiverBlockSize && iterator.hasNext()) continue;
                        ThreadUtils.checkInterruptedStatus();
                        try (DonkeyDao dao = this.getReadOnlyDaoFactory().getDao();){
                            List messages = dao.getMessages(channelId, archiveMessageIds);
                            for (Message message : messages) {
                                List attachments;
                                if (attachmentSource != null && CollectionUtils.isNotEmpty((Collection)(attachments = attachmentSource.getMessageAttachments(message)))) {
                                    message.setAttachments(attachments);
                                }
                                if (!archiver.write(message)) continue;
                                ++this.numExported;
                            }
                            archiveMessageIds.clear();
                        }
                    }
                } while (maps != null && maps.size() == 100000);
                archiver.finishWrite();
            }
            finally {
                archiver.close();
            }
            if (messageWriterOptions.getArchiveFormat() == null && new File(tempChannelFolder).isDirectory()) {
                try {
                    FileUtils.moveDirectory((File)new File(tempChannelFolder), (File)new File(finalChannelFolder));
                }
                catch (IOException e) {
                    this.logger.error("Failed to move " + tempChannelFolder + " to " + finalChannelFolder, (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            FileUtils.deleteQuietly((File)new File(tempChannelFolder));
            FileUtils.deleteQuietly((File)new File(finalChannelFolder));
            throw t;
        }
        finally {
            this.status.setArchiving(false);
        }
    }

    private void pruneChannelByIds(long localChannelId, PruneIds ids, boolean contentOnly, PruneResult result) throws DataPrunerException, InterruptedException {
        if (!ids.hasNext()) {
            this.logger.debug("Skipping pruner since no messages were found to prune");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("localChannelId", localChannelId);
        ListRangeIterator listRangeIterator = new ListRangeIterator((Iterator)ids, 1000, true, Integer.valueOf(this.prunerBlockSize));
        while (listRangeIterator.hasNext()) {
            ThreadUtils.checkInterruptedStatus();
            ListRangeIterator.ListRangeItem item = listRangeIterator.next();
            List list = item.getList();
            Long startRange = item.getStartRange();
            Long endRange = item.getEndRange();
            if (list == null && (startRange == null || endRange == null)) continue;
            if (list != null) {
                this.logger.debug("Pruning with include list: " + String.valueOf(list.get(0)) + " " + String.valueOf(list.get(list.size() - 1)));
                params.remove("minMessageId");
                params.remove("maxMessageId");
                params.put("includeMessageList", StringUtils.join((Iterable)list, (String)","));
            } else {
                this.logger.debug("Pruning with ranges: " + startRange + " - " + endRange);
                params.remove("includeMessageList");
                params.put("minMessageId", startRange);
                params.put("maxMessageId", endRange);
            }
            this.runDeleteQueries(params, contentOnly, result);
        }
    }

    private void runDeleteQueries(Map<String, Object> params, boolean contentOnly, PruneResult result) {
        if (contentOnly) {
            if (DatabaseUtil.statementExists((String)"Message.pruneAttachments")) {
                this.runDelete("Message.pruneAttachments", params);
            }
            result.numContentPruned += (long)this.runDelete("Message.pruneMessageContent", params);
        } else {
            if (DatabaseUtil.statementExists((String)"Message.pruneAttachments")) {
                this.runDelete("Message.pruneAttachments", params);
            }
            if (DatabaseUtil.statementExists((String)"Message.pruneCustomMetaData")) {
                this.runDelete("Message.pruneCustomMetaData", params);
            }
            result.numContentPruned += (long)this.runDelete("Message.pruneMessageContent", params);
            if (DatabaseUtil.statementExists((String)"Message.pruneConnectorMessages")) {
                this.runDelete("Message.pruneConnectorMessages", params);
            }
            result.numMessagesPruned += (long)this.runDelete("Message.pruneMessages", params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runDelete(String query, Map<String, Object> params) {
        SqlSession session = SqlConfig.getInstance().getSqlSessionManager().openSession(true);
        try {
            int count;
            if (DatabaseUtil.statementExists((String)"initDataPruner", (SqlSession)session)) {
                session.update("initDataPruner");
            }
            this.status.setPruning(true);
            int n = count = session.delete(query, params);
            return n;
        }
        finally {
            session.close();
            this.status.setPruning(false);
        }
    }

    private String getTimeElapsed() {
        long ms = System.currentTimeMillis() - this.status.getTaskStartTime().getTimeInMillis();
        long mins = ms / 60000L;
        long secs = ms % 60000L / 1000L;
        return mins + " minute" + (mins == 1L ? "" : "s") + ", " + secs + " second" + (secs == 1L ? "" : "s");
    }

    private class PrunerTask {
        private String channelId;
        private String channelName;
        private Calendar messageDateThreshold;
        private Calendar contentDateThreshold;
        private boolean archiveEnabled;
        private boolean pruneErroredMessages;

        public PrunerTask(String channelId, String channelName, Calendar messageDateThreshold, Calendar contentDateThreshold, boolean archiveEnabled, boolean pruneErroredMessages) {
            this.channelId = channelId;
            this.channelName = channelName;
            this.messageDateThreshold = messageDateThreshold;
            this.contentDateThreshold = contentDateThreshold;
            this.archiveEnabled = archiveEnabled;
            this.pruneErroredMessages = pruneErroredMessages;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public Calendar getMessageDateThreshold() {
            return this.messageDateThreshold;
        }

        public Calendar getContentDateThreshold() {
            return this.contentDateThreshold;
        }

        public boolean isArchiveEnabled() {
            return this.archiveEnabled;
        }

        public boolean isPruneErroredMessages() {
            return this.pruneErroredMessages;
        }
    }

    private class PruneResult {
        public long numMessagesArchived;
        public long numMessagesPruned;
        public long numContentPruned;

        private PruneResult() {
        }
    }

    private class PruneIds
    implements Iterator<Long> {
        private int currentIdIndex = 0;
        private int currentRangeIndex = 0;
        private long lastId = 0L;
        private List<Long> ids = new ArrayList<Long>();
        private List<Long> ranges = new ArrayList<Long>();

        private PruneIds() {
        }

        public void add(Long messageId) {
            int lastIdIndex = this.ids.size() - 1;
            int lastRangeIndex = this.ranges.size() - 1;
            if (!this.ids.isEmpty() && messageId == this.ids.get(lastIdIndex) + 1L) {
                this.ids.remove(lastIdIndex);
                this.ranges.add(messageId - 1L);
                this.ranges.add(messageId);
            } else if (!this.ranges.isEmpty() && messageId == this.ranges.get(lastRangeIndex) + 1L) {
                this.ranges.set(lastRangeIndex, messageId);
            } else {
                this.ids.add(messageId);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIdIndex < this.ids.size() || this.currentRangeIndex < this.ranges.size();
        }

        @Override
        public Long next() {
            if (!this.ranges.isEmpty() && this.currentRangeIndex < this.ranges.size()) {
                if (this.lastId >= this.ranges.get(this.currentRangeIndex) && this.lastId < this.ranges.get(this.currentRangeIndex + 1)) {
                    if (++this.lastId == this.ranges.get(this.currentRangeIndex + 1)) {
                        this.currentRangeIndex += 2;
                    }
                    return this.lastId;
                }
                if (this.currentIdIndex < this.ids.size() && this.ids.get(this.currentIdIndex) < this.ranges.get(this.currentRangeIndex)) {
                    return this.ids.get(this.currentIdIndex++);
                }
                this.lastId = this.ranges.get(this.currentRangeIndex);
                return this.lastId;
            }
            return this.ids.get(this.currentIdIndex++);
        }

        @Override
        public void remove() {
        }
    }
}

