/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.dao.impl;

import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupAuditDao;
import com.mirth.connect.plugins.dynamiclookup.shared.model.HistoryFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupAudit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;

public class MyBatisLookupAuditDao
implements LookupAuditDao {
    private SqlSessionManager sqlSessionManager;

    public MyBatisLookupAuditDao(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAuditEntry(LookupAudit lookupAudit) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("groupId", lookupAudit.getGroupId());
            hashMap.put("tableName", lookupAudit.getTableName());
            hashMap.put("keyValue", lookupAudit.getKeyValue());
            hashMap.put("action", lookupAudit.getAction());
            hashMap.put("oldValue", lookupAudit.getOldValue());
            hashMap.put("newValue", lookupAudit.getNewValue());
            hashMap.put("userId", lookupAudit.getUserId());
            sqlSession.insert("Lookup.insertAuditEntry", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupAudit> getAuditEntriesByGroup(int n, int n2, int n3) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("groupId", n);
            hashMap.put("offset", n2);
            hashMap.put("limit", n3);
            List list = sqlSession.selectList("Lookup.getAuditEntriesByGroup", hashMap);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupAudit> searchAuditEntriesByGroup(int n, int n2, int n3, HistoryFilterState historyFilterState) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("groupId", n);
            hashMap.put("offset", n2);
            hashMap.put("limit", n3);
            hashMap.put("keyValue", historyFilterState.getKeyValue());
            hashMap.put("action", historyFilterState.getAction());
            hashMap.put("userId", historyFilterState.getUserId());
            hashMap.put("startDate", historyFilterState.getStartDate());
            hashMap.put("endDate", historyFilterState.getEndDate());
            List list = sqlSession.selectList("Lookup.searchAuditEntriesByGroup", hashMap);
            return list;
        }
    }

    @Override
    public List<LookupAudit> getAuditEntriesByKey(int n, String string, int n2) {
        return new ArrayList<LookupAudit>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAuditEntryCount(int n) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("groupId", n);
            long l = (Long)sqlSession.selectOne("Lookup.getAuditEntryCount", hashMap);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long searchAuditEntryCount(int n, HistoryFilterState historyFilterState) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("groupId", n);
            hashMap.put("keyValue", historyFilterState.getKeyValue());
            hashMap.put("action", historyFilterState.getAction());
            hashMap.put("userId", historyFilterState.getUserId());
            hashMap.put("startDate", historyFilterState.getStartDate());
            hashMap.put("endDate", historyFilterState.getEndDate());
            long l = (Long)sqlSession.selectOne("Lookup.searchAuditEntryCount", hashMap);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteAuditEntriesBefore(Date date) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Date> hashMap = new HashMap<String, Date>();
            hashMap.put("cutoff", date);
            int n = sqlSession.delete("Lookup.deleteAuditEntriesBefore", hashMap);
            sqlSession.commit();
            bl = true;
            long l = n;
            return l;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }
}

