/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.migration;

import com.mirth.connect.plugins.dynamiclookup.server.migration.LookupSchemaMigrator;
import com.mirth.connect.plugins.dynamiclookup.server.migration.SqlScriptRunner;
import com.mirth.connect.plugins.dynamiclookup.server.util.DatabaseDialect;
import com.mirth.connect.server.util.DatabaseUtil;
import java.sql.Connection;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LookupDatabaseMigrator {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SqlSessionManager sqlSessionManager;

    public LookupDatabaseMigrator(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    public void initializeDatabase() throws Exception {
        this.logger.info("Initializing database schema...");
        boolean bl = false;
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            bl = DatabaseUtil.tableExists((Connection)sqlSession.getConnection(), (String)"LOOKUP_GROUP");
        }
        if (!bl) {
            DatabaseDialect.DatabaseType databaseType = DatabaseDialect.determineDatabaseType(this.sqlSessionManager);
            String string = SqlScriptRunner.loadScript(this.getCreateSchemaScriptPath(databaseType));
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
            this.logger.info("Database schema initialized successfully");
            return;
        }
        this.logger.info("Tables exist - Checking for schema migrations...");
        new LookupSchemaMigrator(this.sqlSessionManager).migrate();
        this.logger.info("Tables exist - Database schema migration check completed");
    }

    private String getCreateSchemaScriptPath(DatabaseDialect.DatabaseType databaseType) {
        return switch (databaseType) {
            case DatabaseDialect.DatabaseType.POSTGRESQL -> "/sql/postgres/create_lookup_tables.sql";
            case DatabaseDialect.DatabaseType.MYSQL -> "/sql/mysql/create_lookup_tables.sql";
            case DatabaseDialect.DatabaseType.SQLSERVER -> "/sql/sqlserver/create_lookup_tables.sql";
            case DatabaseDialect.DatabaseType.ORACLE -> "/sql/oracle/create_lookup_tables.sql";
            default -> "/sql/derby/create_lookup_tables.sql";
        };
    }
}

