/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.migration;

import com.mirth.connect.plugins.dynamiclookup.server.migration.SqlScriptRunner;
import com.mirth.connect.plugins.dynamiclookup.server.util.DatabaseDialect;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.apache.commons.dbutils.DbUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupSchemaMigrator {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SqlSessionManager sqlSessionManager;

    public LookupSchemaMigrator(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    public void migrate() {
        if (this.needUpdateV101()) {
            String string = "/sql/sqlserver/fixes/V101_convert_varchar_to_nvarchar.sql";
            String string2 = SqlScriptRunner.loadScript(string);
            SqlScriptRunner.runWithGo(this.sqlSessionManager, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean needUpdateV101() {
        ResultSet resultSet;
        SqlSession sqlSession;
        block19: {
            DatabaseDialect.DatabaseType databaseType = DatabaseDialect.determineDatabaseType(this.sqlSessionManager);
            if (databaseType != DatabaseDialect.DatabaseType.SQLSERVER) {
                return false;
            }
            sqlSession = this.sqlSessionManager.openSession();
            resultSet = null;
            DatabaseMetaData databaseMetaData = sqlSession.getConnection().getMetaData();
            resultSet = databaseMetaData.getColumns(null, null, "LOOKUP_GROUP", "NAME");
            if (resultSet.next()) break block19;
            DbUtils.closeQuietly((ResultSet)resultSet);
            resultSet = databaseMetaData.getColumns(null, null, "lookup_group", "name");
            if (resultSet.next()) break block19;
            boolean bl = false;
            DbUtils.closeQuietly((ResultSet)resultSet);
            try {
                sqlSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }
        String string = resultSet.getString("TYPE_NAME");
        boolean bl = string == null || !"NVARCHAR".equalsIgnoreCase(string);
        DbUtils.closeQuietly((ResultSet)resultSet);
        try {
            sqlSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        {
            catch (Exception exception) {
                boolean bl2;
                try {
                    this.logger.warn("needUpdateV101() check failed: {}", (Object)exception.getMessage());
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        DbUtils.closeQuietly(resultSet);
                        try {
                            sqlSession.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (Exception exception3) {
                        return false;
                    }
                }
                DbUtils.closeQuietly((ResultSet)resultSet);
                try {
                    sqlSession.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                return bl2;
            }
        }
    }
}

