/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;

public final class DatabaseDialect {
    private DatabaseDialect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseType determineDatabaseType(SqlSessionManager sqlSessionManager) throws SQLException {
        try (SqlSession sqlSession = sqlSessionManager.openSession();){
            Connection connection = sqlSession.getConnection();
            String string = connection.getMetaData().getDatabaseProductName();
            String string2 = (string == null ? "" : string).toLowerCase();
            if (string2.contains("postgresql")) {
                DatabaseType databaseType = DatabaseType.POSTGRESQL;
                return databaseType;
            }
            if (string2.contains("mysql") || string2.contains("mariadb")) {
                DatabaseType databaseType = DatabaseType.MYSQL;
                return databaseType;
            }
            if (string2.contains("microsoft") || string2.contains("sql server")) {
                DatabaseType databaseType = DatabaseType.SQLSERVER;
                return databaseType;
            }
            if (string2.contains("oracle")) {
                DatabaseType databaseType = DatabaseType.ORACLE;
                return databaseType;
            }
            if (string2.contains("derby")) {
                DatabaseType databaseType = DatabaseType.DERBY;
                return databaseType;
            }
            DatabaseType databaseType = DatabaseType.DERBY;
            return databaseType;
        }
    }

    public static enum DatabaseType {
        DERBY,
        POSTGRESQL,
        MYSQL,
        SQLSERVER,
        ORACLE;

    }
}

