/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicater
implements PlugInFilter,
TextListener {
    ImagePlus imp;
    static boolean duplicateStack;
    boolean duplicateSubstack;
    int first;
    int last;
    Checkbox checkbox;
    TextField rangeField;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Duplicater.class);
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.duplicate(this.imp);
    }

    public void duplicate(ImagePlus imp) {
        ImagePlus imp2;
        int stackSize = imp.getStackSize();
        String title = imp.getTitle();
        String newTitle = WindowManager.getUniqueName(title);
        if (!IJ.altKeyDown() || stackSize > 1) {
            newTitle = this.getString("Duplicate...", "Title: ", newTitle);
        }
        if (newTitle == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (this.duplicateSubstack && (this.first > 1 || this.last < stackSize)) {
            imp2 = this.duplicateSubstack(imp, newTitle, this.first, this.last);
        } else if (duplicateStack) {
            imp2 = this.duplicateStack(imp, newTitle);
        } else {
            ImageProcessor ip2 = imp.getProcessor().crop();
            imp2 = imp.createImagePlus();
            imp2.setProcessor(newTitle, ip2);
            String info = (String)imp.getProperty("Info");
            if (info != null) {
                imp2.setProperty("Info", info);
            }
            if (stackSize > 1) {
                ImageStack stack = imp.getStack();
                String label = stack.getSliceLabel(imp.getCurrentSlice());
                if (label != null && label.indexOf(10) > 0) {
                    imp2.setProperty("Info", label);
                }
                if (imp.isComposite()) {
                    LUT lut = ((CompositeImage)imp).getChannelLut();
                    imp2.getProcessor().setColorModel(lut);
                }
            }
        }
        imp2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            imp2.restoreRoi();
        }
    }

    public ImagePlus duplicateStack(ImagePlus imp, String newTitle) {
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        int width = rect != null ? rect.width : imp.getWidth();
        int height = rect != null ? rect.height : imp.getHeight();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height, imp.getProcessor().getColorModel());
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(newTitle, stack2);
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, 0);
            ((CompositeImage)imp2).copyLuts(imp);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        return imp2;
    }

    public ImagePlus duplicateSubstack(ImagePlus imp, String newTitle, int first, int last) {
        boolean tseries;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        int width = rect != null ? rect.width : imp.getWidth();
        int height = rect != null ? rect.height : imp.getHeight();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height, imp.getProcessor().getColorModel());
        for (int i = first; i <= last; ++i) {
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(newTitle, stack2);
        int size = stack2.getSize();
        boolean bl = tseries = imp.getNFrames() == imp.getStackSize();
        if (tseries) {
            imp2.setDimensions(1, 1, size);
        } else {
            imp2.setDimensions(1, size, 1);
        }
        return imp2;
    }

    String getString(String title, String prompt, String defaultString) {
        Frame win = this.imp.getWindow();
        int stackSize = this.imp.getStackSize();
        if (win == null) {
            win = IJ.getInstance();
        }
        this.duplicateSubstack = stackSize > 1 && (stackSize == this.imp.getNSlices() || stackSize == this.imp.getNFrames());
        GenericDialog gd = new GenericDialog(title, win);
        gd.addStringField(prompt, defaultString, this.duplicateSubstack ? 15 : 20);
        if (stackSize > 1) {
            String msg = this.duplicateSubstack ? "Duplicate Stack" : "Duplicate Entire Stack";
            gd.addCheckbox(msg, duplicateStack || this.imp.isComposite());
            if (this.duplicateSubstack) {
                gd.setInsets(2, 30, 3);
                gd.addStringField("Range:", "1-" + stackSize);
                Vector v = gd.getStringFields();
                this.rangeField = (TextField)v.elementAt(1);
                this.rangeField.addTextListener(this);
                this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
            }
        } else {
            duplicateStack = false;
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        title = gd.getNextString();
        if (stackSize > 1) {
            duplicateStack = gd.getNextBoolean();
            if (duplicateStack && this.duplicateSubstack) {
                String[] range = Tools.split(gd.getNextString(), " -");
                double d1 = Tools.parseDouble(range[0]);
                double d2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
                this.first = Double.isNaN(d1) ? 1 : (int)d1;
                int n = this.last = Double.isNaN(d2) ? stackSize : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > stackSize) {
                    this.last = stackSize;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = stackSize;
                }
            } else {
                this.first = 1;
                this.last = stackSize;
            }
        }
        return title;
    }

    public void textValueChanged(TextEvent e) {
        this.checkbox.setState(true);
    }
}

