/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ListenerSettingsPanel;
import com.mirth.connect.connectors.http.HttpReceiverProperties;
import com.mirth.connect.connectors.http.HttpStaticResource;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class HttpListener
extends ConnectorSettingsPanel {
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String NAME_COLUMN_NAME = "Name";
    private final String VALUE_COLUMN_NAME = "Value";
    private int responseHeadersLastIndex = -1;
    private int staticResourcesLastIndex = -1;
    private boolean usingHttps = false;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private MirthTextField binaryMimeTypesField;
    private JLabel binaryMimeTypesLabel;
    private MirthCheckBox binaryMimeTypesRegexCheckBox;
    private MirthComboBox<String> charsetEncodingCombobox;
    private JLabel charsetEncodingLabel;
    protected MirthTextField contextPathField;
    protected JLabel contextPathLabel;
    private JLabel headersLabel;
    protected JTextField httpUrlField;
    protected JLabel httpUrlLabel;
    private ButtonGroup includeHeadersGroup;
    private ButtonGroup includeMetadataButtonGroup;
    private JLabel includeMetadataLabel;
    private MirthRadioButton includeMetadataNoRadio;
    private MirthRadioButton includeMetadataYesRadio;
    private JLabel messageContentLabel;
    private MirthRadioButton messageContentPlainBodyRadio;
    private MirthRadioButton messageContentXmlBodyRadio;
    private ButtonGroup parseMultipartButtonGroup;
    private JLabel parseMultipartLabel;
    private MirthRadioButton parseMultipartNoRadio;
    private MirthRadioButton parseMultipartYesRadio;
    protected MirthTextField receiveTimeoutField;
    protected JLabel receiveTimeoutLabel;
    protected JLabel responseStatusCodeLabel;
    private MirthTextField responseContentTypeField;
    private JLabel responseContentTypeLabel;
    private MirthRadioButton responseDataTypeBinaryRadio;
    private ButtonGroup responseDataTypeButtonGroup;
    private JLabel responseDataTypeLabel;
    private MirthRadioButton responseDataTypeTextRadio;
    private JButton responseHeadersDeleteButton;
    private JButton responseHeadersNewButton;
    private JScrollPane responseHeadersPane;
    private JScrollPane responseHeadersPane1;
    private MirthTable responseHeadersTable;
    private MirthRadioButton useResponseHeadersTableRadio;
    private MirthRadioButton useResponseHeadersVariableRadio;
    private MirthTextField responseHeadersVariableField;
    private MirthTextField responseStatusCodeField;
    private JButton staticResourcesDeleteButton;
    private JLabel staticResourcesLabel;
    private JButton staticResourcesNewButton;
    private MirthTable staticResourcesTable;

    public HttpListener() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.initComponentsManual();
        this.httpUrlField.setEditable(false);
        this.parent.setupCharsetEncodingForConnector(this.charsetEncodingCombobox);
    }

    public String getConnectorName() {
        return new HttpReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        HttpReceiverProperties properties = (HttpReceiverProperties)this.getDefaults();
        properties.setContextPath(this.contextPathField.getText());
        properties.setTimeout(this.receiveTimeoutField.getText());
        properties.setXmlBody(this.messageContentXmlBodyRadio.isSelected());
        properties.setParseMultipart(this.parseMultipartYesRadio.isSelected());
        properties.setIncludeMetadata(this.includeMetadataYesRadio.isSelected());
        properties.setBinaryMimeTypes(this.binaryMimeTypesField.getText());
        properties.setBinaryMimeTypesRegex(this.binaryMimeTypesRegexCheckBox.isSelected());
        properties.setResponseContentType(this.responseContentTypeField.getText());
        properties.setResponseDataTypeBinary(this.responseDataTypeBinaryRadio.isSelected());
        properties.setCharset(this.parent.getSelectedEncodingForConnector(this.charsetEncodingCombobox));
        properties.setResponseStatusCode(this.responseStatusCodeField.getText());
        properties.setResponseHeadersMap(this.getResponseHeaders());
        properties.setUseHeadersVariable(this.useResponseHeadersVariableRadio.isSelected());
        properties.setResponseHeadersVariable(this.responseHeadersVariableField.getText());
        properties.setStaticResources(this.getStaticResources());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        HttpReceiverProperties props = (HttpReceiverProperties)properties;
        this.contextPathField.setText(props.getContextPath());
        this.receiveTimeoutField.setText(props.getTimeout());
        this.updateHttpUrl();
        if (props.isXmlBody()) {
            this.messageContentXmlBodyRadio.setSelected(true);
            this.messageContentXmlBodyRadioActionPerformed(null);
        } else {
            this.messageContentPlainBodyRadio.setSelected(true);
            this.messageContentPlainBodyRadioActionPerformed(null);
        }
        if (props.isParseMultipart()) {
            this.parseMultipartYesRadio.setSelected(true);
        } else {
            this.parseMultipartNoRadio.setSelected(true);
        }
        if (props.isIncludeMetadata()) {
            this.includeMetadataYesRadio.setSelected(true);
        } else {
            this.includeMetadataNoRadio.setSelected(true);
        }
        this.binaryMimeTypesField.setText(props.getBinaryMimeTypes());
        this.binaryMimeTypesRegexCheckBox.setSelected(props.isBinaryMimeTypesRegex());
        this.responseContentTypeField.setText(props.getResponseContentType());
        if (props.isResponseDataTypeBinary()) {
            this.responseDataTypeBinaryRadio.setSelected(true);
            this.responseDataTypeBinaryRadioActionPerformed(null);
        } else {
            this.responseDataTypeTextRadio.setSelected(true);
            this.responseDataTypeTextRadioActionPerformed(null);
        }
        this.parent.setPreviousSelectedEncodingForConnector(this.charsetEncodingCombobox, props.getCharset());
        this.responseStatusCodeField.setText(props.getResponseStatusCode());
        if (props.getResponseHeadersMap() != null) {
            this.setResponseHeaders(props.getResponseHeadersMap());
        } else {
            this.setResponseHeaders(new LinkedHashMap<String, List<String>>());
        }
        if (props.isUseHeadersVariable()) {
            this.useResponseHeadersVariableRadio.setSelected(true);
        } else {
            this.useResponseHeadersTableRadio.setSelected(true);
        }
        this.responseHeadersVariableField.setText(props.getResponseHeadersVariable());
        this.useResponseHeadersVariableFieldsEnabled(props.isUseHeadersVariable());
        if (props.getStaticResources() != null) {
            this.setStaticResources(props.getStaticResources());
        } else {
            this.setStaticResources(new ArrayList<HttpStaticResource>(0));
        }
    }

    public ConnectorProperties getDefaults() {
        return new HttpReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        HttpReceiverProperties props = (HttpReceiverProperties)properties;
        boolean valid = true;
        if (props.getTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.receiveTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!props.getSourceConnectorProperties().getResponseVariable().equalsIgnoreCase("None") && props.getResponseContentType().length() == 0) {
            valid = false;
            if (highlight) {
                this.responseContentTypeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseHeadersVariable() && StringUtils.isBlank((CharSequence)props.getResponseHeadersVariable())) {
            valid = false;
            if (highlight) {
                this.responseHeadersVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.receiveTimeoutField.setBackground(null);
        this.responseContentTypeField.setBackground(null);
        this.responseHeadersVariableField.setBackground(null);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        this.usingHttps = connectorTypeDecoration != null;
        this.updateHttpUrl();
    }

    public String getRequiredInboundDataType() {
        if (((HttpReceiverProperties)this.getProperties()).isXmlBody()) {
            return "XML";
        }
        return null;
    }

    public void updateHttpUrl() {
        String server = "<server ip>";
        try {
            server = new URI(PlatformUI.SERVER_URL).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpUrlLabel.setText(this.usingHttps ? "HTTPS URL:" : "HTTP URL:");
        this.httpUrlField.setText("http" + (this.usingHttps ? "s" : "") + "://" + server + ":" + ((HttpReceiverProperties)this.getFilledProperties()).getListenerConnectorProperties().getPort() + (this.contextPathField.getText().startsWith("/") ? "" : "/") + this.contextPathField.getText() + (StringUtils.isBlank((CharSequence)this.contextPathField.getText()) || this.contextPathField.getText().endsWith("/") ? "" : "/"));
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        int size = 0;
        for (List<String> property : responseHeaders.values()) {
            size += property.size();
        }
        Object[][] tableData = new Object[size][2];
        this.responseHeadersTable = new MirthTable();
        int j = 0;
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String keyValue : entry.getValue()) {
                tableData[j][0] = entry.getKey();
                tableData[j][1] = keyValue;
                ++j;
            }
        }
        this.responseHeadersTable.setModel((TableModel)new DefaultTableModel(tableData, new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.responseHeadersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (HttpListener.this.getSelectedRow(HttpListener.this.responseHeadersTable) != -1) {
                    HttpListener.this.responseHeadersLastIndex = HttpListener.this.getSelectedRow(HttpListener.this.responseHeadersTable);
                    HttpListener.this.responseHeadersDeleteButton.setEnabled(true);
                } else {
                    HttpListener.this.responseHeadersDeleteButton.setEnabled(false);
                }
            }
        });
        class HTTPTableCellEditor
        extends TextFieldCellEditor {
            boolean checkProperties;

            public HTTPTableCellEditor(boolean checkProperties) {
                this.checkProperties = checkProperties;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    HttpListener.this.responseHeadersDeleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                HttpListener.this.responseHeadersDeleteButton.setEnabled(true);
                if (this.checkProperties && value.length() == 0) {
                    return false;
                }
                HttpListener.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.responseHeadersTable.getColumnModel().getColumn(this.responseHeadersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(true)));
        this.responseHeadersTable.getColumnModel().getColumn(this.responseHeadersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(false)));
        this.responseHeadersTable.setCustomEditorControls(true);
        this.responseHeadersTable.setSelectionMode(0);
        this.responseHeadersTable.setRowSelectionAllowed(true);
        this.responseHeadersTable.setRowHeight(20);
        this.responseHeadersTable.setDragEnabled(false);
        this.responseHeadersTable.setOpaque(true);
        this.responseHeadersTable.setSortable(false);
        this.responseHeadersTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.responseHeadersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.responseHeadersPane.setViewportView((Component)this.responseHeadersTable);
        this.responseHeadersDeleteButton.setEnabled(false);
    }

    public Map<String, List<String>> getResponseHeaders() {
        LinkedHashMap<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < this.responseHeadersTable.getRowCount(); ++i) {
            String key = (String)this.responseHeadersTable.getValueAt(i, 0);
            ArrayList<String> headers = (ArrayList<String>)properties.get(key);
            if (headers == null) {
                headers = new ArrayList<String>();
                properties.put(key, headers);
            }
            headers.add((String)this.responseHeadersTable.getValueAt(i, 1));
        }
        return properties;
    }

    public int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private String getNewPropertyName(MirthTable table) {
        String temp = "Property ";
        for (int i = 1; i <= table.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int j = 0; j < table.getRowCount(); ++j) {
                if (!((String)table.getValueAt(j, 0)).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    public void updatedField(String field) {
        if (ListenerSettingsPanel.FIELD_PORT.equals(field)) {
            this.updateHttpUrl();
        }
    }

    private List<HttpStaticResource> getStaticResources() {
        ArrayList<HttpStaticResource> staticResources = new ArrayList<HttpStaticResource>();
        for (int i = 0; i < this.staticResourcesTable.getRowCount(); ++i) {
            String contextPath = (String)this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.CONTEXT_PATH.getIndex());
            HttpStaticResource.ResourceType resourceType = HttpStaticResource.ResourceType.fromString((String)((String)this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.RESOURCE_TYPE.getIndex())));
            String value = (String)this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.VALUE.getIndex());
            String contentType = (String)this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.CONTENT_TYPE.getIndex());
            staticResources.add(new HttpStaticResource(contextPath, resourceType, value, contentType));
        }
        return staticResources;
    }

    private void setStaticResources(List<HttpStaticResource> staticResources) {
        Object[][] tableData = new Object[staticResources.size()][4];
        for (int i = 0; i < staticResources.size(); ++i) {
            HttpStaticResource staticResource = staticResources.get(i);
            tableData[i][0] = staticResource.getContextPath();
            tableData[i][1] = staticResource.getResourceType().toString();
            tableData[i][2] = staticResource.getValue();
            tableData[i][3] = staticResource.getContentType();
        }
        ((RefreshTableModel)this.staticResourcesTable.getModel()).refreshDataVector(tableData);
    }

    private String getBaseContextPath() {
        Object contextPath = StringUtils.trimToEmpty((String)this.contextPathField.getText());
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        while (((String)contextPath).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1).trim();
        }
        return contextPath;
    }

    private String fixContentPath(String contextPath) {
        if (!((String)(contextPath = StringUtils.trimToEmpty((String)contextPath))).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        while (((String)contextPath).endsWith("/") && ((String)contextPath).length() > 1) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1).trim();
        }
        return contextPath;
    }

    private void initComponentsManual() {
        this.staticResourcesTable.setModel((TableModel)new RefreshTableModel(StaticResourcesColumn.getNames(), 0){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        this.staticResourcesTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.staticResourcesTable.setRowHeight(20);
        this.staticResourcesTable.setFocusable(true);
        this.staticResourcesTable.setSortable(false);
        this.staticResourcesTable.setOpaque(true);
        this.staticResourcesTable.setDragEnabled(false);
        this.staticResourcesTable.getTableHeader().setReorderingAllowed(false);
        this.staticResourcesTable.setShowGrid(true, true);
        this.staticResourcesTable.setAutoCreateColumnsFromModel(false);
        this.staticResourcesTable.setSelectionMode(0);
        this.staticResourcesTable.setRowSelectionAllowed(true);
        this.staticResourcesTable.setCustomEditorControls(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.staticResourcesTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        class ContextPathCellEditor
        extends TextFieldCellEditor {
            public ContextPathCellEditor() {
                this.getTextField().setDocument((Document)new MirthFieldConstraints("^\\S*$"));
            }

            protected boolean valueChanged(String value) {
                if (StringUtils.isEmpty((CharSequence)value) || value.equals("/")) {
                    return false;
                }
                if (value.equals(this.getOriginalValue())) {
                    return false;
                }
                for (int i = 0; i < HttpListener.this.staticResourcesTable.getRowCount(); ++i) {
                    if (!value.equals(HttpListener.this.fixContentPath((String)HttpListener.this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.CONTEXT_PATH.getIndex())))) continue;
                    return false;
                }
                HttpListener.this.parent.setSaveEnabled(true);
                return true;
            }

            public Object getCellEditorValue() {
                String baseContextPath;
                String value = HttpListener.this.fixContentPath((String)super.getCellEditorValue());
                if (value.equals(baseContextPath = HttpListener.this.getBaseContextPath())) {
                    return null;
                }
                return HttpListener.this.fixContentPath(StringUtils.removeStartIgnoreCase((String)value, (String)(baseContextPath + "/")));
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String resourceContextPath = HttpListener.this.fixContentPath((String)value);
                this.setOriginalValue(resourceContextPath);
                this.getTextField().setText(HttpListener.this.getBaseContextPath() + resourceContextPath);
                return this.getTextField();
            }
        }
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.CONTEXT_PATH.getIndex()).setCellEditor((TableCellEditor)((Object)new ContextPathCellEditor()));
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.CONTEXT_PATH.getIndex()).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                super.setValue(HttpListener.this.getBaseContextPath() + HttpListener.this.fixContentPath((String)value));
            }
        });
        Object[] resourceTypes = HttpStaticResource.ResourceType.stringValues();
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.RESOURCE_TYPE.getIndex()).setMinWidth(100);
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.RESOURCE_TYPE.getIndex()).setMaxWidth(100);
        class ResourceTypeCellEditor
        extends MirthComboBoxTableCellEditor
        implements ActionListener {
            private Object originalValue;

            public ResourceTypeCellEditor(JTable table, Object[] items, int clickCount, boolean focusable) {
                super(table, items, clickCount, focusable, null);
                for (ActionListener actionListener : this.comboBox.getActionListeners()) {
                    this.comboBox.removeActionListener(actionListener);
                }
                this.comboBox.addActionListener((ActionListener)this);
            }

            public boolean stopCellEditing() {
                if (ObjectUtils.equals((Object)this.getCellEditorValue(), (Object)this.originalValue)) {
                    this.cancelCellEditing();
                } else {
                    HttpListener.this.parent.setSaveEnabled(true);
                }
                return super.stopCellEditing();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.originalValue = value;
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((AbstractTableModel)HttpListener.this.staticResourcesTable.getModel()).fireTableCellUpdated(HttpListener.this.staticResourcesTable.getSelectedRow(), StaticResourcesColumn.VALUE.getIndex());
                this.stopCellEditing();
                this.fireEditingStopped();
            }
        }
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.RESOURCE_TYPE.getIndex()).setCellEditor((TableCellEditor)((Object)new ResourceTypeCellEditor((JTable)this.staticResourcesTable, resourceTypes, 1, false)));
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.RESOURCE_TYPE.getIndex()).setCellRenderer((TableCellRenderer)new MirthComboBoxTableCellRenderer(resourceTypes));
        class ValueCellEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            private JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0 1 0 0, novisualpadding, hidemode 3"));
            private JLabel label;
            private JTextField textField;
            private String text;
            private String originalValue;

            public ValueCellEditor() {
                this.panel.setBackground(UIConstants.BACKGROUND_COLOR);
                this.label = new JLabel();
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        new 1ValueCellEditor.ValueDialog();
                        this.stopCellEditing();
                    }
                });
                this.panel.add((Component)this.label, "grow, pushx, h 19!");
                this.textField = new JTextField();
                this.panel.add((Component)this.textField, "grow, pushx, h 19!");
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt == null) {
                    return false;
                }
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                if (this.label.isVisible()) {
                    return this.text;
                }
                return this.textField.getText();
            }

            @Override
            public boolean stopCellEditing() {
                if (ObjectUtils.equals((Object)this.getCellEditorValue(), (Object)this.originalValue)) {
                    this.cancelCellEditing();
                } else {
                    HttpListener.this.parent.setSaveEnabled(true);
                }
                return super.stopCellEditing();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String text;
                boolean custom = table.getValueAt(row, StaticResourcesColumn.RESOURCE_TYPE.getIndex()).equals(HttpStaticResource.ResourceType.CUSTOM.toString());
                this.label.setVisible(custom);
                this.textField.setVisible(!custom);
                this.panel.setBackground(table.getSelectionBackground());
                this.label.setBackground(this.panel.getBackground());
                this.label.setMaximumSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), 19));
                this.text = text = (String)value;
                this.originalValue = text;
                this.label.setText(text);
                this.textField.setText(text);
                return this.panel;
            }

            class 1ValueCellEditor.ValueDialog
            extends MirthDialog {
                public 1ValueCellEditor.ValueDialog() {
                    super((Window)HttpListener.this.parent, true);
                    this.setTitle("Custom Value");
                    this.setPreferredSize(new Dimension(600, 500));
                    this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill", "", "[grow]7[]"));
                    this.setBackground(UIConstants.BACKGROUND_COLOR);
                    this.getContentPane().setBackground(this.getBackground());
                    final MirthSyntaxTextArea textArea = new MirthSyntaxTextArea();
                    textArea.setSaveEnabled(false);
                    textArea.setText(text);
                    textArea.setBorder(BorderFactory.createEtchedBorder());
                    this.add((Component)textArea, "grow");
                    this.add(new JSeparator(), "newline, grow");
                    JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
                    buttonPanel.setBackground(this.getBackground());
                    JButton openFileButton = new JButton("Open File...");
                    openFileButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            String content = HttpListener.this.parent.browseForFileString(null);
                            if (content != null) {
                                textArea.setText(content);
                            }
                        }
                    });
                    buttonPanel.add(openFileButton);
                    JButton okButton = new JButton("OK");
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            text = textArea.getText();
                            label.setText(text);
                            textField.setText(text);
                            HttpListener.this.staticResourcesTable.getModel().setValueAt(text, HttpListener.this.staticResourcesTable.getSelectedRow(), StaticResourcesColumn.VALUE.getIndex());
                            HttpListener.this.parent.setSaveEnabled(true);
                            ValueDialog.this.dispose();
                        }
                    });
                    buttonPanel.add(okButton);
                    JButton cancelButton = new JButton("Cancel");
                    cancelButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            ValueDialog.this.dispose();
                        }
                    });
                    buttonPanel.add(cancelButton);
                    this.add(buttonPanel, "newline, right");
                    this.pack();
                    this.setLocationRelativeTo((Component)HttpListener.this.parent);
                    this.setVisible(true);
                }
            }
        }
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.VALUE.getIndex()).setCellEditor((TableCellEditor)new ValueCellEditor());
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.CONTENT_TYPE.getIndex()).setMinWidth(100);
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.CONTENT_TYPE.getIndex()).setMaxWidth(150);
        this.staticResourcesTable.getColumnExt(StaticResourcesColumn.CONTENT_TYPE.getIndex()).setCellEditor((TableCellEditor)new TextFieldCellEditor(){

            protected boolean valueChanged(String value) {
                if (value.equals(this.getOriginalValue())) {
                    return false;
                }
                HttpListener.this.parent.setSaveEnabled(true);
                return true;
            }
        });
        this.staticResourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (HttpListener.this.getSelectedRow(HttpListener.this.staticResourcesTable) != -1) {
                    HttpListener.this.staticResourcesLastIndex = HttpListener.this.getSelectedRow(HttpListener.this.staticResourcesTable);
                    HttpListener.this.staticResourcesDeleteButton.setEnabled(true);
                } else {
                    HttpListener.this.staticResourcesDeleteButton.setEnabled(false);
                }
            }
        });
        this.contextPathField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.changedUpdate(evt);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.changedUpdate(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                ((AbstractTableModel)HttpListener.this.staticResourcesTable.getModel()).fireTableDataChanged();
            }
        });
        this.staticResourcesDeleteButton.setEnabled(false);
    }

    private boolean checkStaticResourceContextPath(String contextPath) {
        for (int i = 0; i < this.staticResourcesTable.getRowCount(); ++i) {
            if (!contextPath.equals(this.staticResourcesTable.getValueAt(i, StaticResourcesColumn.CONTEXT_PATH.getIndex()))) continue;
            return false;
        }
        return true;
    }

    protected void initComponents() {
        this.includeHeadersGroup = new ButtonGroup();
        this.parseMultipartButtonGroup = new ButtonGroup();
        this.includeMetadataButtonGroup = new ButtonGroup();
        this.responseDataTypeButtonGroup = new ButtonGroup();
        this.messageContentPlainBodyRadio = new MirthRadioButton();
        this.messageContentLabel = new JLabel();
        this.responseContentTypeField = new MirthTextField();
        this.responseContentTypeLabel = new JLabel();
        this.charsetEncodingCombobox = new MirthComboBox();
        this.charsetEncodingLabel = new JLabel();
        this.contextPathLabel = new JLabel();
        this.contextPathField = new MirthTextField();
        this.receiveTimeoutLabel = new JLabel();
        this.receiveTimeoutField = new MirthTextField();
        this.httpUrlField = new JTextField();
        this.httpUrlLabel = new JLabel();
        this.headersLabel = new JLabel();
        this.responseHeadersPane = new JScrollPane();
        this.responseHeadersTable = new MirthTable();
        this.responseHeadersNewButton = new JButton();
        this.responseHeadersDeleteButton = new JButton();
        this.responseStatusCodeLabel = new JLabel();
        this.responseStatusCodeField = new MirthTextField();
        this.messageContentXmlBodyRadio = new MirthRadioButton();
        this.parseMultipartLabel = new JLabel();
        this.parseMultipartYesRadio = new MirthRadioButton();
        this.parseMultipartNoRadio = new MirthRadioButton();
        this.includeMetadataLabel = new JLabel();
        this.includeMetadataYesRadio = new MirthRadioButton();
        this.includeMetadataNoRadio = new MirthRadioButton();
        this.staticResourcesLabel = new JLabel();
        this.staticResourcesDeleteButton = new JButton();
        this.staticResourcesNewButton = new JButton();
        this.responseHeadersPane1 = new JScrollPane();
        this.staticResourcesTable = new MirthTable();
        this.responseDataTypeLabel = new JLabel();
        this.responseDataTypeBinaryRadio = new MirthRadioButton();
        this.responseDataTypeTextRadio = new MirthRadioButton();
        this.binaryMimeTypesLabel = new JLabel();
        this.binaryMimeTypesField = new MirthTextField();
        this.binaryMimeTypesRegexCheckBox = new MirthCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.messageContentPlainBodyRadio.setBackground(new Color(255, 255, 255));
        this.includeHeadersGroup.add((AbstractButton)this.messageContentPlainBodyRadio);
        this.messageContentPlainBodyRadio.setText("Plain Body");
        this.messageContentPlainBodyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.messageContentPlainBodyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.messageContentPlainBodyRadioActionPerformed(evt);
            }
        });
        this.messageContentLabel.setText("Message Content:");
        this.responseContentTypeLabel.setText("Response Content Type:");
        this.charsetEncodingCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "utf-8", "iso-8859-1", "utf-16 (le)", "utf-16 (be)", "utf-16 (bom)", "us-ascii"}));
        this.charsetEncodingLabel.setText("Charset Encoding:");
        this.contextPathLabel.setText("Base Context Path:");
        this.contextPathField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HttpListener.this.contextPathFieldKeyReleased(evt);
            }
        });
        this.receiveTimeoutLabel.setText("Receive Timeout (ms):");
        this.httpUrlLabel.setText("HTTP URL:");
        this.headersLabel.setText("Response Headers:");
        this.responseHeadersTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        this.responseHeadersPane.setViewportView((Component)this.responseHeadersTable);
        this.responseHeadersNewButton.setText("New");
        this.responseHeadersNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.responseHeadersNewButtonActionPerformed(evt);
            }
        });
        this.responseHeadersDeleteButton.setText("Delete");
        this.responseHeadersDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.responseHeadersDeleteButtonActionPerformed(evt);
            }
        });
        this.useResponseHeadersTableRadio = new MirthRadioButton("Use Table");
        this.useResponseHeadersTableRadio.setBackground(this.getBackground());
        this.useResponseHeadersTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.useResponseHeadersVariableFieldsEnabled(false);
            }
        });
        this.useResponseHeadersVariableRadio = new MirthRadioButton("Use Map:");
        this.useResponseHeadersVariableRadio.setBackground(this.getBackground());
        this.useResponseHeadersVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.useResponseHeadersVariableFieldsEnabled(true);
            }
        });
        ButtonGroup headersSourceButtonGroup = new ButtonGroup();
        headersSourceButtonGroup.add((AbstractButton)this.useResponseHeadersTableRadio);
        headersSourceButtonGroup.add((AbstractButton)this.useResponseHeadersVariableRadio);
        this.responseHeadersVariableField = new MirthTextField();
        this.responseStatusCodeLabel.setText("Response Status Code:");
        this.messageContentXmlBodyRadio.setBackground(new Color(255, 255, 255));
        this.includeHeadersGroup.add((AbstractButton)this.messageContentXmlBodyRadio);
        this.messageContentXmlBodyRadio.setText("XML Body");
        this.messageContentXmlBodyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.messageContentXmlBodyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.messageContentXmlBodyRadioActionPerformed(evt);
            }
        });
        this.parseMultipartLabel.setText("Parse Multipart:");
        this.parseMultipartYesRadio.setBackground(new Color(255, 255, 255));
        this.parseMultipartButtonGroup.add((AbstractButton)this.parseMultipartYesRadio);
        this.parseMultipartYesRadio.setText("Yes");
        this.parseMultipartYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.parseMultipartNoRadio.setBackground(new Color(255, 255, 255));
        this.parseMultipartButtonGroup.add((AbstractButton)this.parseMultipartNoRadio);
        this.parseMultipartNoRadio.setText("No");
        this.parseMultipartNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.includeMetadataLabel.setText("Include Metadata:");
        this.includeMetadataYesRadio.setBackground(new Color(255, 255, 255));
        this.includeMetadataButtonGroup.add((AbstractButton)this.includeMetadataYesRadio);
        this.includeMetadataYesRadio.setText("Yes");
        this.includeMetadataYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.includeMetadataNoRadio.setBackground(new Color(255, 255, 255));
        this.includeMetadataButtonGroup.add((AbstractButton)this.includeMetadataNoRadio);
        this.includeMetadataNoRadio.setText("No");
        this.includeMetadataNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.staticResourcesLabel.setText("Static Resources:");
        this.staticResourcesDeleteButton.setText("Delete");
        this.staticResourcesDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.staticResourcesDeleteButtonActionPerformed(evt);
            }
        });
        this.staticResourcesNewButton.setText("New");
        this.staticResourcesNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.staticResourcesNewButtonActionPerformed(evt);
            }
        });
        this.staticResourcesTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.responseHeadersPane1.setViewportView((Component)this.staticResourcesTable);
        this.responseDataTypeLabel.setText("Response Data Type:");
        this.responseDataTypeBinaryRadio.setBackground(new Color(255, 255, 255));
        this.responseDataTypeButtonGroup.add((AbstractButton)this.responseDataTypeBinaryRadio);
        this.responseDataTypeBinaryRadio.setText("Binary");
        this.responseDataTypeBinaryRadio.setMargin(new Insets(0, 0, 0, 0));
        this.responseDataTypeBinaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.responseDataTypeBinaryRadioActionPerformed(evt);
            }
        });
        this.responseDataTypeTextRadio.setBackground(new Color(255, 255, 255));
        this.responseDataTypeButtonGroup.add((AbstractButton)this.responseDataTypeTextRadio);
        this.responseDataTypeTextRadio.setText("Text");
        this.responseDataTypeTextRadio.setMargin(new Insets(0, 0, 0, 0));
        this.responseDataTypeTextRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpListener.this.responseDataTypeTextRadioActionPerformed(evt);
            }
        });
        this.binaryMimeTypesLabel.setText("Binary MIME Types:");
        this.binaryMimeTypesField.setMinimumSize(new Dimension(200, 21));
        this.binaryMimeTypesField.setPreferredSize(new Dimension(200, 21));
        this.binaryMimeTypesRegexCheckBox.setBackground(new Color(255, 255, 255));
        this.binaryMimeTypesRegexCheckBox.setText("Regular Expression");
    }

    protected void initToolTips() {
        this.messageContentPlainBodyRadio.setToolTipText("<html>If selected, the request body will be sent to the channel as a raw string.</html>");
        this.responseContentTypeField.setToolTipText("The MIME type to be used for the response.");
        this.charsetEncodingCombobox.setToolTipText("<html>Select the character set encoding to be used for the response to the sending system.<br>Set to Default to assume the default character set encoding for the JVM running BridgeLink.</html>");
        this.contextPathField.setToolTipText("The context path for the HTTP Listener URL.");
        this.receiveTimeoutField.setToolTipText("Enter the maximum idle time in milliseconds for a connection.");
        this.httpUrlField.setToolTipText("<html>Displays the generated HTTP URL for the HTTP Listener.</html>");
        this.responseHeadersTable.setToolTipText("Response header parameters are encoded as HTTP headers in the response sent to the client.");
        this.responseStatusCodeField.setToolTipText("<html>Enter the status code for the HTTP response.  If this field is left blank a <br>default status code of 200 will be returned for a successful message, <br>and 500 will be returned for an errored message. If a \"Respond from\" <br>value is chosen, that response will be used to determine a successful <br>or errored response.<html>");
        this.messageContentXmlBodyRadio.setToolTipText("<html>If selected, the request body will be sent to the channel as serialized XML.</html>");
        this.parseMultipartYesRadio.setToolTipText("<html>Select Yes to automatically parse multipart requests into separate XML nodes.<br/>Select No to always keep the request body as a single XML node.</html>");
        this.parseMultipartNoRadio.setToolTipText("<html>Select Yes to automatically parse multipart requests into separate XML nodes.<br/>Select No to always keep the request body as a single XML node.</html>");
        this.includeMetadataYesRadio.setToolTipText("<html>Select Yes to include request metadata (method, context path, headers,<br/>query parameters) in the XML content. Note that regardless of this<br/>setting, the same metadata is always available in the source map.</html>");
        this.includeMetadataNoRadio.setToolTipText("<html>Select Yes to include request metadata (method, context path, headers,<br/>query parameters) in the XML content. Note that regardless of this<br/>setting, the same metadata is always available in the source map.</html>");
        this.staticResourcesTable.setToolTipText("<html>Values in this table are automatically sent back to any request<br/>with the matching context path. There are three resource types:<br/> - <b>File</b>: The value field specifies the path of the file to return.<br/> - <b>Directory</b>: Any file within the directory given by the value<br/>&nbsp;&nbsp;&nbsp;field may be requested, but subdirectories are not included.<br/> - <b>Custom</b>: The value field itself is returned as the response.<br/></html>");
        this.responseDataTypeBinaryRadio.setToolTipText("<html>If Binary is selected, responses will be decoded from Base64 into raw byte streams.<br/>If Text is selected, responses will be encoded with the specified character set encoding.</html>");
        this.responseDataTypeTextRadio.setToolTipText("<html>If Binary is selected, responses will be decoded from Base64 into raw byte streams.<br/>If Text is selected, responses will be encoded with the specified character set encoding.</html>");
        this.binaryMimeTypesField.setToolTipText("<html>When a response comes in with a Content-Type header that<br/>matches one of these entries, the content will be encoded<br/>into a Base64 string. If Regular Expression is unchecked,<br/>specify multiple entries with commas. Otherwise, enter a<br/>valid regular expression to match MIME types against.</html>");
        this.binaryMimeTypesRegexCheckBox.setToolTipText("<html>When a response comes in with a Content-Type header that<br/>matches one of these entries, the content will be encoded<br/>into a Base64 string. If Regular Expression is unchecked,<br/>specify multiple entries with commas. Otherwise, enter a<br/>valid regular expression to match MIME types against.</html>");
        this.useResponseHeadersTableRadio.setToolTipText("<html>The table below will be used to populate response headers.</html>");
        this.useResponseHeadersVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate response headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.responseHeadersVariableField.setToolTipText("<html>The variable of a Java map to use to populate response headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
    }

    protected void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 8 0 8, novisualpadding, hidemode 3, gap 12 6", "[][]6[]", "[][][][][][][][][][][][][grow][grow]"));
        this.add(this.contextPathLabel, "right");
        this.add((Component)this.contextPathField, "w 150!, sx");
        this.add(this.receiveTimeoutLabel, "newline, right");
        this.add((Component)this.receiveTimeoutField, "w 100!, sx");
        this.add(this.messageContentLabel, "newline, right");
        this.add((Component)this.messageContentPlainBodyRadio, "split 2");
        this.add((Component)this.messageContentXmlBodyRadio);
        this.add(this.parseMultipartLabel, "newline, right");
        this.add((Component)this.parseMultipartYesRadio, "split 2");
        this.add((Component)this.parseMultipartNoRadio);
        this.add(this.includeMetadataLabel, "newline, right");
        this.add((Component)this.includeMetadataYesRadio, "split 2");
        this.add((Component)this.includeMetadataNoRadio);
        this.add(this.binaryMimeTypesLabel, "newline, right");
        this.add((Component)this.binaryMimeTypesField, "w 300!, sx, split 3");
        this.add((Component)this.binaryMimeTypesRegexCheckBox);
        this.add(this.httpUrlLabel, "newline, right");
        this.add(this.httpUrlField, "w 250!, sx");
        this.add(this.responseContentTypeLabel, "newline, right");
        this.add((Component)this.responseContentTypeField, "w 125!, sx");
        this.add(this.responseDataTypeLabel, "newline, right");
        this.add((Component)this.responseDataTypeBinaryRadio, "split 2");
        this.add((Component)this.responseDataTypeTextRadio);
        this.add(this.charsetEncodingLabel, "newline, right");
        this.add((Component)this.charsetEncodingCombobox);
        this.add(this.responseStatusCodeLabel, "newline, right");
        this.add((Component)this.responseStatusCodeField, "w 125!");
        this.add(this.headersLabel, "newline, right");
        this.add((Component)this.useResponseHeadersTableRadio, "split 3");
        this.add((Component)this.useResponseHeadersVariableRadio);
        this.add((Component)this.responseHeadersVariableField, "w 125!, sx");
        this.add(this.responseHeadersPane, "newline, growx, pushx, growy, skip 1, span 2, h 104:104:342");
        this.add(this.responseHeadersNewButton, "top, flowy, split 2, w 44!");
        this.add(this.responseHeadersDeleteButton, "w 44!");
        this.add(this.staticResourcesLabel, "newline, top, right");
        this.add(this.responseHeadersPane1, "growx, pushx, growy, span 2, h 104:104:342");
        this.add(this.staticResourcesNewButton, "top, flowy, split 2, w 44!");
        this.add(this.staticResourcesDeleteButton, "w 44!");
    }

    private void messageContentPlainBodyRadioActionPerformed(ActionEvent evt) {
        this.parent.channelEditPanel.checkAndSetSourceDataType();
        this.parseMultipartLabel.setEnabled(false);
        this.parseMultipartYesRadio.setEnabled(false);
        this.parseMultipartNoRadio.setEnabled(false);
        this.includeMetadataLabel.setEnabled(false);
        this.includeMetadataYesRadio.setEnabled(false);
        this.includeMetadataNoRadio.setEnabled(false);
    }

    private void contextPathFieldKeyReleased(KeyEvent evt) {
        this.updateHttpUrl();
    }

    private void responseHeadersNewButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.responseHeadersTable.getModel()).addRow(new Object[]{this.getNewPropertyName(this.responseHeadersTable), ""});
        this.responseHeadersTable.setRowSelectionInterval(this.responseHeadersTable.getRowCount() - 1, this.responseHeadersTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void responseHeadersDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedRow(this.responseHeadersTable) != -1 && !this.responseHeadersTable.isEditing()) {
            ((DefaultTableModel)this.responseHeadersTable.getModel()).removeRow(this.getSelectedRow(this.responseHeadersTable));
            if (this.responseHeadersTable.getRowCount() != 0) {
                if (this.responseHeadersLastIndex == 0) {
                    this.responseHeadersTable.setRowSelectionInterval(0, 0);
                } else if (this.responseHeadersLastIndex == this.responseHeadersTable.getRowCount()) {
                    this.responseHeadersTable.setRowSelectionInterval(this.responseHeadersLastIndex - 1, this.responseHeadersLastIndex - 1);
                } else {
                    this.responseHeadersTable.setRowSelectionInterval(this.responseHeadersLastIndex, this.responseHeadersLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void messageContentXmlBodyRadioActionPerformed(ActionEvent evt) {
        this.parent.channelEditPanel.checkAndSetSourceDataType();
        this.parseMultipartLabel.setEnabled(true);
        this.parseMultipartYesRadio.setEnabled(true);
        this.parseMultipartNoRadio.setEnabled(true);
        this.includeMetadataLabel.setEnabled(true);
        this.includeMetadataYesRadio.setEnabled(true);
        this.includeMetadataNoRadio.setEnabled(true);
    }

    private void staticResourcesDeleteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.getSelectedRow(this.staticResourcesTable);
        if (selectedRow != -1 && !this.staticResourcesTable.isEditing()) {
            ((DefaultTableModel)this.staticResourcesTable.getModel()).removeRow(selectedRow);
            if (this.staticResourcesTable.getRowCount() != 0) {
                if (this.staticResourcesLastIndex == 0) {
                    this.staticResourcesTable.setRowSelectionInterval(0, 0);
                } else if (this.staticResourcesLastIndex == this.staticResourcesTable.getRowCount()) {
                    this.staticResourcesTable.setRowSelectionInterval(this.staticResourcesLastIndex - 1, this.staticResourcesLastIndex - 1);
                } else {
                    this.staticResourcesTable.setRowSelectionInterval(this.staticResourcesLastIndex, this.staticResourcesLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void staticResourcesNewButtonActionPerformed(ActionEvent evt) {
        int contextPathNumber = 1;
        String contextPath = "path" + contextPathNumber;
        while (!this.checkStaticResourceContextPath(contextPath)) {
            contextPath = "path" + ++contextPathNumber;
        }
        Object[] rowData = new Object[]{contextPath, HttpStaticResource.ResourceType.FILE.toString(), "", ContentType.TEXT_PLAIN.getMimeType()};
        ((DefaultTableModel)this.staticResourcesTable.getModel()).addRow(rowData);
        this.staticResourcesTable.setRowSelectionInterval(this.staticResourcesTable.getRowCount() - 1, this.staticResourcesTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void responseDataTypeBinaryRadioActionPerformed(ActionEvent evt) {
        this.charsetEncodingLabel.setEnabled(false);
        this.charsetEncodingCombobox.setEnabled(false);
        this.charsetEncodingCombobox.setSelectedIndex(0);
    }

    private void responseDataTypeTextRadioActionPerformed(ActionEvent evt) {
        this.charsetEncodingLabel.setEnabled(true);
        this.charsetEncodingCombobox.setEnabled(true);
    }

    private void useResponseHeadersVariableFieldsEnabled(boolean useTemplate) {
        this.responseHeadersVariableField.setEnabled(useTemplate);
        this.responseHeadersTable.setEnabled(!useTemplate);
        this.responseHeadersNewButton.setEnabled(!useTemplate);
        this.responseHeadersDeleteButton.setEnabled(!useTemplate && this.responseHeadersTable.getSelectedRow() > -1);
    }

    private static enum StaticResourcesColumn {
        CONTEXT_PATH(0, "Context Path"),
        RESOURCE_TYPE(1, "Resource Type"),
        VALUE(2, "Value"),
        CONTENT_TYPE(3, "Content Type");

        private int index;
        private String name;

        private StaticResourcesColumn(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static String[] getNames() {
            StaticResourcesColumn[] values = StaticResourcesColumn.values();
            String[] names = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                names[i] = values[i].getName();
            }
            return names;
        }
    }
}

