/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.smtp;

import com.mirth.connect.connectors.smtp.SmtpConfiguration;
import com.mirth.connect.connectors.smtp.SmtpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.util.MirthSSLUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;

public class DefaultSmtpConfiguration
implements SmtpConfiguration {
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private String protocols;
    private String cipherSuites;

    @Override
    public void configureConnectorDeploy(Connector connector) {
        this.protocols = StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsProtocols((String[])this.configurationController.getHttpsClientProtocols()), (char)' ');
        this.cipherSuites = StringUtils.join((Object[])MirthSSLUtil.getEnabledHttpsCipherSuites((String[])this.configurationController.getHttpsCipherSuites()), (char)' ');
    }

    @Override
    public void configureEncryption(ConnectorProperties connectorProperties, Email email) throws Exception {
        SmtpDispatcherProperties props = (SmtpDispatcherProperties)connectorProperties;
        if ("SSL".equalsIgnoreCase(props.getEncryption())) {
            email.setSSLOnConnect(true);
            email.setSslSmtpPort(props.getSmtpPort());
        } else if ("TLS".equalsIgnoreCase(props.getEncryption())) {
            email.setStartTLSEnabled(true);
        }
    }

    @Override
    public void configureMailProperties(Properties mailProperties) {
        mailProperties.setProperty("mail.smtp.ssl.protocols", this.protocols);
        mailProperties.setProperty("mail.smtp.ssl.ciphersuites", this.cipherSuites);
    }
}

