/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.smtp;

import com.mirth.connect.connectors.smtp.Attachment;
import com.mirth.connect.connectors.smtp.DefaultSmtpConfiguration;
import com.mirth.connect.connectors.smtp.SmtpConfiguration;
import com.mirth.connect.connectors.smtp.SmtpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.userutil.AttachmentEntry;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmtpDispatcher
extends DestinationConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private SmtpConfiguration configuration = null;
    private String charsetEncoding;

    public void onDeploy() throws ConnectorTaskException {
        String configurationClass = this.configurationController.getProperty(this.getConnectorProperties().getProtocol(), "smtpConfigurationClass");
        try {
            this.configuration = (SmtpConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Throwable t) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultSmtpConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.charsetEncoding = CharsetUtils.getEncoding((String)this.getConnectorProperties().getCharsetEncoding(), (String)System.getProperty("ca.uhn.hl7v2.llp.charset"));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
    }

    public void onHalt() throws ConnectorTaskException {
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        SmtpDispatcherProperties smtpDispatcherProperties = (SmtpDispatcherProperties)connectorProperties;
        smtpDispatcherProperties.setSmtpHost(this.replacer.replaceValues(smtpDispatcherProperties.getSmtpHost(), connectorMessage));
        smtpDispatcherProperties.setSmtpPort(this.replacer.replaceValues(smtpDispatcherProperties.getSmtpPort(), connectorMessage));
        smtpDispatcherProperties.setLocalAddress(this.replacer.replaceValues(smtpDispatcherProperties.getLocalAddress(), connectorMessage));
        smtpDispatcherProperties.setLocalPort(this.replacer.replaceValues(smtpDispatcherProperties.getLocalPort(), connectorMessage));
        smtpDispatcherProperties.setTimeout(this.replacer.replaceValues(smtpDispatcherProperties.getTimeout(), connectorMessage));
        if (smtpDispatcherProperties.isAuthentication()) {
            smtpDispatcherProperties.setUsername(this.replacer.replaceValues(smtpDispatcherProperties.getUsername(), connectorMessage));
            smtpDispatcherProperties.setPassword(this.replacer.replaceValues(smtpDispatcherProperties.getPassword(), connectorMessage));
        }
        smtpDispatcherProperties.setTo(this.replacer.replaceValues(smtpDispatcherProperties.getTo(), connectorMessage));
        smtpDispatcherProperties.setCc(this.replacer.replaceValues(smtpDispatcherProperties.getCc(), connectorMessage));
        smtpDispatcherProperties.setBcc(this.replacer.replaceValues(smtpDispatcherProperties.getBcc(), connectorMessage));
        smtpDispatcherProperties.setReplyTo(this.replacer.replaceValues(smtpDispatcherProperties.getReplyTo(), connectorMessage));
        smtpDispatcherProperties.setHeadersMap(this.replacer.replaceValuesInMap(smtpDispatcherProperties.getHeadersMap(), connectorMessage));
        smtpDispatcherProperties.setHeadersVariable(this.replacer.replaceValues(smtpDispatcherProperties.getHeadersVariable(), connectorMessage));
        smtpDispatcherProperties.setFrom(this.replacer.replaceValues(smtpDispatcherProperties.getFrom(), connectorMessage));
        smtpDispatcherProperties.setSubject(this.replacer.replaceValues(smtpDispatcherProperties.getSubject(), connectorMessage));
        smtpDispatcherProperties.setBody(this.replacer.replaceValues(smtpDispatcherProperties.getBody(), connectorMessage));
        for (Attachment attachment : smtpDispatcherProperties.getAttachmentsList()) {
            attachment.setName(this.replacer.replaceValues(attachment.getName(), connectorMessage));
            attachment.setMimeType(this.replacer.replaceValues(attachment.getMimeType(), connectorMessage));
            attachment.setContent(this.replacer.replaceValues(attachment.getContent(), connectorMessage));
        }
        smtpDispatcherProperties.setAttachmentsVariable(this.replacer.replaceValues(smtpDispatcherProperties.getAttachmentsVariable(), connectorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        SmtpDispatcherProperties smtpDispatcherProperties = (SmtpDispatcherProperties)connectorProperties;
        String responseData = null;
        String responseError = null;
        String responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        String info = "From: " + smtpDispatcherProperties.getFrom() + " To: " + smtpDispatcherProperties.getTo() + " SMTP Info: " + smtpDispatcherProperties.getSmtpHost() + ":" + smtpDispatcherProperties.getSmtpPort();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WRITING, info));
        try {
            Object email = null;
            email = smtpDispatcherProperties.isHtml() ? new HtmlEmail() : new MultiPartEmail();
            email.setCharset(this.charsetEncoding);
            email.setHostName(smtpDispatcherProperties.getSmtpHost());
            try {
                email.setSmtpPort(Integer.parseInt(smtpDispatcherProperties.getSmtpPort()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int timeout = Integer.parseInt(smtpDispatcherProperties.getTimeout());
                email.setSocketTimeout(timeout);
                email.setSocketConnectionTimeout(timeout);
            }
            catch (NumberFormatException timeout) {
                // empty catch block
            }
            this.configuration.configureEncryption(connectorProperties, (Email)email);
            if (smtpDispatcherProperties.isAuthentication()) {
                email.setAuthentication(smtpDispatcherProperties.getUsername(), smtpDispatcherProperties.getPassword());
            }
            Properties mailProperties = email.getMailSession().getProperties();
            this.configuration.configureMailProperties(mailProperties);
            if (smtpDispatcherProperties.isOverrideLocalBinding()) {
                mailProperties.setProperty("mail.smtp.localaddress", smtpDispatcherProperties.getLocalAddress());
                mailProperties.setProperty("mail.smtp.localport", smtpDispatcherProperties.getLocalPort());
            }
            for (String to : StringUtils.split((String)smtpDispatcherProperties.getTo(), (String)",")) {
                email.addTo(to);
            }
            for (String cc : StringUtils.split((String)smtpDispatcherProperties.getCc(), (String)",")) {
                email.addCc(cc);
            }
            for (String bcc : StringUtils.split((String)smtpDispatcherProperties.getBcc(), (String)",")) {
                email.addBcc(bcc);
            }
            for (String replyTo : StringUtils.split((String)smtpDispatcherProperties.getReplyTo(), (String)",")) {
                email.addReplyTo(replyTo);
            }
            Map<String, String> headers = this.getHeaders(smtpDispatcherProperties, connectorMessage);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                email.addHeader(header.getKey(), header.getValue());
            }
            email.setFrom(smtpDispatcherProperties.getFrom());
            email.setSubject(smtpDispatcherProperties.getSubject());
            AttachmentHandlerProvider attachmentHandlerProvider = this.getAttachmentHandlerProvider();
            String body = attachmentHandlerProvider.reAttachMessage(smtpDispatcherProperties.getBody(), connectorMessage, smtpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
            if (StringUtils.isNotEmpty((CharSequence)body)) {
                if (smtpDispatcherProperties.isHtml()) {
                    email.setHtmlMsg(body);
                } else {
                    email.setMsg(body);
                }
            }
            List<Attachment> attachmentSource = this.getAttachments(smtpDispatcherProperties, connectorMessage);
            for (Attachment attachment : attachmentSource) {
                byte[] bytes;
                String name = attachment.getName();
                String mimeType = attachment.getMimeType();
                String content = attachment.getContent();
                if (StringUtils.indexOf((CharSequence)mimeType, (CharSequence)"/") < 0) {
                    this.logger.warn("valid MIME type is missing for email attachment: \"" + name + "\", using default of text/plain");
                    attachment.setMimeType("text/plain");
                    bytes = attachmentHandlerProvider.reAttachMessage(content, connectorMessage, this.charsetEncoding, false, smtpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
                } else if ("application/xml".equalsIgnoreCase(mimeType) || StringUtils.startsWith((CharSequence)mimeType, (CharSequence)"text/")) {
                    this.logger.debug("text or XML MIME type detected for attachment \"" + name + "\"");
                    bytes = attachmentHandlerProvider.reAttachMessage(content, connectorMessage, this.charsetEncoding, false, smtpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
                } else {
                    this.logger.debug("binary MIME type detected for attachment \"" + name + "\", performing Base64 decoding");
                    bytes = attachmentHandlerProvider.reAttachMessage(content, connectorMessage, null, true, smtpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
                }
                ((MultiPartEmail)email).attach((DataSource)new ByteArrayDataSource(bytes, mimeType), name, null);
            }
            responseData = email.send();
            responseStatus = Status.SENT;
            responseStatusMessage = "Email sent successfully.";
        }
        catch (Exception e) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error sending email message", (Throwable)e));
            responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error sending email message", (Throwable)e);
            responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error sending email message", (Throwable)e);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        return new Response(responseStatus, responseData, responseStatusMessage, responseError);
    }

    Map<String, String> getHeaders(SmtpDispatcherProperties smtpDispatcherProperties, ConnectorMessage connectorMessage) {
        HashMap<String, String> headers;
        block6: {
            if (smtpDispatcherProperties.isUseHeadersVariable()) {
                headers = new HashMap<String, String>();
                try {
                    Map source = (Map)this.getMessageMaps().get(smtpDispatcherProperties.getHeadersVariable(), connectorMessage);
                    if (source != null) {
                        for (Map.Entry entry : source.entrySet()) {
                            headers.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                        }
                        break block6;
                    }
                    this.logger.trace("Headers map variable '" + smtpDispatcherProperties.getHeadersVariable() + "' not found.");
                }
                catch (Exception e) {
                    this.logger.warn("Error getting headers from map " + smtpDispatcherProperties.getHeadersVariable(), (Throwable)e);
                }
            } else {
                headers = smtpDispatcherProperties.getHeadersMap();
            }
        }
        return headers;
    }

    List<Attachment> getAttachments(SmtpDispatcherProperties smtpDispatcherProperties, ConnectorMessage connectorMessage) {
        ArrayList<Attachment> attachmentSource;
        block7: {
            if (smtpDispatcherProperties.isUseAttachmentsVariable()) {
                attachmentSource = new ArrayList<Attachment>();
                try {
                    List source = (List)this.getMessageMaps().get(smtpDispatcherProperties.getAttachmentsVariable(), connectorMessage);
                    if (source != null) {
                        for (Object entry : source) {
                            if (entry instanceof AttachmentEntry) {
                                Attachment att = new Attachment();
                                att.setName(((AttachmentEntry)entry).getName());
                                att.setContent(((AttachmentEntry)entry).getContent());
                                att.setMimeType(((AttachmentEntry)entry).getMimeType());
                                attachmentSource.add(att);
                                continue;
                            }
                            this.logger.trace("Error getting AttachmentEntry from map '" + smtpDispatcherProperties.getAttachmentsVariable() + "'. Skipping entry.");
                        }
                        break block7;
                    }
                    this.logger.warn("Attachments list variable '" + smtpDispatcherProperties.getAttachmentsVariable() + "' not found.");
                }
                catch (Exception e) {
                    this.logger.warn("Error getting attachments from map " + smtpDispatcherProperties.getAttachmentsVariable(), (Throwable)e);
                }
            } else {
                attachmentSource = smtpDispatcherProperties.getAttachmentsList();
            }
        }
        return attachmentSource;
    }

    public SmtpDispatcherProperties getConnectorProperties() {
        return (SmtpDispatcherProperties)super.getConnectorProperties();
    }
}

