/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.connectors.ws.DefinitionServiceMap;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.util.ConnectionTestResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/connectors/ws")
@Tag(name="Connector Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface WebServiceConnectorServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "Web Service Connector Service";

    @POST
    @Path(value="/_cacheWsdlFromUrl")
    @Operation(summary="Downloads the WSDL at the specified URL and caches the web service definition tree.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="cache_wsdl_from_url", ref="../apiexamples/null_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="cache_wsdl_from_url", ref="../apiexamples/null_json")})})
    @MirthOperation(name="cacheWsdlFromUrl", display="Download and cache WSDL", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Object cacheWsdlFromUrl(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @QueryParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.") @QueryParam(value="channelName") String var2, @Param(value="properties") @RequestBody(description="The Web Service Sender properties to use. These properties can be found in the exported channel's XML file. Copy the data from the opening tag &lt;destinationConnectorProperties&gt; to the closing tag &lt;/wsdlDefinitionMap&gt; (including the tags). Paste over the information below between the opening and closing tags for &lt;com.mirth.connect.connectors.ws.WebServiceDispatcherProperties&gt;.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="ws_dispatcher_properties", ref="../apiexamples/ws_dispatcher_properties_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="ws_dispatcher_properties", ref="../apiexamples/ws_dispatcher_properties_json")})}) WebServiceDispatcherProperties var3) throws ClientException;

    @POST
    @Path(value="/_isWsdlCached")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Returns true if the definition tree for the WSDL is cached by the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="is_wsdl_cached", ref="../apiexamples/boolean_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="is_wsdl_cached", ref="../apiexamples/boolean_json")})})
    @MirthOperation(name="isWsdlCached", display="Check if WSDL is cached", type=Operation.ExecuteType.ASYNC, auditable=false)
    public boolean isWsdlCached(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true, schema=@Schema(description="The ID of the channel.")) @FormParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.", schema=@Schema(description="The name of the channel.")) @FormParam(value="channelName") String var2, @Param(value="wsdlUrl") @Parameter(description="The full URL to the WSDL describing the web service method to be called.", required=true, schema=@Schema(description="The full URL to the WSDL describing the web service method to be called.")) @FormParam(value="wsdlUrl") String var3, @Param(value="username") @Parameter(description="Username used to authenticate to the web server.", schema=@Schema(description="Username used to authenticate to the web server.")) @FormParam(value="username") String var4, @Param(value="password", excludeFromAudit=true) @Parameter(description="Password used to authenticate to the web server.", schema=@Schema(description="Password used to authenticate to the web server.")) @FormParam(value="password") String var5) throws ClientException;

    @POST
    @Path(value="/_getDefinition")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Retrieves the definition service map corresponding to the specified WSDL.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="definition_service_map", ref="../apiexamples/definition_service_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="definition_service_map", ref="../apiexamples/definition_service_map_json")})})
    @MirthOperation(name="getDefinition", display="Get WSDL Definition", type=Operation.ExecuteType.ASYNC, auditable=false)
    public DefinitionServiceMap getDefinition(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true, schema=@Schema(description="The ID of the channel.")) @FormParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.", schema=@Schema(description="The name of the channel.")) @FormParam(value="channelName") String var2, @Param(value="wsdlUrl") @Parameter(description="The full URL to the WSDL describing the web service method to be called.", required=true, schema=@Schema(description="The full URL to the WSDL describing the web service method to be called.")) @FormParam(value="wsdlUrl") String var3, @Param(value="username") @Parameter(description="Username used to authenticate to the web server.", schema=@Schema(description="Username used to authenticate to the web server.")) @FormParam(value="username") String var4, @Param(value="password", excludeFromAudit=true) @Parameter(description="Password used to authenticate to the web server.", schema=@Schema(description="Password used to authenticate to the web server.")) @FormParam(value="password") String var5) throws ClientException;

    @POST
    @Path(value="/_generateEnvelope")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Operation(summary="Generate SOAP envelope for a given WSDL operation.")
    @ApiResponse(content={@Content(mediaType="text/plain", examples={@ExampleObject(name="generate_envelope", ref="../apiexamples/generate_envelope_txt")})})
    @MirthOperation(name="generateEnvelope", display="Generate WSDL operation envelope", type=Operation.ExecuteType.ASYNC, auditable=false)
    public String generateEnvelope(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true, schema=@Schema(description="The ID of the channel.")) @FormParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.", schema=@Schema(description="The name of the channel.")) @FormParam(value="channelName") String var2, @Param(value="wsdlUrl") @Parameter(description="The full URL to the WSDL describing the web service method to be called.", required=true, schema=@Schema(description="The full URL to the WSDL describing the web service method to be called.")) @FormParam(value="wsdlUrl") String var3, @Param(value="username") @Parameter(description="Username used to authenticate to the web server.", schema=@Schema(description="Username used to authenticate to the web server.")) @FormParam(value="username") String var4, @Param(value="password", excludeFromAudit=true) @Parameter(description="Password used to authenticate to the web server.", schema=@Schema(description="Password used to authenticate to the web server.")) @FormParam(value="password") String var5, @Param(value="service") @Parameter(description="The service name for the WSDL defined above.", required=true, schema=@Schema(description="The service name for the WSDL defined above.")) @FormParam(value="service") String var6, @Param(value="port") @Parameter(description="The port / endpoint name for the service defined above.", required=true, schema=@Schema(description="The port / endpoint name for the service defined above.")) @FormParam(value="port") String var7, @Param(value="operation") @Parameter(description="The name of the operation. This is a method provided by the web service.", required=true, schema=@Schema(description="The name of the operation. This is a method provided by the web service")) @FormParam(value="operation") String var8, @Param(value="buildOptional") @Parameter(description="Whether to include optional fields in the envelope.", schema=@Schema(description="Whether to include optional fields in the envelope.")) @FormParam(value="buildOptional") boolean var9) throws ClientException;

    @POST
    @Path(value="/_getSoapAction")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Operation(summary="Retrieves the default SOAP Action (URI string) for a given WSDL operation.")
    @ApiResponse(content={@Content(mediaType="text/plain", examples={@ExampleObject(value="SomeAction")})})
    @MirthOperation(name="getSoapAction", display="Get SOAP Action for operation", type=Operation.ExecuteType.ASYNC, auditable=false)
    public String getSoapAction(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true, schema=@Schema(description="The ID of the channel.")) @FormParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.", schema=@Schema(description="The name of the channel.")) @FormParam(value="channelName") String var2, @Param(value="wsdlUrl") @Parameter(description="The full URL to the WSDL describing the web service method to be called.", required=true, schema=@Schema(description="The full URL to the WSDL describing the web service method to be called.")) @FormParam(value="wsdlUrl") String var3, @Param(value="username") @Parameter(description="Username used to authenticate to the web server.", schema=@Schema(description="Username used to authenticate to the web server.")) @FormParam(value="username") String var4, @Param(value="password", excludeFromAudit=true) @Parameter(description="Password used to authenticate to the web server.", schema=@Schema(description="Password used to authenticate to the web server.")) @FormParam(value="password") String var5, @Param(value="service") @Parameter(description="The service name for the WSDL defined above.", required=true, schema=@Schema(description="The service name for the WSDL defined above.")) @FormParam(value="service") String var6, @Param(value="port") @Parameter(description="The port / endpoint name for the service defined above.", required=true, schema=@Schema(description="The port / endpoint name for the service defined above.")) @FormParam(value="port") String var7, @Param(value="operation") @Parameter(description="The name of the operation. This is a method provided by the web service.", required=true, schema=@Schema(description="The name of the operation. This is a method provided by the web service.")) @FormParam(value="operation") String var8) throws ClientException;

    @POST
    @Path(value="/_testConnection")
    @Operation(summary="Tests whether a connection can be successfully established to the destination endpoint.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connection_test_response_ws", ref="../apiexamples/connection_test_response_ws_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connection_test_response_ws", ref="../apiexamples/connection_test_response_ws_json")})})
    @MirthOperation(name="testConnection", display="Test Web Service Connection", type=Operation.ExecuteType.ASYNC, auditable=false)
    public ConnectionTestResponse testConnection(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @QueryParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.") @QueryParam(value="channelName") String var2, @Param(value="properties") @RequestBody(description="The Web Service Sender properties to use. These properties can be found in the exported channel's XML file. Copy the data from the opening tag &lt;destinationConnectorProperties&gt; to the closing tag &lt;/wsdlDefinitionMap&gt; (including the tags). Paste over the information below between the opening and closing tags for &lt;com.mirth.connect.connectors.ws.WebServiceDispatcherProperties&gt;.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="ws_dispatcher_properties", ref="../apiexamples/ws_dispatcher_properties_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="ws_dispatcher_properties", ref="../apiexamples/ws_dispatcher_properties_json")})}) WebServiceDispatcherProperties var3) throws ClientException;
}

