/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.connectors.http.BinaryContentTypeResolver;
import com.mirth.connect.connectors.http.DefaultHttpConfiguration;
import com.mirth.connect.connectors.http.HttpConfiguration;
import com.mirth.connect.connectors.http.HttpDispatcherProperties;
import com.mirth.connect.connectors.http.HttpMessageConverter;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.userutil.MessageHeaders;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.HttpUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpDispatcher
extends DestinationConnector {
    private static final String PROXY_CONTEXT_KEY = "dispatcherProxy";
    private static final Pattern AUTH_HEADER_PATTERN = Pattern.compile("([^\\s=,]+)\\s*=\\s*([^=,;\"\\s]+|\"([^\"]|\\\\[\\s\\S])*(?<!\\\\)\")");
    private static final int MAX_MAP_SIZE = 100;
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    protected EventController eventController = ControllerFactory.getFactory().createEventController();
    protected TemplateValueReplacer replacer = new TemplateValueReplacer();
    private Map<Long, CloseableHttpClient> clients = new ConcurrentHashMap<Long, CloseableHttpClient>();
    private Map<Long, Object> userTokens = new ConcurrentHashMap<Long, Object>();
    private HttpConfiguration configuration;
    private RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistry;
    private Map<String, String[]> binaryMimeTypesArrayMap;
    private Map<String, Pattern> binaryMimeTypesRegexMap;

    public void onDeploy() throws ConnectorTaskException {
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (HttpConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultHttpConfiguration();
        }
        try {
            this.socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        if (this.getConnectorProperties().isResponseBinaryMimeTypesRegex()) {
            this.binaryMimeTypesRegexMap = new ConcurrentHashMap<String, Pattern>();
        } else {
            this.binaryMimeTypesArrayMap = new ConcurrentHashMap<String, String[]>();
        }
    }

    public void onUndeploy() throws ConnectorTaskException {
        this.configuration.configureConnectorUndeploy((Connector)this);
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
        for (CloseableHttpClient client : this.clients.values().toArray(new CloseableHttpClient[this.clients.size()])) {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        this.clients.clear();
        this.userTokens.clear();
    }

    public void onHalt() throws ConnectorTaskException {
        for (CloseableHttpClient client : this.clients.values().toArray(new CloseableHttpClient[this.clients.size()])) {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        this.clients.clear();
        this.userTokens.clear();
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        HttpDispatcherProperties httpDispatcherProperties = (HttpDispatcherProperties)connectorProperties;
        httpDispatcherProperties.setHost(this.replacer.replaceValues(httpDispatcherProperties.getHost(), connectorMessage));
        httpDispatcherProperties.setProxyAddress(this.replacer.replaceValues(httpDispatcherProperties.getProxyAddress(), connectorMessage));
        httpDispatcherProperties.setProxyPort(this.replacer.replaceValues(httpDispatcherProperties.getProxyPort(), connectorMessage));
        httpDispatcherProperties.setResponseBinaryMimeTypes(this.replacer.replaceValues(httpDispatcherProperties.getResponseBinaryMimeTypes(), connectorMessage));
        httpDispatcherProperties.setHeadersMap(this.replacer.replaceKeysAndValuesInMap(httpDispatcherProperties.getHeadersMap(), connectorMessage));
        httpDispatcherProperties.setHeadersVariable(this.replacer.replaceValues(httpDispatcherProperties.getHeadersVariable(), connectorMessage));
        httpDispatcherProperties.setParametersMap(this.replacer.replaceKeysAndValuesInMap(httpDispatcherProperties.getParametersMap(), connectorMessage));
        httpDispatcherProperties.setParametersVariable(this.replacer.replaceValues(httpDispatcherProperties.getParametersVariable(), connectorMessage));
        httpDispatcherProperties.setUsername(this.replacer.replaceValues(httpDispatcherProperties.getUsername(), connectorMessage));
        httpDispatcherProperties.setPassword(this.replacer.replaceValues(httpDispatcherProperties.getPassword(), connectorMessage));
        httpDispatcherProperties.setContent(this.replacer.replaceValues(httpDispatcherProperties.getContent(), connectorMessage));
        httpDispatcherProperties.setContentType(this.replacer.replaceValues(httpDispatcherProperties.getContentType(), connectorMessage));
        httpDispatcherProperties.setSocketTimeout(this.replacer.replaceValues(httpDispatcherProperties.getSocketTimeout(), connectorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        HttpDispatcherProperties httpDispatcherProperties = (HttpDispatcherProperties)connectorProperties;
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WRITING));
        Object responseData = null;
        String responseError = null;
        String responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        boolean validateResponse = false;
        CloseableHttpClient client = null;
        HttpRequestBase httpMethod = null;
        CloseableHttpResponse httpResponse = null;
        File tempFile = null;
        int socketTimeout = NumberUtils.toInt((String)httpDispatcherProperties.getSocketTimeout(), (int)30000);
        long dispatcherId = connectorMessage.getDispatcherId();
        try {
            this.configuration.configureDispatcher(this, httpDispatcherProperties);
            client = this.clients.get(dispatcherId);
            if (client == null) {
                BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)this.socketFactoryRegistry.build());
                httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(socketTimeout).build());
                HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
                HttpUtil.configureClientBuilder((HttpClientBuilder)clientBuilder);
                if (httpDispatcherProperties.isUseProxyServer()) {
                    clientBuilder.setRoutePlanner((HttpRoutePlanner)new DynamicProxyRoutePlanner());
                }
                client = clientBuilder.build();
                this.clients.put(dispatcherId, client);
            }
            URI hostURI = new URI(httpDispatcherProperties.getHost());
            String host = hostURI.getHost();
            String scheme = hostURI.getScheme();
            int port = hostURI.getPort();
            if (port == -1) {
                port = scheme.equalsIgnoreCase("https") ? 443 : 80;
            }
            ContentType contentType = ContentType.parse((String)httpDispatcherProperties.getContentType());
            Charset charset = null;
            if (contentType.getCharset() != null) {
                charset = contentType.getCharset();
            } else if (!StringUtils.equalsIgnoreCase((CharSequence)httpDispatcherProperties.getCharset(), (CharSequence)"NONE")) {
                charset = Charset.forName(CharsetUtils.getEncoding((String)httpDispatcherProperties.getCharset()));
            }
            if (httpDispatcherProperties.isMultipart()) {
                tempFile = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
            }
            HttpHost target = new HttpHost(host, port, scheme);
            httpMethod = this.buildHttpRequest(hostURI, httpDispatcherProperties, connectorMessage, tempFile, contentType, charset);
            HttpClientContext context = HttpClientContext.create();
            if (httpDispatcherProperties.isUseAuthentication()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(httpDispatcherProperties.getUsername(), httpDispatcherProperties.getPassword());
                credsProvider.setCredentials(authScope, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                RegistryBuilder registryBuilder = RegistryBuilder.create();
                if ("Digest".equalsIgnoreCase(httpDispatcherProperties.getAuthenticationType())) {
                    this.logger.debug("using Digest authentication");
                    registryBuilder.register("Digest", (Object)new DigestSchemeFactory(charset));
                    if (httpDispatcherProperties.isUsePreemptiveAuthentication()) {
                        this.processDigestChallenge((AuthCache)authCache, target, (Credentials)credentials, (HttpRequest)httpMethod, (HttpContext)context);
                    }
                } else {
                    this.logger.debug("using Basic authentication");
                    registryBuilder.register("Basic", (Object)new BasicSchemeFactory(charset));
                    if (httpDispatcherProperties.isUsePreemptiveAuthentication()) {
                        authCache.put(target, (AuthScheme)new BasicScheme());
                    }
                }
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
                context.setAuthSchemeRegistry((Lookup)registryBuilder.build());
                context.setAuthCache((AuthCache)authCache);
                this.logger.debug("using authentication with credentials: " + String.valueOf(credentials));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(socketTimeout).setSocketTimeout(socketTimeout).setStaleConnectionCheckEnabled(true).build();
            context.setRequestConfig(requestConfig);
            if (httpDispatcherProperties.isUseProxyServer()) {
                context.setAttribute(PROXY_CONTEXT_KEY, (Object)new HttpHost(httpDispatcherProperties.getProxyAddress(), Integer.parseInt(httpDispatcherProperties.getProxyPort())));
            }
            Object userToken = this.userTokens.get(dispatcherId);
            this.logger.debug("cached user token: " + String.valueOf(userToken));
            if (userToken != null) {
                context.setUserToken(userToken);
            }
            this.logger.debug("executing method: type=" + httpMethod.getMethod() + ", uri=" + httpMethod.getURI().toString());
            httpResponse = client.execute(target, (HttpRequest)httpMethod, (HttpContext)context);
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            this.logger.debug("received status code: " + statusCode);
            userToken = context.getUserToken();
            this.logger.debug("updating user token to: " + String.valueOf(userToken));
            if (userToken != null) {
                this.userTokens.put(dispatcherId, userToken);
            } else {
                this.userTokens.remove(dispatcherId);
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (Header header : httpResponse.getAllHeaders()) {
                ArrayList<String> list = (ArrayList<String>)headers.get(header.getName());
                if (list == null) {
                    list = new ArrayList<String>();
                    headers.put(header.getName(), list);
                }
                list.add(header.getValue());
            }
            connectorMessage.getConnectorMap().put("responseStatusCode", statusCode);
            connectorMessage.getConnectorMap().put("responseStatusLine", statusLine.toString());
            connectorMessage.getConnectorMap().put("responseHeaders", new MessageHeaders((Map)new CaseInsensitiveMap(headers)));
            ContentType responseContentType = ContentType.get((HttpEntity)httpResponse.getEntity());
            if (responseContentType == null) {
                responseContentType = ContentType.TEXT_PLAIN;
            }
            Charset responseCharset = charset;
            if (responseContentType.getCharset() != null) {
                responseCharset = responseContentType.getCharset();
            }
            final String responseBinaryMimeTypes = httpDispatcherProperties.getResponseBinaryMimeTypes();
            BinaryContentTypeResolver binaryContentTypeResolver = new BinaryContentTypeResolver(){

                @Override
                public boolean isBinaryContentType(ContentType contentType) {
                    return HttpDispatcher.this.isBinaryContentType(responseBinaryMimeTypes, contentType);
                }
            };
            Object responseBody = "";
            if (httpResponse.getEntity() != null) {
                responseBody = this.shouldParseMultipart(httpDispatcherProperties, responseContentType.getMimeType()) ? new MimeMultipart((DataSource)new ByteArrayDataSource(httpResponse.getEntity().getContent(), responseContentType.toString())) : (binaryContentTypeResolver.isBinaryContentType(responseContentType) ? (Object)IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent()) : IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)responseCharset));
            }
            responseData = httpDispatcherProperties.isResponseXmlBody() ? HttpMessageConverter.httpResponseToXml(statusLine.toString(), headers, responseBody, responseContentType, httpDispatcherProperties.isResponseParseMultipart(), httpDispatcherProperties.isResponseIncludeMetadata(), binaryContentTypeResolver) : (responseBody instanceof byte[] ? new String(Base64Util.encodeBase64((byte[])((byte[])responseBody)), "US-ASCII") : responseBody);
            validateResponse = httpDispatcherProperties.getDestinationConnectorProperties().isValidateResponse();
            if (statusCode < 400) {
                responseStatus = Status.SENT;
            } else {
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Received error response from HTTP server.", null));
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Received error response from HTTP server.", null);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)responseData, null);
            }
        }
        catch (Throwable t) {
            try {
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error connecting to HTTP server.", t));
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error connecting to HTTP server", (Throwable)t);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error connecting to HTTP server", (Throwable)t);
                if (!(t instanceof Error)) {
                    if (!(t instanceof IllegalStateException)) return new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
                }
                HttpUtil.closeVeryQuietly(httpResponse);
                HttpClientUtils.closeQuietly((HttpClient)client);
                this.clients.remove(dispatcherId);
                this.userTokens.remove(dispatcherId);
                return new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    HttpUtil.closeVeryQuietly(httpResponse);
                    if (tempFile != null) {
                        tempFile.delete();
                        tempFile = null;
                    }
                }
                finally {
                    this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
                }
            }
        }
        try {
            HttpUtil.closeVeryQuietly((CloseableHttpResponse)httpResponse);
            if (tempFile == null) return new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
            tempFile.delete();
            tempFile = null;
            return new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
    }

    protected boolean shouldParseMultipart(HttpDispatcherProperties httpDispatcherProperties, String mimeType) {
        return httpDispatcherProperties.isResponseXmlBody() && httpDispatcherProperties.isResponseParseMultipart() && mimeType.startsWith("multipart/");
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.getConnectorProperties().getProtocol(), "httpConfigurationClass");
    }

    public RegistryBuilder<ConnectionSocketFactory> getSocketFactoryRegistry() {
        return this.socketFactoryRegistry;
    }

    private HttpRequestBase buildHttpRequest(URI hostURI, HttpDispatcherProperties httpDispatcherProperties, ConnectorMessage connectorMessage, File tempFile, ContentType contentType, Charset charset) throws Exception {
        String method = httpDispatcherProperties.getMethod();
        boolean isMultipart = httpDispatcherProperties.isMultipart();
        Map<String, List<String>> headers = this.getHeaders(httpDispatcherProperties, connectorMessage);
        Map<String, List<String>> parameters = this.getParameters(httpDispatcherProperties, connectorMessage);
        Object content = null;
        if (httpDispatcherProperties.isDataTypeBinary()) {
            content = this.getAttachmentHandlerProvider().reAttachMessage(httpDispatcherProperties.getContent(), connectorMessage, null, true, httpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
        } else {
            content = this.getAttachmentHandlerProvider().reAttachMessage(httpDispatcherProperties.getContent(), connectorMessage, httpDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
            if (contentType.getCharset() == null && charset != null) {
                contentType = HttpMessageConverter.setCharset(contentType, charset);
            }
        }
        ArrayList<NameValuePair> queryParameters = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, List<String>> parameterEntry : parameters.entrySet()) {
            for (String value : parameterEntry.getValue()) {
                this.logger.debug("setting query parameter: [" + parameterEntry.getKey() + ", " + value + "]");
                queryParameters.add((NameValuePair)new BasicNameValuePair(parameterEntry.getKey(), value));
            }
        }
        HttpGet httpMethod = null;
        Object httpEntity = null;
        URIBuilder uriBuilder = new URIBuilder(hostURI);
        if ("GET".equalsIgnoreCase(method)) {
            this.setQueryString(uriBuilder, queryParameters);
            httpMethod = new HttpGet(uriBuilder.build());
        } else if ("POST".equalsIgnoreCase(method)) {
            if (isMultipart) {
                this.logger.debug("setting multipart file content");
                this.setQueryString(uriBuilder, queryParameters);
                httpMethod = new HttpPost(uriBuilder.build());
                if (content instanceof String) {
                    FileUtils.writeStringToFile((File)tempFile, (String)((String)content), (Charset)contentType.getCharset(), (boolean)false);
                } else {
                    FileUtils.writeByteArrayToFile((File)tempFile, (byte[])((byte[])content), (boolean)false);
                }
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                multipartEntityBuilder.addPart(tempFile.getName(), (ContentBody)new FileBody(tempFile, contentType, tempFile.getName()));
                httpEntity = multipartEntityBuilder.build();
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                httpMethod = new HttpPost(uriBuilder.build());
                httpEntity = new UrlEncodedFormEntity(queryParameters, contentType.getCharset());
            } else {
                this.setQueryString(uriBuilder, queryParameters);
                httpMethod = new HttpPost(uriBuilder.build());
                httpEntity = content instanceof String ? new StringEntity((String)content, contentType) : new ByteArrayEntity((byte[])content);
            }
        } else if ("PUT".equalsIgnoreCase(method)) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                httpMethod = new HttpPut(uriBuilder.build());
                httpEntity = new UrlEncodedFormEntity(queryParameters, contentType.getCharset());
            } else {
                this.setQueryString(uriBuilder, queryParameters);
                httpMethod = new HttpPut(uriBuilder.build());
                httpEntity = content instanceof String ? new StringEntity((String)content, contentType) : new ByteArrayEntity((byte[])content);
            }
        } else if ("DELETE".equalsIgnoreCase(method)) {
            this.setQueryString(uriBuilder, queryParameters);
            httpMethod = new HttpDelete(uriBuilder.build());
        } else if ("PATCH".equalsIgnoreCase(method)) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                httpMethod = new HttpPatch(uriBuilder.build());
                httpEntity = new UrlEncodedFormEntity(queryParameters, contentType.getCharset());
            } else {
                this.setQueryString(uriBuilder, queryParameters);
                httpMethod = new HttpPatch(uriBuilder.build());
                httpEntity = content instanceof String ? new StringEntity((String)content, contentType) : new ByteArrayEntity((byte[])content);
            }
        }
        if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
            List contentEncodingList = (List)new CaseInsensitiveMap(headers).get((Object)"Content-Encoding");
            if (CollectionUtils.isNotEmpty((Collection)contentEncodingList)) {
                for (String contentEncoding : contentEncodingList) {
                    if (contentEncoding == null || !contentEncoding.equalsIgnoreCase("gzip") && !contentEncoding.equalsIgnoreCase("x-gzip")) continue;
                    httpEntity = new GzipCompressingEntity((HttpEntity)httpEntity);
                    break;
                }
            }
            ((HttpEntityEnclosingRequestBase)httpMethod).setEntity((HttpEntity)httpEntity);
        }
        boolean userAgentFound = false;
        for (Map.Entry<String, List<String>> headerEntry : headers.entrySet()) {
            for (String value : headerEntry.getValue()) {
                this.logger.debug("setting method header: [" + headerEntry.getKey() + ", " + value + "]");
                String key = headerEntry.getKey();
                httpMethod.addHeader(key, value);
                if (!key.equalsIgnoreCase("user-agent")) continue;
                userAgentFound = true;
            }
        }
        if (!userAgentFound) {
            httpMethod.addHeader("user-agent", "BridgeLink");
        }
        if (("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) && !isMultipart) {
            httpMethod.setHeader("Content-Type", contentType.toString());
        }
        return httpMethod;
    }

    Map<String, List<String>> getHeaders(HttpDispatcherProperties httpDispatcherProperties, ConnectorMessage connectorMessage) {
        return HttpUtil.getTableMap((boolean)httpDispatcherProperties.isUseHeadersVariable(), (String)httpDispatcherProperties.getHeadersVariable(), (Map)httpDispatcherProperties.getHeadersMap(), (MessageMaps)this.getMessageMaps(), (ConnectorMessage)connectorMessage);
    }

    Map<String, List<String>> getParameters(HttpDispatcherProperties httpDispatcherProperties, ConnectorMessage connectorMessage) {
        return HttpUtil.getTableMap((boolean)httpDispatcherProperties.isUseParametersVariable(), (String)httpDispatcherProperties.getParametersVariable(), (Map)httpDispatcherProperties.getParametersMap(), (MessageMaps)this.getMessageMaps(), (ConnectorMessage)connectorMessage);
    }

    private void setQueryString(URIBuilder uriBuilder, List<NameValuePair> queryParameters) {
        if (queryParameters.size() > 0) {
            uriBuilder.setParameters(queryParameters);
        }
    }

    private void processDigestChallenge(AuthCache authCache, HttpHost target, Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        String authValue;
        Header authHeader = request.getFirstHeader("Authorization");
        request.removeHeaders("Authorization");
        if (authHeader != null && StringUtils.startsWithIgnoreCase((CharSequence)(authValue = authHeader.getValue()), (CharSequence)"Digest")) {
            DigestScheme digestScheme = new DigestScheme();
            authValue = StringUtils.removeStartIgnoreCase((String)authValue, (String)"Digest").trim();
            Matcher matcher = AUTH_HEADER_PATTERN.matcher(authValue);
            while (matcher.find()) {
                String group = matcher.group();
                int index = group.indexOf(61);
                String name = group.substring(0, index).trim();
                String value = group.substring(index + 1).trim();
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                this.logger.debug("Overriding Digest Parameter: " + name + "=\"" + value + "\"");
                digestScheme.overrideParamter(name, value);
            }
            request.addHeader(digestScheme.authenticate(credentials, request, context));
            authCache.put(target, (AuthScheme)digestScheme);
        }
    }

    private boolean isBinaryContentType(String binaryMimeTypes, ContentType contentType) {
        String mimeType = contentType.getMimeType();
        if (this.getConnectorProperties().isResponseBinaryMimeTypesRegex()) {
            Pattern binaryMimeTypesRegex = this.binaryMimeTypesRegexMap.get(binaryMimeTypes);
            if (binaryMimeTypesRegex == null) {
                try {
                    binaryMimeTypesRegex = Pattern.compile(binaryMimeTypes);
                    if (this.binaryMimeTypesRegexMap.size() >= 100) {
                        this.binaryMimeTypesRegexMap.clear();
                    }
                    this.binaryMimeTypesRegexMap.put(binaryMimeTypes, binaryMimeTypesRegex);
                }
                catch (PatternSyntaxException e) {
                    this.logger.warn("Invalid binary MIME types regular expression: " + binaryMimeTypes, (Throwable)e);
                    return false;
                }
            }
            return binaryMimeTypesRegex.matcher(mimeType).matches();
        }
        CharSequence[] binaryMimeTypesArray = this.binaryMimeTypesArrayMap.get(binaryMimeTypes);
        if (binaryMimeTypesArray == null) {
            binaryMimeTypesArray = StringUtils.split((String)binaryMimeTypes.replaceAll("\\s*,\\s*", ",").trim(), (char)',');
            if (this.binaryMimeTypesArrayMap.size() >= 100) {
                this.binaryMimeTypesArrayMap.clear();
            }
            this.binaryMimeTypesArrayMap.put(binaryMimeTypes, (String[])binaryMimeTypesArray);
        }
        return StringUtils.startsWithAny((CharSequence)mimeType, (CharSequence[])binaryMimeTypesArray);
    }

    public HttpDispatcherProperties getConnectorProperties() {
        return (HttpDispatcherProperties)super.getConnectorProperties();
    }

    private class DynamicProxyRoutePlanner
    implements HttpRoutePlanner {
        private DynamicProxyRoutePlanner() {
        }

        public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
            HttpHost proxy = (HttpHost)context.getAttribute(HttpDispatcher.PROXY_CONTEXT_KEY);
            boolean secure = target.getSchemeName().equals("https");
            if (proxy != null) {
                HttpDispatcher.this.logger.debug("Using proxy: " + proxy.toString());
                return new HttpRoute(target, null, proxy, secure);
            }
            return new HttpRoute(target, null, secure);
        }
    }
}

