/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.edi;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EDIReader
extends SAXParser {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private String segmentDelimiter;
    private String elementDelimiter;
    private String subelementDelimiter;

    public EDIReader(String segmentDelimiter, String elementDelimiter, String subelementDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
        this.elementDelimiter = elementDelimiter;
        this.subelementDelimiter = subelementDelimiter;
    }

    public void parse(InputSource input) throws SAXException, IOException {
        BufferedReader in = new BufferedReader(input.getCharacterStream());
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = in.readLine()) != null) {
            sb.append(nextLine);
            sb.append("\n");
        }
        String message = sb.toString();
        message = message.trim();
        String documentHead = "";
        ContentHandler contentHandler = this.getContentHandler();
        contentHandler.startDocument();
        if (message == null || message.length() < 3) {
            this.logger.error("Unable to parse, message is null or too short: " + message);
            throw new SAXException("Unable to parse, message is null or too short: " + message);
        }
        StringTokenizer segmentTokenizer = new StringTokenizer(message, this.segmentDelimiter);
        int segmentCounter = 0;
        while (segmentTokenizer.hasMoreTokens()) {
            String segmentID;
            String segment = segmentTokenizer.nextToken();
            StringTokenizer elementTokenizer = new StringTokenizer(segment, this.elementDelimiter, true);
            if (elementTokenizer.hasMoreTokens()) {
                segmentID = elementTokenizer.nextToken().trim();
                if (segmentCounter == 0) {
                    documentHead = segmentID.equals("ISA") ? "X12Transaction" : "EDIMessage";
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("", "segmentDelimiter", "", "", this.segmentDelimiter);
                    attributesImpl.addAttribute("", "elementDelimiter", "", "", this.elementDelimiter);
                    attributesImpl.addAttribute("", "subelementDelimiter", "", "", this.subelementDelimiter);
                    contentHandler.startElement("", documentHead, "", attributesImpl);
                }
                contentHandler.startElement("", segmentID, "", null);
                int fieldID = 0;
                Object field = "00";
                int subelementID = 1;
                boolean lastsegElement = false;
                boolean lastsegSubelement = true;
                while (elementTokenizer.hasMoreTokens()) {
                    field = fieldID < 10 ? "0" + fieldID : "" + fieldID;
                    String element = elementTokenizer.nextToken();
                    if (element.equals(this.elementDelimiter)) {
                        if (lastsegElement) {
                            contentHandler.startElement("", segmentID + "." + (String)field, "", null);
                            contentHandler.endElement("", segmentID + "." + (String)field, "");
                        }
                        ++fieldID;
                        lastsegElement = true;
                        continue;
                    }
                    lastsegElement = false;
                    if (element.indexOf(this.subelementDelimiter) > -1) {
                        contentHandler.startElement("", segmentID + "." + (String)field, "", null);
                        StringTokenizer subelementTokenizer = new StringTokenizer(element, this.subelementDelimiter, true);
                        subelementID = 1;
                        lastsegSubelement = true;
                        while (subelementTokenizer.hasMoreTokens()) {
                            String subelementName;
                            String subelement = subelementTokenizer.nextToken();
                            if (subelement.equals(this.subelementDelimiter)) {
                                subelementName = segmentID + "." + (String)field + "." + subelementID;
                                if (lastsegSubelement) {
                                    contentHandler.startElement("", subelementName, "", null);
                                    contentHandler.characters("".toCharArray(), 0, 0);
                                    contentHandler.endElement("", subelementName, "");
                                }
                                ++subelementID;
                                lastsegSubelement = true;
                                continue;
                            }
                            subelementName = segmentID + "." + (String)field + "." + subelementID;
                            lastsegSubelement = false;
                            contentHandler.startElement("", subelementName, "", null);
                            contentHandler.characters(subelement.toCharArray(), 0, subelement.length());
                            contentHandler.endElement("", subelementName, "");
                        }
                        String subelementName = segmentID + "." + (String)field + "." + subelementID;
                        if (lastsegSubelement) {
                            contentHandler.startElement("", subelementName, "", null);
                            contentHandler.characters("".toCharArray(), 0, 0);
                            contentHandler.endElement("", subelementName, "");
                        }
                        contentHandler.endElement("", segmentID + "." + (String)field, null);
                        continue;
                    }
                    contentHandler.startElement("", segmentID + "." + (String)field, "", null);
                    contentHandler.startElement("", segmentID + "." + (String)field + ".1", "", null);
                    contentHandler.characters(element.toCharArray(), 0, element.length());
                    contentHandler.endElement("", segmentID + "." + (String)field + ".1", null);
                    contentHandler.endElement("", segmentID + "." + (String)field, null);
                }
                if (lastsegElement) {
                    field = fieldID < 10 ? "0" + fieldID : "" + fieldID;
                    contentHandler.startElement("", segmentID + "." + (String)field, "", null);
                    contentHandler.endElement("", segmentID + "." + (String)field, "");
                }
            } else {
                throw new SAXException("Could not find elements in segment: " + segment);
            }
            contentHandler.endElement("", segmentID, "");
            ++segmentCounter;
        }
        contentHandler.endElement("", documentHead, "");
        contentHandler.endDocument();
    }
}

