/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.edi;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.converters.XMLPrettyPrinter;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.edi.EDIReader;
import com.mirth.connect.plugins.datatypes.edi.EDISerializationProperties;
import com.mirth.connect.plugins.datatypes.edi.EDIXMLHandler;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EDISerializer
implements IMessageSerializer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private EDISerializationProperties serializationProperties;
    private String serializationSegmentDelimiter = null;
    private String serializationElementDelimiter = null;
    private String serializationSubelementDelimiter = null;
    private static Pattern prettyPattern1 = Pattern.compile("\\s*<([^/][^>]*)>");
    private static Pattern prettyPattern2 = Pattern.compile("<([^>]*/|/[^>]*)>\\s*");

    public EDISerializer(SerializerProperties properties) {
        this.serializationProperties = (EDISerializationProperties)properties.getSerializationProperties();
        if (this.serializationProperties != null) {
            this.serializationElementDelimiter = StringUtil.unescape((String)this.serializationProperties.getElementDelimiter());
            this.serializationSubelementDelimiter = StringUtil.unescape((String)this.serializationProperties.getSubelementDelimiter());
            this.serializationSegmentDelimiter = StringUtil.unescape((String)this.serializationProperties.getSegmentDelimiter());
        }
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        return null;
    }

    public String fromXML(String source) throws MessageSerializerException {
        XMLReader xr;
        try {
            xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            throw new MessageSerializerException("Error converting XML to EDI", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to EDI", (Throwable)e));
        }
        EDIXMLHandler handler = new EDIXMLHandler();
        xr.setContentHandler(handler);
        xr.setErrorHandler(handler);
        try {
            xr.parse(new InputSource(new StringReader(prettyPattern2.matcher(prettyPattern1.matcher(source).replaceAll("<$1>")).replaceAll("<$1>"))));
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting XML to EDI", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to EDI", (Throwable)e));
        }
        return handler.getOutput().toString();
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            Delimiters delimiters = this.getDelimiters(source);
            EDIReader ediReader = new EDIReader(delimiters.segmentDelimiter, delimiters.elementDelimiter, delimiters.subelementDelimiter);
            StringWriter stringWriter = new StringWriter();
            XMLPrettyPrinter serializer = new XMLPrettyPrinter((Writer)stringWriter);
            serializer.setEncodeEntities(true);
            ediReader.setContentHandler((ContentHandler)serializer);
            ediReader.parse(new InputSource(new StringReader(source)));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting EDI to XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting EDI to XML", (Throwable)e));
        }
    }

    private Delimiters getDelimiters(String message) {
        Delimiters delimiters = new Delimiters();
        delimiters.elementDelimiter = this.serializationElementDelimiter;
        delimiters.subelementDelimiter = this.serializationSubelementDelimiter;
        delimiters.segmentDelimiter = this.serializationSegmentDelimiter;
        if (this.serializationProperties.isInferX12Delimiters() && message.startsWith("ISA") && message.length() > 105) {
            delimiters.elementDelimiter = "" + message.charAt(3);
            delimiters.subelementDelimiter = "" + message.charAt(104);
            delimiters.segmentDelimiter = "" + message.charAt(105);
            if (message.length() > 106 && message.charAt(106) == '\n') {
                delimiters.segmentDelimiter = delimiters.segmentDelimiter + "\n";
            }
        }
        return delimiters;
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.populateMetaData(message, map);
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
        try {
            Delimiters delimiters = this.getDelimiters(message);
            String source = null;
            String type = null;
            String version = null;
            int index = -1;
            do {
                if (source == null && message.startsWith("ISA", ++index)) {
                    source = this.getElement(message, delimiters, index, 6);
                    continue;
                }
                if ((source == null || version == null) && message.startsWith("GS", index)) {
                    if (source == null) {
                        source = this.getElement(message, delimiters, index, 2);
                    }
                    version = this.getElement(message, delimiters, index, 8);
                    continue;
                }
                if (type != null || !message.startsWith("ST", index)) continue;
                type = this.getElement(message, delimiters, index, 1);
            } while ((index = this.getDelimiterIndex(message, delimiters.segmentDelimiter, index)) != -1 && (source == null || type == null || version == null));
            if (source != null) {
                map.put("message_source", source);
            }
            if (type != null) {
                map.put("message_type", type);
            }
            if (version != null) {
                map.put("mirth_version", version);
            }
        }
        catch (Exception e) {
            this.logger.error("Error populating EDI/X12 metadata.", (Throwable)e);
        }
    }

    private int getDelimiterIndex(String message, String delimiters, int startIndex) {
        char[] delimitersArray = delimiters.toCharArray();
        while (startIndex < message.length()) {
            if (ArrayUtils.contains((char[])delimitersArray, (char)message.charAt(startIndex))) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    private boolean startsWithDelimiter(String message, String delimiters, int startIndex) {
        return ArrayUtils.contains((char[])delimiters.toCharArray(), (char)message.charAt(startIndex));
    }

    private String getElement(String message, Delimiters delimiters, int index, int elementNumber) {
        StringBuilder builder = new StringBuilder();
        boolean done = false;
        boolean found = false;
        int elementCount = 0;
        while (index < message.length() && !done) {
            if (this.startsWithDelimiter(message, delimiters.segmentDelimiter, index)) {
                done = true;
            } else if (this.startsWithDelimiter(message, delimiters.elementDelimiter, index)) {
                ++elementCount;
                if (found) {
                    done = true;
                } else if (elementCount == elementNumber) {
                    found = true;
                }
            } else if (this.startsWithDelimiter(message, delimiters.subelementDelimiter, index)) {
                if (found) {
                    done = true;
                }
            } else if (found) {
                builder.append(message.charAt(index));
            }
            ++index;
        }
        return found ? builder.toString() : null;
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }

    private class Delimiters {
        public String elementDelimiter;
        public String subelementDelimiter;
        public String segmentDelimiter;

        private Delimiters() {
        }
    }
}

