/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.jdbc.Column;
import com.mirth.connect.connectors.jdbc.DatabaseConnectionInfo;
import com.mirth.connect.connectors.jdbc.DatabaseConnectorServletInterface;
import com.mirth.connect.connectors.jdbc.DatabaseReader;
import com.mirth.connect.connectors.jdbc.DatabaseWriter;
import com.mirth.connect.connectors.jdbc.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DatabaseMetadataDialog
extends MirthDialog {
    private static final int MAX_ALIAS_LENGTH = 30;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private ConnectorSettingsPanel parentConnector;
    private STATEMENT_TYPE type;
    private DatabaseConnectionInfo databaseConnectionInfo = null;
    private final String INCLUDED_COLUMN_NAME_COLUMN_NAME = "Table/Column Name";
    private final String INCLUDED_STATUS_COLUMN_NAME = "Include";
    private final String INCLUDED_TYPE_COLUMN_NAME = "Type";
    private final String INCLUDED_COLUMN_TYPE_NAME = "Column Type";
    private final String TABLE_TYPE_COLUMN = "table";
    private final String COLUMN_TYPE_COLUMN = "column";
    private String metaDataWorkerId = null;
    private JButton cancelButton;
    private JButton filterButton;
    private JLabel filterByLabel;
    private JTextField filterTableTextField;
    private JButton generateButton;
    private JScrollPane includedMetaDataPane;
    private MirthTable includedMetaDataTable;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JPanel tableFilterNamePanel;

    public DatabaseMetadataDialog(ConnectorSettingsPanel parentConnector, STATEMENT_TYPE type, DatabaseConnectionInfo databaseConnectionInfo) {
        super((Window)PlatformUI.MIRTH_FRAME);
        this.parentConnector = parentConnector;
        this.type = type;
        this.initComponents();
        this.databaseConnectionInfo = databaseConnectionInfo;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DatabaseMetadataDialog.this.cancelButtonActionPerformed(null);
            }
        });
        this.setModal(true);
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.makeIncludedMetaDataTable(null);
        this.filterTableTextField.requestFocus();
        this.setVisible(true);
    }

    public void makeIncludedMetaDataTable(Set<Table> metaData) {
        this.updateIncludedMetaDataTable(metaData);
        this.includedMetaDataTable.setDragEnabled(false);
        this.includedMetaDataTable.setRowSelectionAllowed(false);
        this.includedMetaDataTable.setRowHeight(20);
        this.includedMetaDataTable.setFocusable(false);
        this.includedMetaDataTable.setOpaque(true);
        this.includedMetaDataTable.getTableHeader().setReorderingAllowed(false);
        this.includedMetaDataTable.setSortable(false);
        this.includedMetaDataTable.getColumnExt((Object)"Include").setMaxWidth(50);
        this.includedMetaDataTable.getColumnExt((Object)"Include").setMinWidth(50);
        this.includedMetaDataTable.getColumnExt((Object)"Type").setVisible(false);
        this.includedMetaDataTable.getColumnExt((Object)"Type").setMinWidth(5);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.includedMetaDataTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.includedMetaDataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        this.includedMetaDataPane.setViewportView((Component)this.includedMetaDataTable);
        this.includedMetaDataTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DatabaseMetadataDialog.this.checkTableNameSelected(evt);
            }
        });
    }

    private void checkTableNameSelected(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            int row = this.includedMetaDataTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
            int column = this.includedMetaDataTable.columnAtPoint(new Point(evt.getX(), evt.getY()));
            if (row != -1 && column == 0) {
                String type = (String)this.includedMetaDataTable.getModel().getValueAt(row, 2);
                Boolean selected = (Boolean)this.includedMetaDataTable.getModel().getValueAt(row, 0);
                if (type.equals("table")) {
                    int i;
                    RefreshTableModel model = (RefreshTableModel)this.includedMetaDataTable.getModel();
                    boolean nextTableFound = false;
                    int tableLength = model.getRowCount();
                    int endRow = -1;
                    for (i = row + 1; !nextTableFound && i != tableLength; ++i) {
                        String nextType = (String)this.includedMetaDataTable.getModel().getValueAt(i, 2);
                        if (nextType.equals("table")) {
                            endRow = i;
                            nextTableFound = true;
                            continue;
                        }
                        if (i + 1 != tableLength) continue;
                        endRow = i + 1;
                    }
                    if (endRow == -1) {
                        return;
                    }
                    for (i = row + 1; i < endRow; ++i) {
                        model.setValueAt((Object)selected, i, 0);
                    }
                }
            }
        }
    }

    public void updateIncludedMetaDataTable(Set<Table> metaData) {
        Object[][] tableData = null;
        int tableSize = 0;
        if (metaData != null) {
            for (Table table : metaData) {
                int numOfColumns = table.getColumns() != null ? table.getColumns().size() : 0;
                tableSize += 1 + numOfColumns;
            }
            tableData = new Object[tableSize][4];
            int i = 0;
            for (Table table : metaData) {
                tableData[i][0] = Boolean.FALSE;
                tableData[i][1] = "<html><b>" + table.getName() + "</b></html>";
                tableData[i][2] = "table";
                tableData[i][3] = "";
                ++i;
                List columns = table.getColumns();
                for (Column column : columns) {
                    tableData[i][0] = Boolean.FALSE;
                    tableData[i][1] = "     " + column.getName();
                    tableData[i][2] = "column";
                    tableData[i][3] = column.getType() + "(" + column.getPrecision() + ")";
                    ++i;
                }
            }
        }
        if (metaData != null && this.includedMetaDataTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.includedMetaDataTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.includedMetaDataTable = new MirthTable();
            this.includedMetaDataTable.setModel((TableModel)new RefreshTableModel(tableData, new String[]{"Include", "Table/Column Name", "Type", "Column Type"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{true, false, false, false};
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
    }

    public String createQueryFromMetaData(Map<String, Object> metaData) {
        if (metaData == null) {
            return null;
        }
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        LinkedHashSet<Object> aliases = new LinkedHashSet<Object>();
        LinkedHashSet<CallSite> columns = new LinkedHashSet<CallSite>();
        for (Map.Entry<String, Object> entry : metaData.entrySet()) {
            String table = entry.getKey().trim();
            for (String column : (List)entry.getValue()) {
                Object alias = table + "_" + (column = column.trim());
                if (((String)alias).length() > 30) {
                    alias = column;
                }
                if (((String)alias).length() > 30) {
                    alias = StringUtils.substring((String)alias, (int)0, (int)30);
                }
                int i = 2;
                Object originalAlias = alias;
                while (aliases.contains(alias)) {
                    alias = (String)originalAlias + i;
                    if (((String)alias).length() > 30) {
                        alias = StringUtils.substring((String)originalAlias, (int)0, (int)(30 - String.valueOf(i).length())) + i;
                    }
                    ++i;
                }
                tables.add(table);
                aliases.add(alias);
                columns.add((CallSite)((Object)(table + "." + column + " AS " + (String)alias)));
            }
        }
        return "SELECT " + StringUtils.join(columns, (String)", ") + "\nFROM " + StringUtils.join(tables, (String)", ");
    }

    public List<String> createInsertFromMetaData(Map<String, Object> metaData) {
        LinkedList<String> insertStatements = new LinkedList<String>();
        if (metaData != null) {
            Iterator<Map.Entry<String, Object>> iterator = metaData.entrySet().iterator();
            while (iterator.hasNext()) {
                Object statement = "INSERT INTO ";
                Object values = "\nVALUES (";
                Map.Entry<String, Object> entry = iterator.next();
                statement = (String)statement + String.valueOf(entry.getKey());
                List columns = (List)metaData.get(entry.getKey());
                statement = (String)statement + " (";
                int i = 0;
                for (String column : columns) {
                    if (i != 0) {
                        statement = (String)statement + ", ";
                        values = (String)values + ", ";
                    }
                    statement = (String)statement + column.trim();
                    values = (String)values + "?";
                    ++i;
                }
                statement = (String)statement + ")";
                values = (String)values + ")";
                statement = (String)statement + (String)values;
                insertStatements.add((String)statement);
            }
        }
        return insertStatements;
    }

    public List<String> createUpdateFromMetaData(Map<String, Object> metaData) {
        LinkedList<String> insertStatements = new LinkedList<String>();
        if (metaData != null) {
            Iterator<Map.Entry<String, Object>> iterator = metaData.entrySet().iterator();
            while (iterator.hasNext()) {
                Object statement = "UPDATE ";
                Map.Entry<String, Object> entry = iterator.next();
                statement = (String)statement + String.valueOf(entry.getKey());
                statement = (String)statement + "\nSET ";
                List columns = (List)metaData.get(entry.getKey());
                int i = 0;
                for (String column : columns) {
                    if (i != 0) {
                        statement = (String)statement + ", ";
                    }
                    statement = (String)statement + column.trim() + " = ?";
                    ++i;
                }
                insertStatements.add((String)statement);
            }
        }
        return insertStatements;
    }

    public Map<String, Object> getSelectedMetaData() {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        String currentTableName = "";
        for (int i = 0; i < this.includedMetaDataTable.getModel().getRowCount(); ++i) {
            String type = (String)this.includedMetaDataTable.getModel().getValueAt(i, 2);
            if (type.equals("table")) {
                currentTableName = ((String)this.includedMetaDataTable.getModel().getValueAt(i, 1)).replaceAll("<html><b>", "").replaceAll("</b></html>", "");
                continue;
            }
            if (!((Boolean)this.includedMetaDataTable.getModel().getValueAt(i, 0)).booleanValue()) continue;
            if (metaData.get(currentTableName) == null) {
                metaData.put(currentTableName, new LinkedList());
            }
            ((List)metaData.get(currentTableName)).add((String)this.includedMetaDataTable.getModel().getValueAt(i, 1));
        }
        return metaData;
    }

    public void onCloseAction() {
        this.cancelButtonActionPerformed(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.generateButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.includedMetaDataPane = new JScrollPane();
        this.includedMetaDataTable = null;
        this.tableFilterNamePanel = new JPanel();
        this.filterByLabel = new JLabel();
        this.filterTableTextField = new JTextField();
        this.filterButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("SQL Creation");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseMetadataDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseMetadataDialog.this.generateButtonActionPerformed(evt);
            }
        });
        this.includedMetaDataPane.setViewportView((Component)this.includedMetaDataTable);
        this.filterByLabel.setText("Filter by:");
        this.filterTableTextField.setToolTipText("<html>Enter an optional table name filter before querying the <br/>\ndatabase to limit the number of tables returned.<br/>\nExample: rad*,table*test</html>");
        this.filterButton.setText("Get Tables");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseMetadataDialog.this.filterButtonActionPerformed(evt);
            }
        });
        GroupLayout tableFilterNamePanelLayout = new GroupLayout(this.tableFilterNamePanel);
        this.tableFilterNamePanel.setLayout(tableFilterNamePanelLayout);
        tableFilterNamePanelLayout.setHorizontalGroup(tableFilterNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableFilterNamePanelLayout.createSequentialGroup().addComponent(this.filterByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTableTextField, -1, 308, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterButton)));
        tableFilterNamePanelLayout.setVerticalGroup(tableFilterNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableFilterNamePanelLayout.createSequentialGroup().addContainerGap().addGroup(tableFilterNamePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterByLabel).addComponent(this.filterTableTextField, -2, -1, -2).addComponent(this.filterButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includedMetaDataPane, GroupLayout.Alignment.TRAILING, -1, 444, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 444, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.generateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.tableFilterNamePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.cancelButton, this.generateButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.tableFilterNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includedMetaDataPane, -1, 458, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.generateButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        SwingWorker worker;
        if (this.metaDataWorkerId != null && (worker = this.parentConnector.getWorker(this.metaDataWorkerId)) != null) {
            worker.cancel(true);
        }
        this.dispose();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        if (this.parentConnector instanceof DatabaseReader) {
            if (this.type == STATEMENT_TYPE.SELECT_TYPE) {
                ((DatabaseReader)this.parentConnector).setSelectText(this.createQueryFromMetaData(this.getSelectedMetaData()));
            } else {
                ((DatabaseReader)this.parentConnector).setUpdateText(this.createUpdateFromMetaData(this.getSelectedMetaData()));
            }
        } else if (this.parentConnector instanceof DatabaseWriter) {
            ((DatabaseWriter)this.parentConnector).setInsertText(this.createInsertFromMetaData(this.getSelectedMetaData()));
        }
        this.dispose();
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        this.databaseConnectionInfo.setTableNamePatternExpression(this.filterTableTextField.getText());
        if (this.metaDataWorkerId != null) {
            SwingWorker worker = this.parentConnector.getWorker(this.metaDataWorkerId);
            if (worker != null) {
                worker.cancel(true);
            }
            this.metaDataWorkerId = null;
        }
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                Set metaData = (Set)response;
                if (metaData == null) {
                    DatabaseMetadataDialog.this.parent.alertError((Component)DatabaseMetadataDialog.this.parent, "Could not retrieve database metadata.  Please ensure that your driver, URL, username, and password are correct.");
                } else {
                    DatabaseMetadataDialog.this.makeIncludedMetaDataTable(metaData);
                }
                DatabaseMetadataDialog.this.metaDataWorkerId = null;
            }
        };
        HashSet<String> tableNamePatterns = new HashSet<String>(Arrays.asList(this.databaseConnectionInfo.getTableNamePatternExpression().trim().split("[, ]+")));
        try {
            this.metaDataWorkerId = UUID.randomUUID().toString();
            ((DatabaseConnectorServletInterface)this.parentConnector.getServlet(DatabaseConnectorServletInterface.class, "Retrieving tables...", "Could not retrieve database metadata.  Please ensure that your driver, URL, username, and password are correct.\n\n", handler, this.metaDataWorkerId)).getTables(this.parent.channelEditPanel.currentChannel.getId(), this.parent.channelEditPanel.currentChannel.getName(), this.databaseConnectionInfo.getDriver(), this.databaseConnectionInfo.getUrl(), this.databaseConnectionInfo.getUsername(), this.databaseConnectionInfo.getPassword(), tableNamePatterns, this.databaseConnectionInfo.getSelectLimit(), this.databaseConnectionInfo.getResourceIds());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public static enum STATEMENT_TYPE {
        SELECT_TYPE,
        UPDATE_TYPE,
        INSERT_TYPE;

    }
}

