/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.tool.dcmrcv;

import com.mirth.connect.connectors.dimse.DICOMConfiguration;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.tool.dcmrcv.DcmRcv;

public class MirthDcmRcv
extends DcmRcv {
    private Logger logger = LogManager.getLogger(this.getClass());
    private SourceConnector sourceConnector;
    private DICOMConfiguration dicomConfiguration;

    public MirthDcmRcv(SourceConnector sourceConnector, DICOMConfiguration dicomConfiguration) {
        super("DCMRCV", false);
        this.sourceConnector = sourceConnector;
        this.dicomConfiguration = dicomConfiguration;
        this.init();
    }

    public Device getDevice() {
        return this.device;
    }

    public NetworkConnection getNetworkConnection() {
        return this.nc;
    }

    @Override
    protected NetworkConnection createNetworkConnection() {
        return this.dicomConfiguration.createNetworkConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onCStoreRQ(Association as, int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid, DicomObject rsp) throws IOException, DicomServiceException {
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        DicomOutputStream dos = null;
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        BasicDicomObject fileMetaInformation = new BasicDicomObject();
        fileMetaInformation.initFileMetaInformation(cuid, iuid, tsuid);
        String originalThreadName = Thread.currentThread().getName();
        try {
            LinkedHashMap<Integer, String> pcMap;
            Thread.currentThread().setName("DICOM Receiver Thread on " + this.sourceConnector.getChannel().getName() + " (" + this.sourceConnector.getChannelId() + ") < " + originalThreadName);
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("localApplicationEntityTitle", as.getLocalAET());
            sourceMap.put("remoteApplicationEntityTitle", as.getRemoteAET());
            if (as.getSocket() != null) {
                sourceMap.put("localAddress", as.getSocket().getLocalAddress().getHostAddress());
                sourceMap.put("localPort", as.getSocket().getLocalPort());
                if (as.getSocket().getRemoteSocketAddress() instanceof InetSocketAddress) {
                    sourceMap.put("remoteAddress", ((InetSocketAddress)as.getSocket().getRemoteSocketAddress()).getAddress().getHostAddress());
                    sourceMap.put("remotePort", ((InetSocketAddress)as.getSocket().getRemoteSocketAddress()).getPort());
                }
            }
            if (as.getAssociateAC() != null) {
                sourceMap.put("associateACProtocolVersion", as.getAssociateAC().getProtocolVersion());
                sourceMap.put("associateACImplClassUID", as.getAssociateAC().getImplClassUID());
                sourceMap.put("associateACImplVersionName", as.getAssociateAC().getImplVersionName());
                sourceMap.put("associateACApplicationContext", as.getAssociateAC().getApplicationContext());
                if (as.getAssociateAC().getNumberOfPresentationContexts() > 0) {
                    pcMap = new LinkedHashMap<Integer, String>();
                    for (PresentationContext pc : as.getAssociateAC().getPresentationContexts()) {
                        pcMap.put(pc.getPCID(), pc.toString());
                    }
                    sourceMap.put("associateACPresentationContexts", MapUtils.unmodifiableMap(pcMap));
                }
            }
            if (as.getAssociateRQ() != null) {
                sourceMap.put("associateRQProtocolVersion", as.getAssociateRQ().getProtocolVersion());
                sourceMap.put("associateRQImplClassUID", as.getAssociateRQ().getImplClassUID());
                sourceMap.put("associateRQImplVersionName", as.getAssociateRQ().getImplVersionName());
                sourceMap.put("associateRQApplicationContext", as.getAssociateRQ().getApplicationContext());
                if (as.getAssociateRQ().getNumberOfPresentationContexts() > 0) {
                    pcMap = new LinkedHashMap();
                    for (PresentationContext pc : as.getAssociateRQ().getPresentationContexts()) {
                        pcMap.put(pc.getPCID(), pc.toString());
                    }
                    sourceMap.put("associateRQPresentationContexts", MapUtils.unmodifiableMap(pcMap));
                }
                if (as.getAssociateRQ().getUserIdentity() != null) {
                    sourceMap.put("username", as.getAssociateRQ().getUserIdentity().getUsername());
                    sourceMap.put("passcode", new String(as.getAssociateRQ().getUserIdentity().getPasscode()));
                    int type = as.getAssociateRQ().getUserIdentity().getUserIdentityType();
                    sourceMap.put("userIdentityType", switch (type) {
                        case 1 -> "USERNAME";
                        case 2 -> "USERNAME_PASSCODE";
                        case 3 -> "KERBEROS";
                        case 4 -> "SAML";
                        default -> String.valueOf(type);
                    });
                }
            }
            sourceMap.putAll(this.dicomConfiguration.getCStoreRequestInformation(as));
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            dos = new DicomOutputStream((OutputStream)bos);
            dos.writeFileMetaInformation((DicomObject)fileMetaInformation);
            dataStream.copyTo((OutputStream)dos);
            dos.close();
            byte[] dicomMessage = baos.toByteArray();
            bos = null;
            baos = null;
            DispatchResult dispatchResult = null;
            try {
                dispatchResult = this.sourceConnector.dispatchRawMessage(new RawMessage(dicomMessage, null, sourceMap));
                if (dispatchResult != null && dispatchResult.getSelectedResponse() != null && dispatchResult.getSelectedResponse().getStatus() == Status.ERROR) {
                    throw new DicomServiceException(rq, 272, dispatchResult.getSelectedResponse().getStatusMessage());
                }
            }
            catch (Throwable throwable) {
                this.sourceConnector.finishDispatch(dispatchResult);
                throw throwable;
            }
            this.sourceConnector.finishDispatch(dispatchResult);
            Thread.currentThread().setName(originalThreadName);
        }
        catch (Throwable t) {
            try {
                this.logger.error("Error receiving DICOM message on channel " + this.sourceConnector.getChannelId(), t);
                if (t instanceof DicomServiceException) {
                    throw (DicomServiceException)t;
                }
                throw new DicomServiceException(rq, 272, "Error processing DICOM message: " + t.getMessage());
            }
            catch (Throwable throwable) {
                Thread.currentThread().setName(originalThreadName);
                IOUtils.closeQuietly(baos);
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)baos);
        IOUtils.closeQuietly((OutputStream)bos);
    }

    @Override
    public boolean isStoreFile() {
        return true;
    }
}

