/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.tool.dcmsnd;

import com.mirth.connect.connectors.dimse.DICOMConfiguration;
import java.io.IOException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.tool.dcmsnd.DcmSnd;

public class MirthDcmSnd
extends DcmSnd {
    private DICOMConfiguration dicomConfiguration;

    public MirthDcmSnd(DICOMConfiguration dicomConfiguration) {
        super("DCMSND", false);
        this.dicomConfiguration = dicomConfiguration;
        this.init();
    }

    public Device getDevice() {
        return this.device;
    }

    public NetworkConnection getNetworkConnection() {
        return this.conn;
    }

    public NetworkConnection getRemoteNetworkConnection() {
        return this.remoteConn;
    }

    public NetworkConnection getRemoteStgcmtNetworkConnection() {
        return this.remoteStgcmtConn;
    }

    @Override
    protected NetworkConnection createNetworkConnection() {
        return this.dicomConfiguration.createNetworkConnection();
    }

    @Override
    public synchronized DicomObject waitForStgCmtResult() throws InterruptedException {
        return super.waitForStgCmtResult();
    }

    public void neventReport(Association as, int pcid, DicomObject rq, DicomObject info) throws DicomServiceException, IOException {
        DicomObject rsp = CommandUtils.mkRSP((DicomObject)rq, (int)0);
        if (!CommandUtils.isIncludeUIDinRSP()) {
            String cuid = rq.getString(2);
            if (cuid == null) {
                cuid = rq.getString(3);
            }
            rsp.putString(2, VR.UI, cuid);
            String iuid = rq.getString(4096);
            if (iuid == null) {
                iuid = rq.getString(4097);
            }
            if (iuid != null) {
                rsp.putString(4096, VR.UI, iuid);
            }
        }
        this.onNEventReportRQ(as, pcid, rq, info, rsp);
        as.writeDimseRSP(pcid, rsp);
        this.onNEventReportRSP(as, pcid, rq, info, rsp);
    }
}

