/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLib;
import com.sun.medialib.codec.jiio.Util;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class J2KImageWriterCodecLibSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] entensions = new String[]{"jp2"};
    private static String[] mimeType = new String[]{"image/jpeg2000"};
    private boolean registered = false;
    private boolean useCodecLib = false;

    public J2KImageWriterCodecLibSpi() {
        super("Sun Microsystems, Inc.", "0.5", formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLib", ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        return "Standard JPEG 2000 Image Writer";
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        try {
            this.useCodecLib = Util.isCodecLibAvailable();
        }
        catch (Throwable e) {
            this.useCodecLib = false;
        }
        if (this.useCodecLib) {
            this.registered = true;
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        SampleModel sm = type.getSampleModel();
        if (sm.getNumBands() > 16384) {
            return false;
        }
        return sm.getDataType() >= 0 && sm.getDataType() <= 3;
    }

    public ImageWriter createWriterInstance(Object extension) throws IIOException {
        return new J2KImageWriterCodecLib(this);
    }
}

