/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.medialib.codec.g3fax.Decoder;
import java.io.IOException;

public class TIFFCodecLibFaxDecompressor
extends TIFFFaxDecompressor {
    private static final boolean DEBUG = false;
    private Object decoder;

    public TIFFCodecLibFaxDecompressor(int bilevelCompression) {
        block4: {
            this.decoder = null;
            try {
                if (bilevelCompression == 3) {
                    Decoder decoder = new Decoder();
                    this.decoder = decoder;
                    break block4;
                }
                if (bilevelCompression == 4) {
                    com.sun.medialib.codec.g4fax.Decoder decoder = new com.sun.medialib.codec.g4fax.Decoder();
                    this.decoder = decoder;
                    break block4;
                }
                throw new RuntimeException("Unknown compression = " + bilevelCompression);
            }
            catch (Throwable e) {
                throw new RuntimeException("CodecLib not available");
            }
        }
    }

    public final synchronized void decodeRaw(byte[] b, int dstOffset, int pixelBitStride, int scanlineStride) throws IOException {
        com.sun.medialib.codec.g4fax.Decoder decoder;
        int bytesPerRow = (this.srcWidth + 7) / 8;
        byte[] image = null;
        byte[] code = new byte[this.compression == 4 ? this.byteCount : this.srcWidth * this.srcHeight];
        this.stream.seek(this.offset);
        this.stream.readFully(code, 0, this.byteCount);
        if (this.fillOrder == 2) {
            int i = 0;
            while (i < this.byteCount) {
                code[i] = TIFFFaxDecompressor.flipTable[code[i] & 0xFF];
                ++i;
            }
        }
        image = dstOffset == 0 && bytesPerRow == scanlineStride ? b : new byte[this.srcWidth * this.srcHeight];
        if (this.compression == 4) {
            decoder = (com.sun.medialib.codec.g4fax.Decoder)this.decoder;
            if (decoder.decode(image, code, this.srcWidth, this.srcHeight) == -1) {
                super.decodeRaw(b, dstOffset, pixelBitStride, scanlineStride);
                return;
            }
        } else {
            decoder = (Decoder)this.decoder;
            int[] w = new int[]{this.srcWidth};
            int[] h = new int[]{this.srcHeight};
            int decodingFlags = 0;
            decodingFlags = this.oneD == 1 ? 2 | 4 : 1 | 4;
            if (this.fillBits == 1) {
                decodingFlags |= 0x10;
            }
            if (decoder.decode(image, code, w, h, decodingFlags) == -1) {
                super.decodeRaw(b, dstOffset, pixelBitStride, scanlineStride);
                return;
            }
        }
        if (image != b) {
            int srcOffset = 0;
            int row = 0;
            while (row < this.srcHeight) {
                System.arraycopy(image, srcOffset, b, dstOffset, bytesPerRow);
                srcOffset += bytesPerRow;
                dstOffset += scanlineStride;
                ++row;
            }
        }
    }

    static {
        DEBUG = false;
    }
}

