/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class GuardBitsSpec
extends ModuleSpec {
    private String defaultValue = "2";

    public GuardBitsSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public GuardBitsSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        if (values == null) {
            this.setDefault(new Integer(this.defaultValue));
            return;
        }
        String param = values;
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ModuleSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 2;
                    break;
                }
                case 'c': {
                    compSpec = ModuleSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 1;
                    break;
                }
                default: {
                    int i;
                    Integer value;
                    try {
                        value = new Integer(word);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad parameter for -Qguard_bits option : " + word);
                    }
                    if (value.floatValue() <= 0.0f) {
                        throw new IllegalArgumentException("Guard bits value must be positive : " + value);
                    }
                    if (curSpecType == 0) {
                        this.setDefault(value);
                    } else if (curSpecType == 2) {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            if (tileSpec[i]) {
                                this.setTileDef(i, value);
                            }
                            --i;
                        }
                    } else if (curSpecType == 1) {
                        i = compSpec.length - 1;
                        while (i >= 0) {
                            if (compSpec[i]) {
                                this.setCompDef(i, value);
                            }
                            --i;
                        }
                    } else {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            int j = compSpec.length - 1;
                            while (j >= 0) {
                                if (tileSpec[i] && compSpec[j]) {
                                    this.setTileCompVal(i, j, value);
                                }
                                --j;
                            }
                            --i;
                        }
                    }
                    curSpecType = 0;
                    tileSpec = null;
                    compSpec = null;
                }
            }
        }
        if (this.getDefault() == null) {
            int c;
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                c = nc - 1;
                while (c >= 0) {
                    if (this.specValType[t][c] == 0) {
                        ++ndefspec;
                    }
                    --c;
                }
                --t;
            }
            if (ndefspec != 0) {
                this.setDefault(new Integer(this.defaultValue));
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        c = nc - 1;
                        while (c >= 0) {
                            if (this.specValType[0][c] == 2) {
                                this.specValType[0][c] = 0;
                            }
                            --c;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        int t2 = nt - 1;
                        while (t2 >= 0) {
                            if (this.specValType[t2][0] == 1) {
                                this.specValType[t2][0] = 0;
                            }
                            --t2;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }
}

