/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.model.User;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.notification.Notification;
import com.mirth.connect.util.MirthSSLUtil;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;

public class ConnectServiceUtil {
    private static final String URL_CONNECT_SERVER = "https://www.example.com";
    private static final String URL_REGISTRATION_SERVLET = "/RegistrationServlet";
    private static final String URL_USAGE_SERVLET = "/UsageStatisticsServlet";
    private static final String URL_NOTIFICATION_SERVLET = "/NotificationServlet";
    private static String NOTIFICATION_GET = "getNotifications";
    private static String NOTIFICATION_COUNT_GET = "getNotificationCount";
    private static final int TIMEOUT = 10000;
    public static final Integer MILLIS_PER_DAY = 86400000;

    public static void registerUser(String serverId, String mirthVersion, User user, String[] protocols, String[] cipherSuites) throws ClientException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("serverId", serverId), new BasicNameValuePair("version", mirthVersion), new BasicNameValuePair("user", ObjectXMLSerializer.getInstance().serialize(user))};
        HttpPost post = new HttpPost();
        post.setURI(URI.create("https://www.example.com/RegistrationServlet"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params), Charset.forName("UTF-8")));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        try {
            HttpClientContext postContext = HttpClientContext.create();
            postContext.setRequestConfig(requestConfig);
            httpClient = ConnectServiceUtil.getClient(protocols, cipherSuites);
            httpResponse = httpClient.execute((HttpUriRequest)post, (HttpContext)postContext);
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200 && statusCode != 302) {
                throw new Exception("Failed to connect to update server: " + String.valueOf(statusLine));
            }
        }
        catch (Exception e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                HttpClientUtils.closeQuietly(httpClient);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    public static List<Notification> getNotifications(String serverId, String mirthVersion, Map<String, String> extensionVersions, String[] protocols, String[] cipherSuites) throws Exception {
        ArrayList<Notification> allNotifications;
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block8: {
            client = null;
            HttpPost post = new HttpPost();
            response = null;
            allNotifications = new ArrayList<Notification>();
            try {
                ObjectMapper mapper = new ObjectMapper();
                String extensionVersionsJson = mapper.writeValueAsString(extensionVersions);
                NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("op", NOTIFICATION_GET), new BasicNameValuePair("serverId", serverId), new BasicNameValuePair("version", mirthVersion), new BasicNameValuePair("extensionVersions", extensionVersionsJson)};
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
                post.setURI(URI.create("https://www.example.com/NotificationServlet"));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params), Charset.forName("UTF-8")));
                HttpClientContext postContext = HttpClientContext.create();
                postContext.setRequestConfig(requestConfig);
                client = ConnectServiceUtil.getClient(protocols, cipherSuites);
                response = client.execute((HttpUriRequest)post, (HttpContext)postContext);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 200) {
                    HttpEntity responseEntity = response.getEntity();
                    Charset responseCharset = null;
                    try {
                        responseCharset = ContentType.getOrDefault((HttpEntity)responseEntity).getCharset();
                    }
                    catch (Exception e) {
                        responseCharset = ContentType.TEXT_PLAIN.getCharset();
                    }
                    String responseContent = IOUtils.toString((InputStream)responseEntity.getContent(), (Charset)responseCharset).trim();
                    JsonNode rootNode = mapper.readTree(responseContent);
                    for (JsonNode childNode : rootNode) {
                        Notification notification = new Notification();
                        notification.setId(childNode.get("id").asInt());
                        notification.setName(childNode.get("name").asText());
                        notification.setDate(childNode.get("date").asText());
                        notification.setContent(childNode.get("content").asText());
                        allNotifications.add(notification);
                    }
                    break block8;
                }
                throw new ClientException("Status code: " + statusCode);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(response);
                    HttpClientUtils.closeQuietly(client);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return allNotifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getNotificationCount(String serverId, String mirthVersion, Map<String, String> extensionVersions, Set<Integer> archivedNotifications, String[] protocols, String[] cipherSuites) {
        int notificationCount;
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block7: {
            client = null;
            HttpPost post = new HttpPost();
            response = null;
            notificationCount = 0;
            try {
                ObjectMapper mapper = new ObjectMapper();
                String extensionVersionsJson = mapper.writeValueAsString(extensionVersions);
                NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("op", NOTIFICATION_COUNT_GET), new BasicNameValuePair("serverId", serverId), new BasicNameValuePair("version", mirthVersion), new BasicNameValuePair("extensionVersions", extensionVersionsJson)};
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
                post.setURI(URI.create("https://www.example.com/NotificationServlet"));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params), Charset.forName("UTF-8")));
                HttpClientContext postContext = HttpClientContext.create();
                postContext.setRequestConfig(requestConfig);
                client = ConnectServiceUtil.getClient(protocols, cipherSuites);
                response = client.execute((HttpUriRequest)post, (HttpContext)postContext);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode != 200) break block7;
                HttpEntity responseEntity = response.getEntity();
                Charset responseCharset = null;
                try {
                    responseCharset = ContentType.getOrDefault((HttpEntity)responseEntity).getCharset();
                }
                catch (Exception e) {
                    responseCharset = ContentType.TEXT_PLAIN.getCharset();
                }
                List notificationIds = (List)mapper.readValue(IOUtils.toString((InputStream)responseEntity.getContent(), (Charset)responseCharset).trim(), (TypeReference)new TypeReference<List<Integer>>(){});
                Iterator iterator = notificationIds.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    if (archivedNotifications.contains(id)) continue;
                    ++notificationCount;
                }
            }
            catch (Exception exception) {
                HttpClientUtils.closeQuietly(response);
                HttpClientUtils.closeQuietly(client);
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(response);
                    HttpClientUtils.closeQuietly(client);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return notificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean sendStatistics(String serverId, String mirthVersion, boolean server, String data, String[] protocols, String[] cipherSuites) {
        CloseableHttpResponse response;
        CloseableHttpClient client;
        boolean isSent;
        block5: {
            if (data == null) {
                return false;
            }
            isSent = false;
            client = null;
            HttpPost post = new HttpPost();
            response = null;
            NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("serverId", serverId), new BasicNameValuePair("version", mirthVersion), new BasicNameValuePair("server", Boolean.toString(server)), new BasicNameValuePair("data", data)};
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            post.setURI(URI.create("https://www.example.com/UsageStatisticsServlet"));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params), Charset.forName("UTF-8")));
            try {
                HttpClientContext postContext = HttpClientContext.create();
                postContext.setRequestConfig(requestConfig);
                client = ConnectServiceUtil.getClient(protocols, cipherSuites);
                response = client.execute((HttpUriRequest)post, (HttpContext)postContext);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode != 200) break block5;
                isSent = true;
            }
            catch (Exception exception) {
                HttpClientUtils.closeQuietly(response);
                HttpClientUtils.closeQuietly(client);
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(response);
                    HttpClientUtils.closeQuietly(client);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return isSent;
    }

    private static CloseableHttpClient getClient(String[] protocols, String[] cipherSuites) {
        RegistryBuilder socketFactoryRegistry = RegistryBuilder.create();
        String[] enabledProtocols = MirthSSLUtil.getEnabledHttpsProtocols(protocols);
        String[] enabledCipherSuites = MirthSSLUtil.getEnabledHttpsCipherSuites(cipherSuites);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), enabledProtocols, enabledCipherSuites, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        socketFactoryRegistry.register("https", (Object)sslConnectionSocketFactory);
        BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry.build());
        httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(10000).build());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
    }
}

