/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.ChannelStatistics;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/channels")
@Tag(name="Channel Statistics")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ChannelStatisticsServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/statistics")
    @Operation(summary="Returns the Statistics for all channels.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_statistics_list", ref="../apiexamples/channel_statistics_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_statistics_list", ref="../apiexamples/channel_statistics_list_json")})})
    @MirthOperation(name="getAllStatistics", display="Get all statistics", permission="viewDashboard", auditable=false)
    public List<ChannelStatistics> getStatistics(@Param(value="channelIds") @Parameter(description="The IDs of the channels to retrieve. If absent, all channels will be retrieved.") @QueryParam(value="channelId") Set<String> var1, @Param(value="includeUndeployed") @Parameter(description="If true, statistics for undeployed channels will also be included.") @QueryParam(value="includeUndeployed") boolean var2, @Param(value="includeMetadataIds") @Parameter(description="The ids of connectors to include. Cannot include and exclude connectors.") @QueryParam(value="includeMetadataId") Set<Integer> var3, @Param(value="excludeMetadataIds") @Parameter(description="The ids of connectors to exclude. Cannot include and exclude connectors.") @QueryParam(value="excludeMetadataId") Set<Integer> var4, @Param(value="aggregateStats") @Parameter(description="If true, statistics will be aggregated into one result") @QueryParam(value="aggregateStats") boolean var5) throws ClientException;

    @POST
    @Path(value="/statistics/_getStatistics")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Returns the Statistics for all channels. This is a POST request alternative to GET /statistics that may be used when there are too many channel IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_statistics_list", ref="../apiexamples/channel_statistics_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_statistics_list", ref="../apiexamples/channel_statistics_list_json")})})
    @MirthOperation(name="getAllStatistics", display="Get all statistics", permission="viewDashboard", auditable=false)
    public List<ChannelStatistics> getStatisticsPost(@Param(value="channelIds") @Parameter(description="The IDs of the channels to retrieve. If absent, all channels will be retrieved.") @FormDataParam(value="channelIds") Set<String> var1, @Param(value="includeUndeployed") @Parameter(description="If true, statistics for undeployed channels will also be included.") @FormDataParam(value="includeUndeployed") boolean var2, @Param(value="includeMetadataIds") @Parameter(description="The ids of connectors to include. Cannot include and exclude connectors.") @FormDataParam(value="includeMetadataIds") Set<Integer> var3, @Param(value="excludeMetadataIds") @Parameter(description="The ids of connectors to exclude. Cannot include and exclude connectors.") @FormDataParam(value="excludeMetadataIds") Set<Integer> var4, @Param(value="aggregateStats") @Parameter(description="If true, statistics will be aggregated into one result") @FormDataParam(value="aggregateStats") boolean var5) throws ClientException;

    @GET
    @Path(value="/{channelId}/statistics")
    @Operation(summary="Returns the Statistics for the channel with the specified id.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_statistics", ref="../apiexamples/channel_statistics_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_statistics", ref="../apiexamples/channel_statistics_json")})})
    @MirthOperation(name="getStatistics", display="Get statistics", permission="viewDashboard", auditable=false)
    public ChannelStatistics getStatistics(@Param(value="channelId") @Parameter(description="The ID of the channel to retrieve statistics for.", required=true) @PathParam(value="channelId") String var1) throws ClientException;

    @POST
    @Path(value="/_clearStatistics")
    @Operation(summary="Clears the statistics for the given channels and/or connectors.")
    @MirthOperation(name="clearStatistics", display="Clear statistics", permission="clearStatistics")
    public void clearStatistics(@Param(value="channelConnectorMap") @RequestBody(description="Channel IDs mapped to lists of metaDataIds (connectors). If the metaDataId list is null, then all statistics for the channel will be cleared.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connector_map", ref="../apiexamples/connector_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connector_map", ref="../apiexamples/connector_map_json")})}) Map<String, List<Integer>> var1, @Param(value="received") @Parameter(description="If true, received stats will be cleared.") @QueryParam(value="received") boolean var2, @Param(value="filtered") @Parameter(description="If true, filtered stats will be cleared.") @QueryParam(value="filtered") boolean var3, @Param(value="sent") @Parameter(description="If true, sent stats will be cleared.") @QueryParam(value="sent") boolean var4, @Param(value="error") @Parameter(description="If true, error stats will be cleared.") @QueryParam(value="error") boolean var5) throws ClientException;

    @POST
    @Path(value="/_clearAllStatistics")
    @Operation(summary="Clears all statistics (including lifetime) for all channels/connectors.")
    @MirthOperation(name="clearAllStatistics", display="Clear all statistics", permission="clearLifetimeStats")
    public void clearAllStatistics() throws ClientException;
}

