/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.EncryptionSettings;
import com.mirth.connect.model.LicenseInfo;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.ConnectionTestResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/server")
@Tag(name="Server Configuration")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ConfigurationServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/id")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns the server id.")
    @MirthOperation(name="getServerId", display="Get server ID", auditable=false)
    public String getServerId() throws ClientException;

    @GET
    @Path(value="/version")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns the version of the BridgeLink server.")
    @MirthOperation(name="getVersion", display="Get version", auditable=false)
    public String getVersion() throws ClientException;

    @GET
    @Path(value="/buildDate")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns the build date of the BridgeLink server.")
    @MirthOperation(name="getBuildDate", display="Get build date", auditable=false)
    public String getBuildDate() throws ClientException;

    @GET
    @Path(value="/status")
    @Operation(summary="Returns the status of the BridgeLink server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="status", ref="../apiexamples/integer_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="status", ref="../apiexamples/integer_json")})})
    @MirthOperation(name="getStatus", display="Get status")
    public int getStatus() throws ClientException;

    @GET
    @Path(value="/timezone")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns the time zone of the server.")
    @MirthOperation(name="getServerTimezone", display="Get server timezone", auditable=false)
    public String getServerTimezone() throws ClientException;

    @GET
    @Path(value="/time")
    @Operation(summary="Returns the time of the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverTime", ref="../apiexamples/calendar_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverTime", ref="../apiexamples/calendar_json")})})
    @MirthOperation(name="getServerTime", display="Get server time", auditable=false)
    public Calendar getServerTime() throws ClientException;

    @GET
    @Path(value="/jvm")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns the name of the JVM running BridgeLink.")
    @MirthOperation(name="getJVMName", display="Get JVM name", auditable=false)
    public String getJVMName() throws ClientException;

    @GET
    @Path(value="/about")
    @Operation(summary="Returns a map of common information about the BridgeLink server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="aboutMap", ref="../apiexamples/generic_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="aboutMap", ref="../apiexamples/generic_map_json")})})
    @MirthOperation(name="getAbout", display="Get about information", auditable=false)
    public Map<String, Object> getAbout() throws ClientException;

    @GET
    @Path(value="/configuration")
    @Operation(summary="Returns a ServerConfiguration object which contains all of the channels, alerts, configuration map, and properties stored on the BridgeLink server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverConfiguration", ref="../apiexamples/server_configuration_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverConfiguration", ref="../apiexamples/server_configuration_json")})})
    @MirthOperation(name="getServerConfiguration", display="Get server configuration", permission="backupServerConfiguration")
    public ServerConfiguration getServerConfiguration(@Param(value="initialState") @Parameter(description="The initial state to set all channels in the configuration to.", schema=@Schema(allowableValues={"STARTED", "PAUSED", "STOPPED"}, type="string")) @QueryParam(value="initialState") DeployedState var1, @Param(value="pollingOnly") @Parameter(description="If true, and the initialState parameter is set, only channels with polling source connectors will have their initial states overwritten in the returned server configuration.") @QueryParam(value="pollingOnly") boolean var2, @Param(value="disableAlerts") @Parameter(description="If true, all alerts returned in the server configuration will be disabled.") @QueryParam(value="disableAlerts") boolean var3) throws ClientException;

    @PUT
    @Path(value="/configuration")
    @Operation(summary="Updates all of the channels, alerts and properties stored on the BridgeLink server.")
    @MirthOperation(name="setServerConfiguration", display="Set server configuration", permission="restoreServerConfiguration", type=Operation.ExecuteType.ASYNC)
    public void setServerConfiguration(@Param(value="serverConfiguration") @RequestBody(description="The ServerConfiguration object containing all channels, users, alerts, and properties to update.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverConfiguration", ref="../apiexamples/server_configuration_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverConfiguration", ref="../apiexamples/server_configuration_json")})}) ServerConfiguration var1, @Param(value="deploy") @Parameter(description="If true, all enabled channels will be deployed after the configuration is restored.", schema=@Schema(defaultValue="false")) @QueryParam(value="deploy") boolean var2, @Param(value="overwriteConfigMap") @Parameter(description="If true, overwrite the Configuration Map") @QueryParam(value="overwriteConfigMap") boolean var3) throws ClientException;

    @GET
    @Path(value="/charsets")
    @Operation(summary="Returns a List of all of the charset encodings supported by the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="charsetEncodings", ref="../apiexamples/charset_encoding_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="charsetEncodings", ref="../apiexamples/charset_encoding_list_json")})})
    @MirthOperation(name="getAvailableCharsetEncodings", display="Get available charset encodings", auditable=false)
    public List<String> getAvailableCharsetEncodings() throws ClientException;

    @GET
    @Path(value="/settings")
    @Operation(summary="Returns a ServerSettings object with all server settings.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverSettings", ref="../apiexamples/server_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverSettings", ref="../apiexamples/server_settings_json")})})
    @MirthOperation(name="getServerSettings", display="Get server settings", permission="viewServerSettings", auditable=false)
    public ServerSettings getServerSettings() throws ClientException;

    @PUT
    @Path(value="/settings")
    @Operation(summary="Updates the server configuration settings.")
    @MirthOperation(name="setServerSettings", display="Set server settings", permission="editServerSettings")
    public void setServerSettings(@Param(value="settings") @RequestBody(description="The ServerSettings object containing all of the settings to update.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverSettings", ref="../apiexamples/server_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverSettings", ref="../apiexamples/server_settings_json")})}) ServerSettings var1) throws ClientException;

    @GET
    @Path(value="/publicSettings")
    @Operation(summary="Returns a PublicServerSettings object containing server settings available to all users.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="publicServerSettings", ref="../apiexamples/public_server_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="publicServerSettings", ref="../apiexamples/public_server_settings_json")})})
    @MirthOperation(name="getPublicServerSettings", display="Get public server settings", auditable=false)
    public PublicServerSettings getPublicServerSettings() throws ClientException;

    @GET
    @Path(value="/property")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns a property from the configuration table.")
    @MirthOperation(name="getProperty", display="Get property", auditable=false)
    public String getProperty(@Param(value="group") @Parameter(description="The property group.", required=true, schema=@Schema(type="string")) @QueryParam(value="group") String var1, @Param(value="name") @Parameter(description="The name of the property.", required=true, schema=@Schema(type="string")) @QueryParam(value="name") String var2) throws ClientException;

    @GET
    @Path(value="/encryption")
    @Operation(summary="Returns an EncryptionSettings object with all encryption settings.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="encryptionSettings", ref="../apiexamples/encryption_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="encryptionSettings", ref="../apiexamples/encryption_settings_json")})})
    @MirthOperation(name="getEncryptionSettings", display="Get encryption settings")
    public EncryptionSettings getEncryptionSettings() throws ClientException;

    @POST
    @Path(value="/_testEmail")
    @Operation(summary="Sends a test e-mail.")
    @MirthOperation(name="sendTestEmail", display="Send Test Email", permission="sendTestEmail")
    public ConnectionTestResponse sendTestEmail(@Param(value="properties") @RequestBody(description="Contains all properties needed to send the e-mail. Properties include: port, encryption, host, timeout, authentication, username, password, toAddress, fromAddress", required=true, content={@Content(mediaType="application/xml", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_json")})}) Properties var1) throws ClientException;

    @GET
    @Path(value="/updateSettings")
    @Operation(summary="Returns an UpdateSettings object with all update settings.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="updateSettings", ref="../apiexamples/update_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="updateSettings", ref="../apiexamples/update_settings_json")})})
    @MirthOperation(name="getUpdateSettings", display="Get update settings", auditable=false)
    public UpdateSettings getUpdateSettings() throws ClientException;

    @PUT
    @Path(value="/updateSettings")
    @Operation(summary="Updates the update settings.")
    @MirthOperation(name="setUpdateSettings", display="Set update settings", auditable=false)
    public void setUpdateSettings(@Param(value="settings") @RequestBody(description="The UpdateSettings object containing all of the settings to update.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="updateSetings", ref="../apiexamples/update_settings_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="updateSettings", ref="../apiexamples/update_settings_json")})}) UpdateSettings var1) throws ClientException;

    @GET
    @Path(value="/licenseInfo")
    @Operation(summary="Returns a LicenseInfo object with the expiration date and other information.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="licenseInfo", ref="../apiexamples/license_info_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="licenseInfo", ref="../apiexamples/license_info_json")})})
    @MirthOperation(name="getLicenseInfo", display="Get license info", auditable=false)
    public LicenseInfo getLicenseInfo() throws ClientException;

    @POST
    @Path(value="/_generateGUID")
    @Produces(value={"text/plain"})
    @Operation(summary="Returns a globally unique id.")
    @MirthOperation(name="getGuid", display="Get GUID", auditable=false)
    public String getGuid() throws ClientException;

    @GET
    @Path(value="/globalScripts")
    @Operation(summary="Returns a map containing all of the global scripts.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="globalScripts", ref="../apiexamples/global_scripts_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="globalScripts", ref="../apiexamples/global_scripts_json")})})
    @MirthOperation(name="getGlobalScripts", display="Get global scripts", permission="viewGlobalScripts")
    public Map<String, String> getGlobalScripts() throws ClientException;

    @PUT
    @Path(value="/globalScripts")
    @Operation(summary="Updates all of the global scripts.")
    @MirthOperation(name="setGlobalScripts", display="Set global scripts", permission="editGlobalScripts")
    public void setGlobalScripts(@Param(value="scripts") @RequestBody(description="The map of global scripts to update with. Script keys: Deploy, Undeploy, Preprocessor, Postprocessor", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="globalScripts", ref="../apiexamples/global_scripts_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="globalScripts", ref="../apiexamples/global_scripts_json")})}) Map<String, String> var1) throws ClientException;

    @GET
    @Path(value="/configurationMap")
    @Operation(summary="Returns all entries in the configuration map.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="configurationMap", ref="../apiexamples/configuration_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="configurationMap", ref="../apiexamples/configuration_map_json")})})
    @MirthOperation(name="getConfigurationMap", display="Get configuration map", permission="viewConfigurationMap")
    public Map<String, ConfigurationProperty> getConfigurationMap() throws ClientException;

    @PUT
    @Path(value="/configurationMap")
    @Operation(summary="Updates all entries in the configuration map.")
    @MirthOperation(name="setConfigurationMap", display="Set configuration map", permission="editConfigurationMap")
    public void setConfigurationMap(@Param(value="map") @RequestBody(description="The new configuration map to update with.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="configurationMap", ref="../apiexamples/configuration_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="configurationMap", ref="../apiexamples/configuration_map_json")})}) Map<String, ConfigurationProperty> var1) throws ClientException;

    @GET
    @Path(value="/databaseDrivers")
    @Operation(summary="Returns the database driver list.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="driverInfoList", ref="../apiexamples/driver_info_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="driverInfoList", ref="../apiexamples/driver_info_list_json")})})
    @MirthOperation(name="getDatabaseDrivers", display="Get database drivers", auditable=false, type=Operation.ExecuteType.ASYNC)
    public List<DriverInfo> getDatabaseDrivers() throws ClientException;

    @PUT
    @Path(value="/databaseDrivers")
    @Operation(summary="Updates the list of database drivers.")
    @MirthOperation(name="setDatabaseDrivers", display="Update database drivers", permission="editDatabaseDrivers")
    public void setDatabaseDrivers(@Param(value="drivers") @RequestBody(description="The new list of database drivers to update.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="driverInfoList", ref="../apiexamples/driver_info_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="driverInfoList", ref="../apiexamples/driver_info_list_json")})}) List<DriverInfo> var1) throws ClientException;

    @GET
    @Path(value="/passwordRequirements")
    @Operation(summary="Returns all password requirements for the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="passwordRequirements", ref="../apiexamples/password_requirements_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="passwordRequirements", ref="../apiexamples/password_requirements_json")})})
    @MirthOperation(name="getPasswordRequirements", display="Get password requirements")
    public PasswordRequirements getPasswordRequirements() throws ClientException;

    @GET
    @Path(value="/resources")
    @Operation(summary="Returns all resources for the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="resources", ref="../apiexamples/resource_properties_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="resources", ref="../apiexamples/resource_properties_list_json")})})
    @MirthOperation(name="getResources", display="Get resources", permission="viewResources", type=Operation.ExecuteType.ASYNC)
    public List<ResourceProperties> getResources() throws ClientException;

    @PUT
    @Path(value="/resources")
    @Operation(summary="Updates all resources for the server.")
    @MirthOperation(name="setResources", display="Set resources", permission="editResources", type=Operation.ExecuteType.ASYNC)
    public void setResources(@Param(value="resources") @RequestBody(description="The new list of resource properties to update with.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="resources", ref="../apiexamples/resource_properties_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="resources", ref="../apiexamples/resource_properties_list_json")})}) List<ResourceProperties> var1) throws ClientException;

    @POST
    @Path(value="/resources/{resourceId}/_reload")
    @Operation(summary="Reloads a resource and all libraries associated with it.")
    @MirthOperation(name="reloadResource", display="Reload resource", permission="reloadResources", type=Operation.ExecuteType.ASYNC)
    public void reloadResource(@Param(value="resourceId") @Parameter(description="The unique ID of the resource to reload.", required=true) @PathParam(value="resourceId") String var1) throws ClientException;

    @GET
    @Path(value="/channelDependencies")
    @Operation(summary="Returns all channel dependencies for the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelDependencies", ref="../apiexamples/channel_dependency_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelDependencies", ref="../apiexamples/channel_dependency_set_json")})})
    @MirthOperation(name="getChannelDependencies", display="Get channel dependencies", auditable=false)
    public Set<ChannelDependency> getChannelDependencies() throws ClientException;

    @PUT
    @Path(value="/channelDependencies")
    @Operation(summary="Updates all channel dependencies for the server.")
    @MirthOperation(name="setChannelDependencies", display="Set channel dependencies", permission="manageChannels")
    public void setChannelDependencies(@Param(value="dependencies") @RequestBody(description="The channel dependencies to set.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelDependencies", ref="../apiexamples/channel_dependency_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelDependencies", ref="../apiexamples/channel_dependency_set_json")})}) Set<ChannelDependency> var1) throws ClientException;

    @GET
    @Path(value="/channelMetadata")
    @Operation(summary="Returns all channel metadata for the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelMetadata", ref="../apiexamples/channel_metadata_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelMetadata", ref="../apiexamples/channel_metadata_map_json")})})
    @MirthOperation(name="getChannelMetadata", display="Get channel metadata", auditable=false)
    public Map<String, ChannelMetadata> getChannelMetadata() throws ClientException;

    @PUT
    @Path(value="/channelMetadata")
    @Operation(summary="Updates all channel metadata for the server.")
    @MirthOperation(name="setChannelMetadata", display="Set channel metadata", permission="manageChannels")
    public void setChannelMetadata(@Param(value="metadata") @RequestBody(description="The map of channel metadata to set.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelMetadata", ref="../apiexamples/channel_metadata_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelMetadata", ref="../apiexamples/channel_metadata_map_json")})}) Map<String, ChannelMetadata> var1) throws ClientException;

    @GET
    @Path(value="/protocolsAndCipherSuites")
    @Operation(summary="Returns a map containing all supported and enabled TLS protocols and cipher suites.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="protocolsAndCipherSuites", ref="../apiexamples/protocols_and_cipher_suites_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="protocolsAndCipherSuites", ref="../apiexamples/protocols_and_cipher_suites_map_json")})})
    @MirthOperation(name="getProtocolsAndCipherSuites", display="Get protocols and cipher suites", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, String[]> getProtocolsAndCipherSuites() throws ClientException;

    @GET
    @Path(value="/channelTags")
    @Operation(summary="Returns a set containing all channel tags for the server.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelTags", ref="../apiexamples/channel_tag_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelTags", ref="../apiexamples/channel_tag_set_json")})})
    @MirthOperation(name="getChannelTags", display="Get channel tags", permission="viewTags", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Set<ChannelTag> getChannelTags() throws ClientException;

    @PUT
    @Path(value="/channelTags")
    @Operation(summary="Updates all channel tags.")
    @MirthOperation(name="updateChannelTags", display="Update channel tags", permission="manageTags")
    public void setChannelTags(@Param(value="channelTags") @RequestBody(description="The channel tags to set.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelTags", ref="../apiexamples/channel_tag_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelTags", ref="../apiexamples/channel_tag_set_json")})}) Set<ChannelTag> var1) throws ClientException;

    @GET
    @Path(value="/rhinoLanguageVersion")
    @Operation(summary="Returns the language version that the Rhino engine should use.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="rhinoLanguageVersion", ref="../apiexamples/integer_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="rhinoLanguageVersion", ref="../apiexamples/integer_json")})})
    @MirthOperation(name="getRhinoLanguageVersion", display="Get rhino language version", type=Operation.ExecuteType.ASYNC, auditable=false)
    public int getRhinoLanguageVersion() throws ClientException;
}

